/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------
//		File:               qtvtkviewer.cxx
//		Programmer:         Prieto
//		Last modified:	25/08/11 (Release 0.1)
//		Description:	Sample program fro qtvtkviewer
//----------------------------------------------------------------------

#include "qtvtkviewerwidget.h"
#include <QMainWindow>
#include <QApplication>




#include "iostream"

#include "vtkMetaImageReader.h"
//#include "OpenImageDialog.h"

using namespace std;
//using namespace creaMaracasVisuKernel;

int main(int argc, char **argv)
{







    vtkImageData* img = 0;

    /*if (argc < 2){

        OpenImageDialog open(true);
        img = open.getImageData();

        if(img == 0){
            std::cout << "ERROR: Image filename missing. usage qtvtkviewer <image filename>"
                      << std::endl ;
            return EXIT_FAILURE;
         }
    }else*/
    if(argc==2){
        std::string inputFilename = argv[1];

        vtkMetaImageReader* reader = vtkMetaImageReader::New();
        reader->SetFileName(inputFilename.c_str());
        reader->Update();
        img = reader->GetOutput();
    }


    QApplication app(argc, argv);


    QMainWindow* mainwindow = new QMainWindow();

    QtVTKViewerWidget *viewer = new QtVTKViewerWidget(mainwindow);

    mainwindow-> setCentralWidget(viewer);
    mainwindow->setMinimumSize(1024, 768);

    mainwindow->showMaximized();

    if(img)
        viewer->setImage(img);
    //viewer->SetLookupTable((vtkLookupTable*)colortransfer);

    return app.exec();
}

