#-----------------------------------------------------------------------------
# DOES THE USER WANT TO BUILD THE PACKAGE ?
OPTION(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME} 
  "Build the bbtk package ${BBTK_PACKAGE_NAME} ?" OFF)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
IF(BBTK_CORE_PACKAGE)
  IF(NOT ${BBTK_PACKAGE_NAME}_EXCLUDE_FROM_BUILD_ALL)
    SWITCH_ON_IF_BUILD_ALL(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
  ENDIF(NOT ${BBTK_PACKAGE_NAME}_EXCLUDE_FROM_BUILD_ALL)
ENDIF(BBTK_CORE_PACKAGE)
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# IF THE USER HAS CHOSEN TO BUILD THE PACKAGE
IF(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
  #---------------------------------------------------------------------------
  
  #===========================================================================
  # If the package is not a "core" bbtk package (included into the toolkit)
  # then we have to find (and use) bbtk 
  IF(NOT BBTK_CORE_PACKAGE)
    #-------------------------------------------------------------------------
    # Find and use the Black Box Toolkit
    # Search BBTK
    FIND_PACKAGE(BBTK)
    # If bbtk found
    IF(BBTK_FOUND)
      INCLUDE(${BBTK_USE_FILE})
      SET(BBTK_PACKAGE_LIBS 
	${BBTK_PACKAGE_LIBS}
	${BBTK_LIBRARIES})
      MARK_AS_ADVANCED(BBTK_DIR)
    ENDIF(BBTK_FOUND)
  ENDIF(NOT BBTK_CORE_PACKAGE)
    
  #===========================================================================
  # Include package configuration cmake script from bbtk dir
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKConfigurePackage.cmake)
  #===========================================================================
  
  
  #---------------------------------------------------------------------------
ELSE(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
  #-------------------------------------------------------------------------
  
  #-----------------------------------------------------------------------
  IF(BBTK_CORE_PACKAGE)
    #-----------------------------------------------------------------------
    # If package deps in global deps : reset global deps
    IF(${BBTK_PACKAGE_NAME}_IN_DEPS)
      SET(BBTK_PACKAGES_DEPS "" CACHE INTERNAL 
	"bbtk packages dependencies" FORCE)
      #    STRING(REPLACE "${${BBTK_PACKAGE_NAME}_DEPS};"
      #      "" TEMP
      #      ${BBTK_PACKAGES_DEPS})
      #    
      #    SET(BBTK_PACKAGES_DEPS ${TEMP}
      #      CACHE INTERNAL "bbtk packages dependencies" FORCE)
    ENDIF(${BBTK_PACKAGE_NAME}_IN_DEPS)
    #-----------------------------------------------------------------------
    
    #-----------------------------------------------------------------------
    # Remove the package include scripts to avoid loading it by include * 
    FILE(REMOVE ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}.bbs)
    FILE(REMOVE ${BBTK_BBS_BUILD_PATH}/${BBTK_PACKAGE_NAME}-appli.bbs)
    #-----------------------------------------------------------------------
  ENDIF(BBTK_CORE_PACKAGE)
  
  #-------------------------------------------------------------------------
ENDIF(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
