/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//=====
// Don't edit this file. This file is generated from xml description..
//=====
#include "bbcreaMaracasVisuColorLayerImageView.h"
#include "bbcreaMaracasVisuPackage.h"

#include "ColorLayerImageViewPanel.h"

namespace bbcreaMaracasVisu
{


class ColorLayerImageView;

class ColorLayerImageViewPanel_widgetBox : public ColorLayerImageViewPanel
{
	public:
	ColorLayerImageViewPanel_widgetBox( wxWindow * parent, int min, int max,int opacity, int type  );
	void SetBox(ColorLayerImageView* box);
	void ChangeOpacity();
	private:
    ColorLayerImageView *mBox;
};

ColorLayerImageViewPanel_widgetBox::ColorLayerImageViewPanel_widgetBox( wxWindow * parent, int min, int max,int opacity, int type  )
	 : ColorLayerImageViewPanel( parent,  min, max, opacity, type  )
{
	mBox=NULL;
}

void ColorLayerImageViewPanel_widgetBox::ChangeOpacity()
{
	ColorLayerImageViewPanel::ChangeOpacity();
	if (mBox!=NULL)
	{
	   	mBox->bbSetOutputOutOpacity( GetOpacity() );
	   	mBox->bbSignalOutputModification();
	} // if mBox
}

void ColorLayerImageViewPanel_widgetBox::SetBox(ColorLayerImageView* box)
{
	mBox=box;	
}



BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ColorLayerImageView)
BBTK_BLACK_BOX_IMPLEMENTATION(ColorLayerImageView,bbtk::WxBlackBox);
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ColorLayerImageView::Process()
{
 
    if ( !( (bbGetInputWxVtkBaseView()==NULL) && (bbGetInputWxVtkBaseView1()==NULL) && (bbGetInputWxVtkBaseView2()==NULL))  )
    {
        ColorLayerImageViewPanel_widgetBox *clivp = (ColorLayerImageViewPanel_widgetBox*)bbGetOutputWidget();
           if (firsttime==true)
         {
    //        firsttime=false;
            clivp->SetActive( bbGetInputActive() );
         }
        clivp->GetColorLayerImageViewManager()->SetwxVtkBaseView( 0 , bbGetInputWxVtkBaseView() );
        clivp->GetColorLayerImageViewManager()->SetwxVtkBaseView( 1 , bbGetInputWxVtkBaseView1() );
        clivp->GetColorLayerImageViewManager()->SetwxVtkBaseView( 2 , bbGetInputWxVtkBaseView2() );
        std::vector<double> range = bbGetInputlstRangeForColorBar();
        clivp->GetColorLayerImageViewManager()->SetRangeForColorBar( range );
        std::vector<int> colorbarposition = bbGetInputColorBarPosition();
        clivp->GetColorLayerImageViewManager()->SetColorBarPosition( colorbarposition );
        std::vector<double> base_color = bbGetInputlstBaseColor();
        clivp->GetColorLayerImageViewManager()->SetBaseColors( base_color );
        std::vector<double> grey_level_boundaries = bbGetInputlstGreyLevelBoundaries();
        clivp->GetColorLayerImageViewManager()->SetGreyLevelBoundaries( grey_level_boundaries );
        std::vector<double> transparence_level_boundaries = bbGetInputlstTransparenceBoundaries();
        clivp->GetColorLayerImageViewManager()->SetBaseTransparence( transparence_level_boundaries );
        clivp->GetColorLayerImageViewManager()->SetPlainOrGradientColor( bbGetInputPlainOrGradientColor() );
        clivp->SetFittingMode( bbGetInputFittingMode() );
        clivp->SetImage( bbGetInputIn() );
        bbSetOutputNewImage( clivp->GetColorLayerImageViewManager()->GetImageChangeInformation(0) );
        bbSetOutputLookupTable( clivp->GetColorLayerImageViewManager()->GetLookupTable(0) );
           bbSetOutputOutOpacity( clivp->GetOpacity() );
        
          if (firsttime==true)
        {
            firsttime=false;
            clivp->ChangeOpacity();
            clivp->SetBox(this);
        }

    } else {
        printf("EED Error!!!  ColorLayerImageView::Process   (%s)  Missing Inputs:  WxVtkBaseView , WxVtkBaseView1 , WxVtkBaseView2 \n", bbGetFullName().c_str() );
    }// if xxVtkBaseView
    
}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ColorLayerImageView::CreateWidget(wxWindow* parent)
{
	ColorLayerImageViewPanel_widgetBox *clivp = new ColorLayerImageViewPanel_widgetBox(parent, 0, 100, bbGetInputOpacity() ,bbGetInputTypeControlsInterface() );
	bbSetOutputWidget( (ColorLayerImageViewPanel*)clivp );
}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ColorLayerImageView::bbUserSetDefaultValues()
{
    firsttime=true;
    bbSetInputIn(NULL);
    bbSetInputActive(true);
    bbSetInputOpacity(100);
    bbSetInputPlainOrGradientColor(false);
    bbSetInputTypeControlsInterface(1);
    bbSetInputWxVtkBaseView(NULL);
    bbSetInputWxVtkBaseView1(NULL);
    bbSetInputWxVtkBaseView2(NULL);

	std::vector<int> lstColorBarPosition;
	lstColorBarPosition.push_back(10);
	lstColorBarPosition.push_back(105);
	bbSetInputColorBarPosition(lstColorBarPosition);
}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ColorLayerImageView::bbUserInitializeProcessing()
{

}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ColorLayerImageView::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbcreaMaracasVisu
