/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuCutModule.h"
#include "bbcreaMaracasVisuPackage.h"
#include "creaSystem.h"

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,CutModule)
BBTK_BLACK_BOX_IMPLEMENTATION(CutModule,bbtk::WxBlackBox);

void CutModule::Process()
{
	vtkImageData* img = bbGetInputIn();
	vtkRenderWindowInteractor* interactor = bbGetInputInteractor();
	vtkRenderer* render = bbGetInputRenderer();

	if(img != NULL && interactor != NULL && render != NULL && _mainpanel!=NULL){
           if(_currentimage!=img){
             _currentimage=img;
             _mainpanel->setImageData(img);
           }

           _mainpanel->setInteractor(interactor);
           _mainpanel->setRenderer(render);
           bbSetOutputOut(_mainpanel->GetResultImage());
	}
}

void CutModule::CreateWidget(wxWindow* parent)
{
   std::string lastname("bbcreaMaracasVisu.dll"); // JPR
   std::string path = crea::System::GetDllAppPath(lastname);
   _mainpanel = CutModelMainPanel::getInstance(parent, path);
   _mainpanel->SetType(0);
	
   bbSetOutputWidget( _mainpanel); 
   Process();   
}

void CutModule::bbUserSetDefaultValues()
{	
	_mainpanel = NULL;
	_currentimage=NULL;
	bbSetInputIn(0);
	bbSetInputInteractor(0);
	bbSetInputRenderer(0);	
	bbSetOutputOut(0);
}

void CutModule::bbUserInitializeProcessing()
{
	
}

void CutModule::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbcreaMaracasVisu

