//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbcreaMaracasVisuManualContourModel_Box.h"
#include "bbcreaMaracasVisuPackage.h"

#include <creaContoursFactory.h>


namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ManualContourModel_Box)
BBTK_BLACK_BOX_IMPLEMENTATION(ManualContourModel_Box,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 


void ManualContourModel_Box::ProcessBySegment(	
			int Type, 
			int &iGeneral, int sizeSegment,
			std::vector<double> *lstInX,std::vector<double> *lstInY, std::vector<double> *lstInZ,
			std::vector<double> *lstOutX,std::vector<double> *lstOutY, std::vector<double> *lstOutZ,
			std::vector<int>	*lstIndexsOut, bool open )
{
	creaContoursFactory f;
	manualContourModel 	*m;
	int i,size=iGeneral+sizeSegment;
	double x,y,z;
	m = (manualContourModel*)f.getContourModel( bbGetInputType() );
	m->SetNumberOfPointsSpline( bbGetInputNbPoints() );
	m->SetCloseContour( open );
	for (i=iGeneral;i<size;i++)
	{
		m->AddPoint( (*lstInX)[i] , (*lstInY)[i] , (*lstInZ)[i] );
	} // for
	m->UpdateSpline();
	int sizeContour = bbGetInputNbPoints();
	for (i=0;i<sizeContour;i++)
	{
		m->GetSpline_i_Point(i,&x,&y,&z);
		lstOutX->push_back(x);
		lstOutY->push_back(y);
		lstOutZ->push_back(z);
	} // for
	iGeneral=iGeneral+sizeSegment;
	lstIndexsOut->push_back( sizeContour );
	delete m;
}


void ManualContourModel_Box::RedistributionPoints(	std::vector<double> *lstOutX,
													std::vector<double> *lstOutY, 
													std::vector<double> *lstOutZ,
													std::vector<int> *lstIndexsOut )
{
	std::vector<double> lstRstX;
	std::vector<double> lstRstY;
	std::vector<double> lstRstZ;
	int iLstIndexOut,sizeLstIndexOut = lstIndexsOut->size();
	int ii, iGeneral=0;
	int size;
	for (iLstIndexOut=0;  iLstIndexOut<sizeLstIndexOut; iLstIndexOut++)
	{
		lstRstX.clear();
		lstRstY.clear();
		lstRstZ.clear();
		size=(*lstIndexsOut)[iLstIndexOut];
		if (size>2)
		{
			double dist=0,dist2,distSeg,delta;
			double dd,dx,dy,dz;
			int i,k;
			for ( i=iGeneral+1 ; i<iGeneral+size ; i++ )
			{
				dx 	= (*lstOutX)[i]-(*lstOutX)[i-1];
				dy 	= (*lstOutY)[i]-(*lstOutY)[i-1];
				dz 	= (*lstOutZ)[i]-(*lstOutZ)[i-1];
				dist= dist+sqrt( dx*dx + dy*dy + dz*dz );
			} //for
			delta = dist/(size-1);
			lstRstX.push_back( (*lstOutX)[iGeneral] );
			lstRstY.push_back( (*lstOutY)[iGeneral] );
			lstRstZ.push_back( (*lstOutZ)[iGeneral] );
			for (i=iGeneral+1; i<iGeneral+size;i++)
			{
				dist2 = 0;
				for (k=iGeneral+1; k<iGeneral+size;k++)
				{
					dx = (*lstOutX)[k]-(*lstOutX)[k-1];
					dy = (*lstOutY)[k]-(*lstOutY)[k-1];
					dz = (*lstOutZ)[k]-(*lstOutZ)[k-1];
					distSeg = sqrt( dx*dx + dy*dy + dz*dz );
					ii = i-iGeneral;
					if ( dist2+distSeg >= ii*delta )
					{
						dd=(ii*delta-dist2)/distSeg;
						if (distSeg==0)
						{
							dd = 0;
						} // if distSeg == 0
						lstRstX.push_back( (*lstOutX)[k-1] + dd*dx );
						lstRstY.push_back( (*lstOutY)[k-1] + dd*dy );
						lstRstZ.push_back( (*lstOutZ)[k-1] + dd*dz );
						k=iGeneral+size;
					} else {
						if ( k==iGeneral+size-1 )
						{
							dd = 1;
							lstRstX.push_back( (*lstOutX)[k-1] + dd*dx );
							lstRstY.push_back( (*lstOutY)[k-1] + dd*dy );
							lstRstZ.push_back( (*lstOutZ)[k-1] + dd*dz );
						}
					}// if dist2 
					dist2 = dist2+distSeg;
				} // for k
			} //for i   
			if (lstRstX.size()!=size) 
			{
				printf("EED Warnning!   ManualContourModel_Box::RedistributionPoints  >> This list is not coherent  iLstIndexOut=%d  lstRstX.size()=%d  size=%d\n",iLstIndexOut, lstRstX.size(), size);
			}
			for (i=iGeneral; i<iGeneral+size;i++)
			{
				ii=i-iGeneral;
				(*lstOutX)[i] = lstRstX[ii];
				(*lstOutY)[i] = lstRstY[ii];
				(*lstOutZ)[i] = lstRstZ[ii];
			} // for i
		} // if size>2
		iGeneral=iGeneral+size;
	}// for iLstIndexOut
}


//-------------------------------------------------------------------------------------------------------------


void ManualContourModel_Box::ExtractContour(	std::vector<double> *lstX,
												std::vector<double> *lstY, 
												std::vector<double> *lstZ,
												std::vector<int> 	*lstIndexs,
												int contour,
												std::vector<double> *lstOutX,
												std::vector<double> *lstOutY, 
												std::vector<double> *lstOutZ )
{
	int 	i;
//	int 	iLstIndex;
	int 	iContour;
	int 	sizeLstIndexslstIndexs;
	int 	iGeneral;
	int 	iGeneralPlusSize;
	if ( (lstX!=NULL) &&  (lstY!=NULL) && (lstZ!=NULL) && (lstIndexs!=NULL) && (lstOutX!=NULL) && (lstOutY!=NULL) && (lstOutZ!=NULL) )
	{
		sizeLstIndexslstIndexs	= (*lstIndexs).size();
		if  ( sizeLstIndexslstIndexs!=0 ) 
		{
			(*lstOutX).clear();
			(*lstOutY).clear();
			(*lstOutZ).clear();
			iGeneral				= 0;
			iGeneralPlusSize		= (*lstIndexs)[0];
			for ( iContour=1 ; iContour<=contour ; iContour++ )
			{
				iGeneral			= iGeneral+(*lstIndexs)[iContour-1];
				iGeneralPlusSize	= iGeneral+(*lstIndexs)[iContour];
			} // for iContour
			for ( i=iGeneral ; i<iGeneralPlusSize ; i++ )
			{
				(*lstOutX).push_back( (*lstX)[i] );
				(*lstOutY).push_back( (*lstY)[i] );
				(*lstOutZ).push_back( (*lstZ)[i] );				
			} //for
		} // size
	} // NULL
}

void ManualContourModel_Box::PutPointsInContour(std::vector<double> *lstTmpX,
												std::vector<double> *lstTmpY, 
												std::vector<double> *lstTmpZ,
												int contour,
												std::vector<double> *lstOutX,
												std::vector<double> *lstOutY, 
												std::vector<double> *lstOutZ,
												std::vector<int> 	*lstOutIndexs )
{
	int 	i;
//	int 	iLstIndex;
	int 	iContour;
	int 	sizeLstIndexslstIndexs;
	int 	iGeneral;
	int 	iGeneralPlusSize;
	int 	iSize;
	int 	SizeContour;
	if ( (lstTmpX!=NULL) &&  (lstTmpY!=NULL) && (lstTmpZ!=NULL)  && (lstOutX!=NULL) && (lstOutY!=NULL) && (lstOutZ!=NULL) && (lstOutIndexs!=NULL) )
	{
		sizeLstIndexslstIndexs	= (*lstOutIndexs).size();
		if  ( sizeLstIndexslstIndexs!=0 ) 
		{
			iGeneral				= 0;
			SizeContour				= (*lstOutIndexs)[0];
			iGeneralPlusSize		= iGeneral + SizeContour;
			for ( iContour=1 ; iContour<=contour ; iContour++ )
			{
				iGeneral			= iGeneral + (*lstOutIndexs)[iContour-1];
				SizeContour 		= (*lstOutIndexs)[iContour];
				iGeneralPlusSize	= iGeneral + SizeContour;
			} // for iContour
			
			if(SizeContour==(*lstTmpX).size() )
			{
				int iSize=0;
				for ( i=iGeneral ; i<iGeneralPlusSize ; i++ )
				{
					(*lstOutX)[i] = (*lstTmpX)[iSize] ;
					(*lstOutY)[i] = (*lstTmpY)[iSize] ;
					(*lstOutZ)[i] = (*lstTmpZ)[iSize] ;
					iSize++;					
				} //for			
			} else {
				printf("EED Warnning!! ManualContourModel_Box::PutPointsInContour  the lstTmp vector is not of the correct size. SizeContour=%d  lstTmp.size=%d\n"
																										,SizeContour, (*lstTmpX).size() );
				for ( i=iGeneral ; i<iGeneralPlusSize ; i++ )
				{
					(*lstOutX)[i] = -9999 ;
					(*lstOutY)[i] = -9999 ;
					(*lstOutZ)[i] = -9999 ;
				} //for			
			}
		} // size
	} // NULL
}


void ManualContourModel_Box::Redistribution_SIN(	double alpha,
													double beta,
													std::vector<double> *lstC1X,
													std::vector<double> *lstC1Y, 
													std::vector<double> *lstC1Z,
													double sizeOfContour,
													std::vector<double> *lstC2X,
													std::vector<double> *lstC2Y, 
													std::vector<double> *lstC2Z  )
{
	std::vector<double> lstRstX;
	std::vector<double> lstRstY;
	std::vector<double> lstRstZ;
	int 	ii,iGeneral;
	int 	size,iGeneralPlusSize;
	int	 	iGeneralPlusSizeMoisUn;
	int	 	iGeneralPlusSizeMoisDeux;
	int 	i,k;
	int 	firstK;
	double 	iiByDelta;
	double 	dist2,distSeg;
	double 	dd,dx,dy,dz;
	double 	t,tt, PI;
	double 	TwoPI;
	double 	dist;
	dist		= sizeOfContour;
	PI			= 3.14159265;
	TwoPI		= 2*PI;
	iGeneral 	= 0;
	size = (*lstC1X).size();
	iGeneralPlusSize	= iGeneral+size;
	iGeneralPlusSizeMoisUn 		= iGeneralPlusSize-1;
	iGeneralPlusSizeMoisDeux 	= iGeneralPlusSize-2;
	if (size>2)
	{
		firstK	= 0;			
		for (i=iGeneral; i<iGeneralPlusSize;i++)     				//  For each point of one contour
		{
			ii 		= i-iGeneral;
			dist2 	= 0;

			t		= ((double)ii) / ((double)(size-1));
			tt 		= t + 0.70710678182*sin(t*TwoPI)*beta + alpha;
			if (tt>1) { tt=tt-1; }
			if (tt<0) { tt=tt+1; }
			iiByDelta = tt * dist;

			for ( k=iGeneral ; k<iGeneralPlusSizeMoisUn ; k++ )  		 	// Search inside
			{
				dx 		= (*lstC1X)[k+1]-(*lstC1X)[k];
				dy 		= (*lstC1Y)[k+1]-(*lstC1Y)[k];
				dz 		= (*lstC1Z)[k+1]-(*lstC1Z)[k];
				distSeg = sqrt( dx*dx + dy*dy + dz*dz );
				if ( dist2+distSeg >= iiByDelta )
				{
					if (distSeg==0)
					{
						dd = 0;
					} else {
						dd=(iiByDelta-dist2)/distSeg;
					}// if distSeg == 0
					lstRstX.push_back( (*lstC1X)[k] + dd*dx );
					lstRstY.push_back( (*lstC1Y)[k] + dd*dy );
					lstRstZ.push_back( (*lstC1Z)[k] + dd*dz );
					if (ii==0) { firstK=k; }
					k = iGeneralPlusSize-1;
				} else {
					if ( k==iGeneralPlusSizeMoisDeux )
					{
						dd = 1;
						lstRstX.push_back( (*lstC1X)[k] + dd*dx );
						lstRstY.push_back( (*lstC1Y)[k] + dd*dy );
						lstRstZ.push_back( (*lstC1Z)[k] + dd*dz );
					} // if k
				}// if dist2 
				dist2 = dist2 + distSeg;
			} // for k
		} //for i   			
		if (lstRstX.size()!=size) 
		{
			printf("EED Warnning!   ManualContourModel_Box::Redistribution_SIN  >> This list is not coherent lstRstX.size()=%d  size=%d\n", lstRstX.size(), size);
		}
		(*lstC2X).clear();
		(*lstC2Y).clear();
		(*lstC2Z).clear();
		for (i=iGeneral; i<iGeneralPlusSize;i++)
		{
			(*lstC2X).push_back(-1);	
			(*lstC2Y).push_back(-1);	
			(*lstC2Z).push_back(-1);	
		} // for i
		int iii;
		for (i=iGeneral; i<iGeneralPlusSize;i++)
		{
			ii				= i-iGeneral;
			iii				= iGeneral+ ( (i-iGeneral) + firstK) % size ;
			(*lstC2X)[iii]	= lstRstX[ii];
			(*lstC2Y)[iii]	= lstRstY[ii];
			(*lstC2Z)[iii]	= lstRstZ[ii];
		} // for i
		(*lstC2X)[iGeneralPlusSize-1]=(*lstC2X)[iGeneral];
		(*lstC2Y)[iGeneralPlusSize-1]=(*lstC2Y)[iGeneral];
		(*lstC2Z)[iGeneralPlusSize-1]=(*lstC2Z)[iGeneral];
	} else {
		for (i=0; i<size ; i++)
		{
			(*lstC2X)[i] = (*lstC1X)[i];
			(*lstC2Y)[i] = (*lstC1Y)[i];
			(*lstC2Z)[i] = (*lstC1Z)[i];
		} // for i
	}// if size>2
}

void ManualContourModel_Box::CopyContour2InContour1(
													std::vector<double> *lstInX,
													std::vector<double> *lstInY, 
													std::vector<double> *lstInZ,
													std::vector<double> *lstOutX,
													std::vector<double> *lstOutY, 
													std::vector<double> *lstOutZ )
{
	int i,sizeLstInX=(*lstInX).size();
	(*lstOutX).clear();	
	(*lstOutY).clear();	
	(*lstOutZ).clear();	
	for ( i=0 ; i<sizeLstInX ; i++ )
	{
		(*lstOutX).push_back( (*lstInX)[i] );
		(*lstOutY).push_back( (*lstInY)[i] );
		(*lstOutZ).push_back( (*lstInZ)[i] );
	} // for i
}

double ManualContourModel_Box::IntegralDistanceTwoContours(std::vector<double> *lstTmpAX,
															std::vector<double> *lstTmpAY, 
															std::vector<double> *lstTmpAZ,
															std::vector<double> *lstTmpBX,
															std::vector<double> *lstTmpBY, 
															std::vector<double> *lstTmpBZ )
{
	int 	i;
	double 	dx;
	double	dy;
	double	dz;
	double 	dist		= 0;
	int 	iSize		= (*lstTmpAX).size();
	for ( i=0 ; i<iSize ; i++ )
	{
		dx 		= (*lstTmpAX)[i]-(*lstTmpBX)[i];
		dy 		= (*lstTmpAY)[i]-(*lstTmpBY)[i];
		dz 		= (*lstTmpAZ)[i]-(*lstTmpBZ)[i];
//		dist	= dist + sqrt( dx*dx + dy*dy + dz*dz );
		dist	= dist +  (dx*dx + dy*dy + dz*dz) ;
	} //for i
	return dist;
}

void ManualContourModel_Box::findAlphaBetaSinDistribution( 	std::vector<double> *ptrLstTmp2X,
															std::vector<double> *ptrLstTmp2Y,
															std::vector<double> *ptrLstTmp2Z ,
															int sizeContour,
															std::vector<double> *ptrLstTmp1X,
															std::vector<double> *ptrLstTmp1Y,
															std::vector<double> *ptrLstTmp1Z,  
															double *alphaOut,
															double *betaOut) 
{
	std::vector<double> lstTmp2aX;
	std::vector<double> lstTmp2aY;
	std::vector<double> lstTmp2aZ;
	double 	alpha,iAlpha,deltaAlpha;
	double 	beta,iBeta,deltaBeta;
	double 	distAcum;
	double 	minDistAcum;
	deltaAlpha	= 0.1 / 2;	
	deltaBeta	= 0.01 / 2;	
	beta 		= 0.05;
	alpha		= 0;
	minDistAcum = 999999999999;
	for (iAlpha=0 ; iAlpha<1; iAlpha=iAlpha+deltaAlpha ) 
	{
		Redistribution_SIN( iAlpha,beta, ptrLstTmp2X,ptrLstTmp2Y,ptrLstTmp2Z ,sizeContour, &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		distAcum = IntegralDistanceTwoContours( ptrLstTmp1X,ptrLstTmp1Y,ptrLstTmp1Z , &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		if (distAcum<minDistAcum) 
		{
			alpha		= iAlpha;
			minDistAcum	= distAcum;
		} // if integerDist
	} // for alpha
// find Beta
	minDistAcum = 999999999999;
	for (iBeta=0.0 ; iBeta<0.2; iBeta=iBeta+deltaBeta) 
	{
		Redistribution_SIN( alpha,iBeta, ptrLstTmp2X,ptrLstTmp2Y,ptrLstTmp2Z ,sizeContour, &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		distAcum = IntegralDistanceTwoContours( ptrLstTmp1X,ptrLstTmp1Y,ptrLstTmp1Z , &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		if (distAcum<minDistAcum) 
		{
			beta		= iBeta;
			minDistAcum	= distAcum;
		} // if integerDist
	} // for iBeta			
	*alphaOut 	= alpha;
	*betaOut 	= beta;
}



double ManualContourModel_Box::SizeContour(	std::vector<double> *lstX,
											std::vector<double> *lstY, 
											std::vector<double> *lstZ)
{
	int 	i;
	double 	dx;
	double	dy;
	double	dz;
	double 	dist		= 0;
	int 	iSize		= (*lstX).size()  - 1;
	for ( i=0 ; i<iSize ; i++ )
	{
		dx 	= (*lstX)[i+1]-(*lstX)[i];
		dy 	= (*lstY)[i+1]-(*lstY)[i];
		dz 	= (*lstZ)[i+1]-(*lstZ)[i];
		dist= dist+sqrt( dx*dx + dy*dy + dz*dz );
	} //for i
	return dist;
}



void ManualContourModel_Box::CalculeLstSizeContours(	std::vector<double> *lstOutX,
														std::vector<double> *lstOutY,
														std::vector<double> *lstOutZ,
														std::vector<int> 	*lstIndexsOut,
														std::vector<double> *lstSizeContours	)
{
	int 	i;
//	int 	iLstIndex;
	int 	iContour;
	int 	sizeLstIndexs;
	int 	iGeneral;
	int 	iGeneralPlusSize;
	double  dx,dy,dz;
	double  dist;
	(*lstSizeContours).clear();
	if ( (lstOutX!=NULL) &&  (lstOutY!=NULL) && (lstOutZ!=NULL) && (lstIndexsOut!=NULL)  )
	{
		sizeLstIndexs	= (*lstIndexsOut).size();
		if  ( sizeLstIndexs!=0 ) 
		{	
			iGeneral				= 0;
			for ( iContour=0 ; iContour<sizeLstIndexs ; iContour++ )
			{
				dist 				= 0;
				iGeneralPlusSize	= iGeneral + (*lstIndexsOut)[iContour];
				for ( i=iGeneral+1 ; i<iGeneralPlusSize ; i++ )
				{
					dx 	= (*lstOutX)[i]-(*lstOutX)[i-1] ;
					dy 	= (*lstOutY)[i]-(*lstOutY)[i-1] ;
					dz 	= (*lstOutZ)[i]-(*lstOutZ)[i-1] ;
					dist= dist + sqrt( dx*dx +dy*dy + dz*dz );
				} // for iGeneral
				(*lstSizeContours).push_back( dist );
				iGeneral = iGeneralPlusSize;
			} // for iContour
		} // sizeLstIndexs 
	} // if lst NULL
}


void ManualContourModel_Box::RedistributionPointsAllContours_SIN(	std::vector<double> *lstOutX,
																	std::vector<double> *lstOutY, 
																	std::vector<double> *lstOutZ,
																	std::vector<int> 	*lstIndexsOut )
{
	std::vector<double> lstTmp1X;
	std::vector<double> lstTmp1Y;
	std::vector<double> lstTmp1Z;
	std::vector<double> lstTmp2X;
	std::vector<double> lstTmp2Y;
	std::vector<double> lstTmp2Z;
	std::vector<double> lstTmp2aX;
	std::vector<double> lstTmp2aY;
	std::vector<double> lstTmp2aZ;
	std::vector<double> lstTmp3X;
	std::vector<double> lstTmp3Y;
	std::vector<double> lstTmp3Z;
	std::vector<int>	lstContourExeption;
	std::vector<double>	lstSizeContours;
	int 	iContour;
	double 	nbContours		= (*lstIndexsOut).size();
	double 	alpha,beta;
	double 	sizeContour1;
	double 	sizeContour2;
	double 	sizeContour3;
	
	CalculeLstSizeContours(lstOutX,lstOutY,lstOutZ,lstIndexsOut, &lstSizeContours);
	
// ------------ Wave 1    Back to Fordward (redistribution for the little one)-----------------	
	ExtractContour(lstOutX,lstOutY,lstOutZ,lstIndexsOut,0,&lstTmp1X,&lstTmp1Y,&lstTmp1Z);
//	sizeContour1 	= SizeContour( &lstTmp1X, &lstTmp1Y, &lstTmp1Z );
	sizeContour1 = lstSizeContours[0];
	
// Increment	
	for ( iContour=0; iContour<nbContours-1 ; iContour++ )   // Back to Fordward
	{
		ExtractContour( lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour+1 ,&lstTmp2X,&lstTmp2Y,&lstTmp2Z );		
//		sizeContour2 	= SizeContour( &lstTmp2X, &lstTmp2Y, &lstTmp2Z );
		sizeContour2 = lstSizeContours[ iContour+1 ];
		
		if (iContour+2<nbContours)
		{
//			ExtractContour( lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour+2 ,&lstTmp3X,&lstTmp3Y,&lstTmp3Z );		
//			sizeContour3 	= SizeContour( &lstTmp3X, &lstTmp3Y, &lstTmp3Z );
			sizeContour3 = lstSizeContours[ iContour+2 ];
		} else {
			sizeContour3=-1;
		}
		if ( (sizeContour1>=sizeContour2) && (sizeContour2>sizeContour3) )
		{
			findAlphaBetaSinDistribution( &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2,  &lstTmp1X,&lstTmp1Y,&lstTmp1Z,  &alpha,&beta);
			Redistribution_SIN( alpha,beta, &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2, &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
 			  sizeContour2 					= SizeContour( &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		 	  lstSizeContours[ iContour+1 ]	= sizeContour2;
			PutPointsInContour(&lstTmp2aX,&lstTmp2aY,&lstTmp2aZ, iContour+1 ,lstOutX,lstOutY,lstOutZ,lstIndexsOut);				
			CopyContour2InContour1( &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ , &lstTmp1X,&lstTmp1Y,&lstTmp1Z );
		} else {
			if ( (sizeContour3!=-1) && (sizeContour1<sizeContour2) && (sizeContour2>sizeContour3) )  // Warning for a maximum local
			{
				lstInconsistentContourY.push_back( lstTmp2Y[0] );
				lstInconsistentContourID.push_back( iContour+1 );
		 	} // if maximum local
			CopyContour2InContour1( &lstTmp2aX,&lstTmp2Y,&lstTmp2Z , &lstTmp1X,&lstTmp1Y,&lstTmp1Z );
		 } //if sizeContour1>sizeContour2>sizeContour3		 
		sizeContour1 = sizeContour2;
	} // for iContour 

	
// ------------ Wave 2  fordward  to back  (redistribute the litle one)-----------------
	ExtractContour(lstOutX,lstOutY,lstOutZ,lstIndexsOut,nbContours-1,&lstTmp1X,&lstTmp1Y,&lstTmp1Z);
//	sizeContour1 	= SizeContour( &lstTmp1X, &lstTmp1Y, &lstTmp1Z );
	sizeContour1 	= lstSizeContours[ nbContours-1 ];

// Increment	
	for ( iContour=nbContours-1; iContour>0 ; iContour-- )  // Fordward to Back
	{
		ExtractContour( lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour-1 ,&lstTmp2X,&lstTmp2Y,&lstTmp2Z );		
//		sizeContour2 	= SizeContour( &lstTmp2X, &lstTmp2Y, &lstTmp2Z );
		sizeContour2 	= lstSizeContours[ iContour-1 ];
		if (iContour-2>=0)
		{
//			ExtractContour( lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour-2 ,&lstTmp3X,&lstTmp3Y,&lstTmp3Z );		
//			sizeContour3 	= SizeContour( &lstTmp3X, &lstTmp3Y, &lstTmp3Z );
			sizeContour3 	= lstSizeContours[ iContour-2 ];
		} else {
			sizeContour3=-1;
		}
		if ( (sizeContour1>sizeContour2) && (sizeContour2>sizeContour3) )
		{
			findAlphaBetaSinDistribution( &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2,  &lstTmp1X,&lstTmp1Y,&lstTmp1Z,  &alpha,&beta);
			Redistribution_SIN( alpha,beta, &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2, &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
 			  sizeContour2 					= SizeContour( &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		 	  lstSizeContours[ iContour-1 ]	= sizeContour2;
			PutPointsInContour(&lstTmp2aX,&lstTmp2aY,&lstTmp2aZ, iContour-1 ,lstOutX,lstOutY,lstOutZ,lstIndexsOut);			
			CopyContour2InContour1( &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ , &lstTmp1X,&lstTmp1Y,&lstTmp1Z );
		} else {
			if ( (sizeContour1>sizeContour2) && (sizeContour2<sizeContour3) )  // Warning for a minim local
		 	{
		 		lstContourExeption.push_back( iContour-1 );
		 	} // if minimum local
			if ( (sizeContour3!=-1) && (sizeContour1<sizeContour2) && (sizeContour2>sizeContour3) )  // Warning for a maximum local
			{
				lstInconsistentContourY.push_back( lstTmp2Y[0] );
				lstInconsistentContourID.push_back( iContour-1 );
			} // if Maximum local
			CopyContour2InContour1( &lstTmp2X,&lstTmp2Y,&lstTmp2Z , &lstTmp1X,&lstTmp1Y,&lstTmp1Z );
		} //if  sizeContour1>sizeContour2>sizeContour3
		sizeContour1 = sizeContour2;
	} // for iContour 

// ------------ Wave 3  redistribution for the minimun detected in Wave 1 -----------------
	double alpha1,alpha2;
	double beta1,beta2;
	double iExtra,sizeExtra=lstContourExeption.size();
	for ( iExtra=0 ; iExtra<sizeExtra ; iExtra++ )
	{	 
		iContour = lstContourExeption[iExtra];
		ExtractContour(lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour-1 , &lstTmp1X,&lstTmp1Y,&lstTmp1Z);
		ExtractContour(lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour 	, &lstTmp2X,&lstTmp2Y,&lstTmp2Z);
		ExtractContour(lstOutX,lstOutY,lstOutZ,lstIndexsOut, iContour+1 , &lstTmp3X,&lstTmp3Y,&lstTmp3Z);
//		sizeContour2 	= SizeContour( &lstTmp2X, &lstTmp2Y, &lstTmp2Z );
		sizeContour2 	= lstSizeContours[ iContour  ];
		printf("EED Warnning!  ManualContourModel_Box::RedistributionPointsAllContours_SIN  wave3 posible inconsistent contour y=%f  iContour=%d\n", lstTmp2Y[0], iContour );
		lstInconsistentContourY.push_back( lstTmp2Y[0] );
		lstInconsistentContourID.push_back( iContour );
		findAlphaBetaSinDistribution( &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2,  &lstTmp1X,&lstTmp1Y,&lstTmp1Z,  &alpha1,&beta1);
		findAlphaBetaSinDistribution( &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2,  &lstTmp3X,&lstTmp3Y,&lstTmp3Z,  &alpha2,&beta2);
		if (beta2>beta1)
		{
			alpha	= alpha2;
		} else {
			alpha	= alpha1;
		}
		beta = ( beta1 + beta2 ) / 2;
		Redistribution_SIN( alpha,beta, &lstTmp2X,&lstTmp2Y,&lstTmp2Z ,sizeContour2, &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
 			  sizeContour2 					= SizeContour( &lstTmp2aX,&lstTmp2aY,&lstTmp2aZ );
		 	  lstSizeContours[ iContour ]	= sizeContour2;
	 	PutPointsInContour(&lstTmp2aX,&lstTmp2aY,&lstTmp2aZ,  iContour  ,lstOutX,lstOutY,lstOutZ,lstIndexsOut);
	} // for iExtra


}
 
void ManualContourModel_Box::ClockwisePoints(	std::vector<double> *lstInX,
											std::vector<double> *lstInY, 
											std::vector<double> *lstInZ,
											std::vector<int> *lstIndexsIn )
{
	int 	iLstIndexIn,sizeLstIndexIn=lstIndexsIn->size();
	int 	i,iGeneral=0;
	int 	size,size2;
	double 	cx,cy,cz;
	double 	px,py,pz;
	double 	backpx,backpy,backpz;
	double 	ang;
	char   	dir=-1;
	bool 	dirx,diry,dirz;
	int 	flagAng=0;
	float 	backang;
	double 	tmp;

	// For each contour
	for (iLstIndexIn=0;  iLstIndexIn<sizeLstIndexIn; iLstIndexIn++)
	{
		// Step 1. Find gravity center and direction
		size  	= (*lstIndexsIn)[iLstIndexIn];
		if (size>2)  // for contour with more than 2 points
		{
			cx		= 0;
			cy		= 0;
			cz		= 0;
			dirx	= true;
			diry	= true;
			dirz	= true;
			for ( i=0 ; i<size ; i++ )
			{
				px=(*lstInX)[iGeneral+i];
				py=(*lstInY)[iGeneral+i];
				pz=(*lstInZ)[iGeneral+i];
				cx	= px + cx;
				cy	= py + cy;
				cz	= pz + cz;
				if (i!=0) 
				{ 
					if (backpx!=px) { dirx=false; } 
					if (backpy!=py) { diry=false; } 
					if (backpz!=pz) { dirz=false; } 
					backpx=px;
					backpy=py;
					backpz=pz;
				} // if i!=0
				backpx=px; 
				backpy=py; 
				backpz=pz; 
			} // for i 
			cx=cx/size;
			cy=cy/size;
			cz=cz/size;
			if (dirx==true) { dir=1; }  // YZ 
			if (diry==true) { dir=2; }  // XZ 
			if (dirz==true) { dir=0; }  // XZ 
			// Step 2. Find angle diference find 
			flagAng=0;
			for ( i=0 ; i<size ; i++ )
			{
				px = (*lstInX)[iGeneral+i]-cx;
				py = (*lstInY)[iGeneral+i]-cy;
				pz = (*lstInZ)[iGeneral+i]-cz;
				if (dir==0) { ang=atan2( py , px ); } // XY
				if (dir==1) { ang=atan2( pz , py ); } // YZ
				if (dir==2) { ang=atan2( pz , px ); } // XZ
				if (i>0) 
				{ 
					if (backang<ang) 
					{
						flagAng++;
					} else {
						flagAng--;
					}// if backang<ang
				} // if i
				backang=ang; 
			} // for i 


			// Step 3. Invert order of points
			if (flagAng<0)
			{
				size2 = size/2;
				for ( i=0 ; i<size2 ; i++ )
				{
					tmp 							= (*lstInX)[iGeneral+i];
					(*lstInX)[iGeneral+i]			= (*lstInX)[iGeneral+size-1-i];
					(*lstInX)[iGeneral+size-1-i]	= tmp;
					tmp 							= (*lstInY)[iGeneral+i];
					(*lstInY)[iGeneral+i]			= (*lstInY)[iGeneral+size-1-i];
					(*lstInY)[iGeneral+size-1-i]	= tmp;
					tmp 							= (*lstInZ)[iGeneral+i];
					(*lstInZ)[iGeneral+i]			= (*lstInZ)[iGeneral+size-1-i];
					(*lstInZ)[iGeneral+size-1-i]	= tmp;
				} // for i
			} // flagAng
		} // size>2
		iGeneral = iGeneral+size;
	} // for iLstIndexIn
}


void ManualContourModel_Box::ShiftValues(	std::vector<double> *lstInX,
											std::vector<double> *lstInY, 
											std::vector<double> *lstInZ,
											std::vector<int> *lstIndexsIn )
{
	int iLstIndexIn,sizeLstIndexIn=lstIndexsIn->size();
	int ii, iGeneral=0;
	int size,size2;
	double dist,distMin;
	int i,iBack;
	int ig;
	double dx,dy,dz;
	std::vector<double> LstTmpX;
	std::vector<double> LstTmpY;
	std::vector<double> LstTmpZ;
	if (sizeLstIndexIn>=2)
	{	 
		for (iLstIndexIn=0;  iLstIndexIn<sizeLstIndexIn-1; iLstIndexIn++)
		{
			size  = (*lstIndexsIn)[iLstIndexIn];
			size2 = (*lstIndexsIn)[iLstIndexIn+1];
			//find min distance and  iBack
			distMin = 10000000;
			iBack	= 0;
		    // Comparing distance between two contours	
		    // Both contours need the same size	
			for (ig=0; ig<size; ig++)
			{
				dist=0;
				for ( i=0 ; i<size2 ; i++ )
				{
					dx	= (*lstInX)[iGeneral+i]-(*lstInX)[iGeneral+size+(i+ig)%size];
					dy	= (*lstInY)[iGeneral+i]-(*lstInY)[iGeneral+size+(i+ig)%size];
					dz	= (*lstInZ)[iGeneral+i]-(*lstInZ)[iGeneral+size+(i+ig)%size];
					dist= dist + sqrt( dx*dx + dy*dy + dz*dz );
				} // for i size2
				if ( dist<distMin ) 
				{
					iBack	= ig+size;
					distMin	= dist;
				}			
			} // for ig size			
			if (iBack!=0)
			{
				LstTmpX.clear();
				LstTmpY.clear();
				LstTmpZ.clear();
				for (i=0 ; i<size2 ; i++) 
				{
					ii = (i+iBack)%size2;
					if (ii<(size2-1)) // Skip the last item
					{
						LstTmpX.push_back( (*lstInX)[iGeneral+size+ii] );
						LstTmpY.push_back( (*lstInY)[iGeneral+size+ii] );
						LstTmpZ.push_back( (*lstInZ)[iGeneral+size+ii] );
					}
				} // for i
				//Repeat the first item at the end to close the contour
				LstTmpX.push_back( LstTmpX[0] );
				LstTmpY.push_back( LstTmpY[0] );
				LstTmpZ.push_back( LstTmpZ[0] );
				for (i=0 ; i<size2 ; i++) 
				{
					(*lstInX)[iGeneral+size+i] = LstTmpX[i];
					(*lstInY)[iGeneral+size+i] = LstTmpY[i];
					(*lstInZ)[iGeneral+size+i] = LstTmpZ[i];
				} // for i				
			}
			iGeneral=iGeneral+size;
		} // for iLstIndexIn
	} // if sizeLstIndexIn
}



void ManualContourModel_Box::Process()
{
// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

//    bbSetOutputOut( bbGetInputIn() );
//    std::cout << "Output value = " <<bbGetOutputOut() << std::endl;

	if (bbGetInputActive()==true)
	{
		lstInconsistentContourY.clear();
		lstInconsistentContourID.clear();

		// First Step  Spline Interpolation
        
        std::vector<int>     lstIndexsIn = bbGetInputLstIndexsIn();
        std::vector<int>     lstIndexsOut;
        std::vector<double>  lstOutX;
        std::vector<double>  lstOutY;
        std::vector<double>  lstOutZ;

		std::vector<double> lstInX = bbGetInputLstControlPointsX();
		std::vector<double> lstInY = bbGetInputLstControlPointsY();
		std::vector<double> lstInZ = bbGetInputLstControlPointsZ();
        
        bool ok_abortMethod = false;
		if ( (lstInX.size()!=lstInY.size()) || (lstInY.size()!=lstInZ.size()) ) 
		{ 
            ok_abortMethod=true;
			printf("Warnning !!  .. ManualContourModel_Box: The list X Y Z, no have the same number of elements \n");
		}

        if ( (lstInX.size()==0) && (lstInY.size()==0) && (lstInZ.size()==0) )
        {
            ok_abortMethod=true;
            printf("Warnning !!  .. ManualContourModel_Box: The lists X Y Z, are empty \n");
        }

        if (ok_abortMethod==true)
        {
            bbSetOutputLstContourPointsX( lstOutX );
            bbSetOutputLstContourPointsY( lstOutY );
            bbSetOutputLstContourPointsZ( lstOutZ );
            bbSetOutputLstIndexsOut( lstIndexsOut );
            return;
        } // if 
        
        
        
		if (bbGetInputLstIndexsIn().size()==0)
		{
			lstIndexsIn.push_back( lstInX.size() );
		}
		
    // Step 0. Clean lstIndexIn
        int i,size    = lstIndexsIn.size();
        for (i=size-1 ; i>=0; i--)
        {
            if (lstIndexsIn[i]==0)
            {
                lstIndexsIn.erase( lstIndexsIn.begin()+i );
            } // if
        } // for i
        
	// Step 1.  All contours the same clockwise direction (Control Points)
		if ((bbGetInputDoubleContour()==1) && (bbGetInputOpenClose()==true))
		{
			ClockwisePoints( &lstInX , &lstInY , &lstInZ , &lstIndexsIn );  // wich is the plane base XY? XZ ZY  ??????
	//		ShiftValues( &lstInX , &lstInY , &lstInZ , &lstIndexsIn );
		} // DoubleContour
		size	= lstIndexsIn.size();
		int iGeneral= 0;
		
	// Step 2.  Spline interpolation of control points	
		for (i=0;i<size;i++)
		{
			ProcessBySegment(	bbGetInputType() , 
								iGeneral,  lstIndexsIn[i] ,
							 	&lstInX ,  &lstInY  , &lstInZ,
							 	&lstOutX , &lstOutY , &lstOutZ,
								&lstIndexsOut,bbGetInputOpenClose() );
		} // for

		if (bbGetInputDoubleContour()==0)
		{
	// Finish if Simple contours
			//////////////////// Set Out   DoubleContour = 0
			bbSetOutputLstContourPointsX(lstOutX);	
			bbSetOutputLstContourPointsY(lstOutY);	
			bbSetOutputLstContourPointsZ(lstOutZ);
			bbSetOutputLstIndexsOut(lstIndexsOut);	
		} else {
	// Step 3. Interpolation in the other direction
	// Step 3.1 Linear Normalice points around contours	
			RedistributionPoints(&lstOutX,&lstOutY,&lstOutZ,&lstIndexsOut);
	//EED 01/2021		
	// Step 3.2 Shift points to find minimun acumulate distance
            if (bbGetInputOpenClose()==true)
            {
                ShiftValues( &lstOutX, &lstOutY, &lstOutZ, &lstIndexsOut );
            } // if OpenClose
	// Step 3.3. SIN Normalice points around contours	
			if (bbGetInputParam().size()==2)
			{
				if (bbGetInputParam()[0]==1) // type param 1
				{
                    if (bbGetInputOpenClose()==true)
                    {
                        RedistributionPointsAllContours_SIN( &lstOutX,&lstOutY,&lstOutZ,&lstIndexsOut);
                        ShiftValues( &lstOutX, &lstOutY, &lstOutZ, &lstIndexsOut );
                    } // if OpenClose
                } // if type param =  1
			} // if size
	// Step 3.4 Transpose the vectors   
			lstInX.clear();
			lstInY.clear();
			lstInZ.clear();
			lstIndexsIn.clear();
			size  = bbGetInputNbPoints();
			int j,size2 = lstIndexsOut.size();
			for (i=0;i<size;i++)
			{
				for (j=0;j<size2;j++)
				{
					lstInX.push_back( lstOutX[ j*lstIndexsOut[j] + i ] );
					lstInY.push_back( lstOutY[ j*lstIndexsOut[j] + i ] );
					lstInZ.push_back( lstOutZ[ j*lstIndexsOut[j] + i ] );
				} // for j
				lstIndexsIn.push_back( size2 );
			} // for i
			lstOutX.clear();
			lstOutY.clear();
			lstOutZ.clear();
			lstIndexsOut.clear();
	// Step 3.5 Interponation 2
			size=lstIndexsIn.size();
			iGeneral=0;
			for (i=0;i<size;i++)
			{
				ProcessBySegment(	bbGetInputType() , 
									iGeneral, lstIndexsIn[i] ,
								 	&lstInX,&lstInY,&lstInZ,
								 	&lstOutX,&lstOutY,&lstOutZ,
									&lstIndexsOut,bbGetInputOpenClose2());
			} // for
			RedistributionPoints(&lstOutX,&lstOutY,&lstOutZ,&lstIndexsOut);
	// Step 3.6 Transpose the vectors   
			lstInX.clear();
			lstInY.clear();
			lstInZ.clear();
			lstIndexsIn.clear();
			size  = bbGetInputNbPoints();
			size2 = lstIndexsOut.size();
			for (i=0;i<size;i++)
			{
				for (j=0;j<size2;j++)
				{
					lstInX.push_back( lstOutX[ j*lstIndexsOut[j] + i ] );
					lstInY.push_back( lstOutY[ j*lstIndexsOut[j] + i ] );
					lstInZ.push_back( lstOutZ[ j*lstIndexsOut[j] + i ] );
				} // for j
				lstIndexsIn.push_back( size2 );
			} // for i
			lstOutX.clear();
			lstOutY.clear();
			lstOutZ.clear();
			lstIndexsOut.clear();
			//////////////////// Set Out   DoubleContour = 1
			bbSetOutputLstContourPointsX( lstInX );	
			bbSetOutputLstContourPointsY( lstInY );	
			bbSetOutputLstContourPointsZ( lstInZ );
			bbSetOutputLstIndexsOut( lstIndexsIn );	
			bbSetOutputLstPssblIncnsnstntCntrY( lstInconsistentContourY );
			bbSetOutputLstPssblIncnsnstntCntrID( lstInconsistentContourID );
		} // if DoubleContour 
	} // if Active
}

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ManualContourModel_Box::bbUserSetDefaultValues()
{
//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
   bbSetInputActive(true);
   bbSetInputType(1);   
   bbSetInputDoubleContour(0);
   bbSetInputOpenClose(false);
   bbSetInputOpenClose2(false);
   bbSetInputNbPoints(100); 
}

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ManualContourModel_Box::bbUserInitializeProcessing()
{
//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 
}

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ManualContourModel_Box::bbUserFinalizeProcessing()
{
//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any 
}

} // EO namespace bbcreaMaracasVisu


