/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuPlaneDirection.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,PlaneDirection)
BBTK_BLACK_BOX_IMPLEMENTATION(PlaneDirection,bbtk::WxBlackBox);
void PlaneDirection::Process()
{
	int radio = bbGetInputArrowSize();
	std::vector<int> lstPointsx = bbGetInputlstPointsX();
	std::vector<int> lstPointsy = bbGetInputlstPointsY();
	std::vector<int> lstPointsz = bbGetInputlstPointsZ();
	std::vector<double> _lstPointsx;
	std::vector<double> _lstPointsy;
	std::vector<double> _lstPointsz;
	vtkRenderer* render = bbGetInputRenderer();
	vtkImageData* img = bbGetInputIn();	
	std::string filename = bbGetInputFilename();

	_planedir->SetArrowSize(radio);
	if(render!=NULL){
		_planedir->SetRenderer(render);
	}

	if(lstPointsx.size()>0&&lstPointsy.size()>0&&lstPointsz.size()>0){
		double* spc;
		if(img != NULL){
			spc = img->GetSpacing();
		}else{
			spc = new double[3];
            spc[0]=1;
			spc[1]=1;
			spc[2]=1;
		}
		
		int i;
		for(i = 0; i < (int)lstPointsx.size();i++){			
			_lstPointsx.push_back(lstPointsx[i]*spc[0]);
			_lstPointsy.push_back(lstPointsy[i]*spc[1]);
			_lstPointsz.push_back(lstPointsz[i]*spc[2]);
		}		
		
		_planedir->SetVectors(_lstPointsx, _lstPointsy, _lstPointsz);
		_planedir->UpdateDirections();
		if(filename.compare("")!=0){
			_planedir->WriteInformation(filename,spc);
		}
	}
}

void PlaneDirection::CreateWidget(wxWindow* parent)
{
	_planedir = PlaneDirectionViewer::getInstance(parent, radio, colour, opacity);
   bbSetOutputWidget( _planedir );      
}

void PlaneDirection::bbUserSetDefaultValues()
{
	radio = 5;
	colour[0] = 1;
	colour[1] = 0;
	colour[2] = 0;
	opacity = 100;
}

void PlaneDirection::bbUserInitializeProcessing()
{
	std::vector<int> temp;
	bbSetInputFilename("");
	bbSetInputRenderer(0);
	bbSetInputIn(0);
	bbSetInputlstPointsX(temp);
	bbSetInputlstPointsY(temp);
	bbSetInputlstPointsZ(temp);
}

void PlaneDirection::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbcreaMaracasVisu


