/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuRenderingViewer.h"
#include "bbcreaMaracasVisuPackage.h"

#include "wxMaracasRendererView.h"
#include "wxMaracasRenderTabbedPanel.h"

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,RenderingViewer)
BBTK_BLACK_BOX_IMPLEMENTATION(RenderingViewer,bbtk::WxBlackBox);
void RenderingViewer::Process()
{
	wxMaracasRendererView* view = (wxMaracasRendererView*)bbGetOutputWidget();
	vtkImageData* _img1 = bbGetInputIn1();
	vtkImageData* _img2 = bbGetInputIn2();
	vtkImageData* _img3 = bbGetInputIn3();
	vtkImageData* _img4 = bbGetInputIn4(); 

	vtkRenderer* renderer = bbGetInputRenderer();

	if(view != NULL)
	{
		view->setVtkBaseView( (wxVtk3DBaseView*) bbGetInputwxVtkBaseView() );

		if(renderer != NULL && _currentrenderer != renderer)
		{
			view->setRenderer(renderer);
			_currentrenderer = renderer;
			//_currentrendererSA = rendererSA;
			//_currentrendererSB = rendererSB;
			//_currentrendererSC = rendererSC;
		}
		if(_currentrenderer!=NULL /*&& _currentrendererSA!=NULL && _currentrendererSB!=NULL && _currentrendererSC!=NULL*/)
		{
			if(_img1 !=NULL)
			{
				view->addVolumes(_img1, "","INPUT 1");
			}
			if(_img2 !=NULL)
			{
				view->addVolumes(_img2, "", "INPUT 2");
			}
			if(_img3 !=NULL)
			{
				view->addVolumes(_img3, "", "INPUT 3");
			}
			if(_img4 !=NULL)
			{
				view->addVolumes(_img4, "", "INPUT 4");
			}
		}		
	} 

	bbSetOutputImageFiles( view->getFiles() );

}
void RenderingViewer::CreateWidget(wxWindow* parent)
{
	wxMaracasRendererView* surrend = wxMaracasRendererView::getInstance(parent);
	bbSetOutputWidget(surrend);
}
void RenderingViewer::bbUserSetDefaultValues()
{
	bbSetInputIn1(NULL);
	bbSetInputIn2(NULL);
	bbSetInputIn3(NULL);
	bbSetInputIn4(NULL);
	bbSetInputRenderer(NULL);
	bbSetOutputWidget(NULL);
	bbSetOutputOut1(NULL);
	bbSetOutputOut2(NULL);
	bbSetOutputOut3(NULL);
	bbSetOutputOut4(NULL);
}
void RenderingViewer::bbUserInitializeProcessing()
{

}
void RenderingViewer::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbcreaMaracasVisu


