/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuSliceImage.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,SliceImage)
BBTK_BLACK_BOX_IMPLEMENTATION(SliceImage,bbtk::AtomicBlackBox);

void SliceImage::Process()
{
	vtkImageData *imagedata=NULL;

	//std::cout<<"MSJ: test SliceImage::Process()"<<this<<std::endl;
	if ( bbGetInputIn()!=NULL )
	{

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
  	  	imageReslice->SetInput( bbGetInputIn() );
#else
  	  	imageReslice->SetInputData( bbGetInputIn() );
#endif

  	  	imageReslice->SetInformationInput(bbGetInputIn() );

	  	double slice=bbGetInputSlice();
	  	if (slice<0) 
      	{ 
 			slice=0;
      	} 

	  	if (bbGetInputTypeOrientation()==3)
	  	{
		// Orientation 3 = FREE
		// v1 = [ v1x , v1y , v1z ]
		// v2 = [ v2x , v2y , v2z ]
		// v3 = [ v3x , v3y , v3z ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines( bbGetInputResliceAxesDirectionCosines()[0],  // v1x
                                                             bbGetInputResliceAxesDirectionCosines()[3],  // v2x
                                                             bbGetInputResliceAxesDirectionCosines()[6],  // v3x
                                                             bbGetInputResliceAxesDirectionCosines()[1],  // v1y
                                                             bbGetInputResliceAxesDirectionCosines()[4],  // v2y
                                                             bbGetInputResliceAxesDirectionCosines()[7],  // v3y
                                                             bbGetInputResliceAxesDirectionCosines()[2],  // v1z
                                                             bbGetInputResliceAxesDirectionCosines()[5],  // v2z
                                                             bbGetInputResliceAxesDirectionCosines()[8]   // v3z
                                                           );  
           std::vector<double> AxOr = bbGetInputAxisOrigin();
           double spc[3];
           bbGetInputIn()->GetSpacing(spc);
		   if (AxOr.size()==3)
		   {
	  	       imageReslice->SetResliceAxesOrigin( AxOr[0]*spc[0]  ,   AxOr[1]*spc[1]  ,  AxOr[2]*spc[2]  );
  	      } else {
	  	       imageReslice->SetResliceAxesOrigin( slice*bbGetInputIn()->GetSpacing()[0] ,0 ,0);  	      	
  	      }
	  } else if (bbGetInputTypeOrientation()==2)
	  {
		// Orientation 2 = Y-Z
		// v1 = [ 0 , 1 ,0 ]
		// v2 = [ 0 , 0 ,-1 ]
		// v3 = [ -1 ,0 , 0 ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines( 0,1,0,    0,0,-1,   -1,0,0 );  
	  } else if (bbGetInputTypeOrientation()==-2)
	  {
		// Orientation -2 = ZY
		// v1 = [ 0 , 0 , 1 ]
		// v2 = [ 0 , 1 , 0 ]
		// v3 = [ -1, 0 , 0 ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines( 0,0,1,    0,1,0,   -1,0,0 );  
  	       imageReslice->SetResliceAxesOrigin( slice*bbGetInputIn()->GetSpacing()[0] ,0 ,0);
	  } else if (bbGetInputTypeOrientation()==1) {     
		// Orientation 1 = X-Z  
		// v1 = [ 1 , 0 , 0 ]
		// v2 = [ 0 , 0 , -1 ]
		// v3 = [ 0 ,1 , 0 ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines( 1,0,0,   0,0,-1,   0,1,0 ); 
	       imageReslice->SetResliceAxesOrigin(0, slice*bbGetInputIn()->GetSpacing()[1],0 );
	  } else if (bbGetInputTypeOrientation()==-1) {     
		// Orientation -1 = XZ 
		// v1 = [ 1 , 0 , 0 ]
		// v2 = [ 0 , 0 , 1 ]
		// v3 = [ 0 ,-1 , 0 ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines( 1,0,0,   0,0,1,   0,-1,0 ); 
	       imageReslice->SetResliceAxesOrigin(0, slice*bbGetInputIn()->GetSpacing()[1],0 );
	  } else    {
		// Orientation 0 = XY
		// v1 = [ 1 , 0 , 0 ]
		// v2 = [ 0 , 1 , 0 ]
		// v3 = [ 0 , 0 , 1 ]
		// SetResliceAxesDirectionCosines(v1x,v2x,v3x,v1y,v2y,v3y,v1z,v2z,v3z);
	       imageReslice->SetResliceAxesDirectionCosines(1,0,0, 0,1,0 ,0,0,1);   
	       imageReslice->SetResliceAxesOrigin(0,0, slice*bbGetInputIn()->GetSpacing()[2] );
	  } 
	  imageReslice->SetOutputDimensionality(2);

		if ( bbGetInputInterpolationMode()==0) { imageReslice->SetInterpolationModeToNearestNeighbor();	}
		if ( bbGetInputInterpolationMode()==1) { imageReslice->SetInterpolationModeToLinear();			}
		if ( bbGetInputInterpolationMode()==2) { imageReslice->SetInterpolationModeToCubic();			}
			
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	  imagedata = imageReslice->GetOutput();
	  imagedata->Update();
	  imagedata->UpdateInformation();	
#else
	  imageReslice->Update();
	  imagedata = imageReslice->GetOutput();
#endif

  	}
  bbSetOutputOut( imagedata );
}
	
	
	//-----------------------------------------------------------------	
	void SliceImage::bbUserSetDefaultValues()
	{
		bbSetInputIn(NULL);
		bbSetInputZ(0);
		bbSetInputSlice(0);
		bbSetInputInterpolationMode(0);  // Linear
		bbSetInputTypeOrientation(0);
		imageReslice=NULL;
 		std::vector<double> lstCos;
                lstCos.push_back(1); // v1x
                lstCos.push_back(0); // v1y
                lstCos.push_back(0); // v1z

                lstCos.push_back(0); // v2x
                lstCos.push_back(1); // v2y
                lstCos.push_back(0); // v2z

                lstCos.push_back(0); // v3x
                lstCos.push_back(0); // v3y
                lstCos.push_back(1); // v3z
                bbSetInputResliceAxesDirectionCosines(lstCos);
	}
	
	//-----------------------------------------------------------------	
	void SliceImage::bbUserInitializeProcessing()
	{
		imageReslice = vtkImageReslice::New();
	}
	
	//-----------------------------------------------------------------	
	void SliceImage::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	
	
}
// EO namespace bbcreaMaracasVisu


