/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuSurfaceRendering.h"
#include "bbcreaMaracasVisuPackage.h"


#include "wxMaracasSurfaceRendering.h"

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,SurfaceRendering)
BBTK_BLACK_BOX_IMPLEMENTATION(SurfaceRendering,bbtk::WxBlackBox);
void SurfaceRendering::Process()
{

	wxMaracasSurfaceRendering* surrend = wxMaracasSurfaceRendering::getInstance();
	std::vector<vtkImageData*> tempvect;
	int i;

	if(surrend != NULL){
		vtkRenderer* renderer = bbGetInputRenderer();
		vtkRenderWindowInteractor* interactor = bbGetInputInteractor();
		surrend->setRenderer(renderer);
		surrend->setInteractor(interactor);
		vtkImageData* prop3D;
		tempvect.push_back(bbGetInputIn0());
		tempvect.push_back(bbGetInputIn1());
		tempvect.push_back(bbGetInputIn2());
		tempvect.push_back(bbGetInputIn3());
		tempvect.push_back(bbGetInputIn4());

		for(i = 0; i < (int)tempvect.size();i++){
			prop3D = tempvect[i];
			if(prop3D != NULL&&renderer != NULL){
				surrend->addPropMHD(prop3D);
			}
		}
	}  
}
void SurfaceRendering::CreateWidget(wxWindow* parent)
{


	//std::cout << "Your application's directory is: " << path;

	wxMaracasSurfaceRendering* surrend = wxMaracasSurfaceRendering::getInstance(parent);
	//GetDllDirectory(_MAX_PATH, currentPath);
	//std::cout << "Your application's directory is: " << GetDllDirectory(_MAX_PATH, currentPath)<<std::endl;

	bbSetOutputWidget(surrend);
  
}

	//-----------------------------------------------------------------	
	void SurfaceRendering::bbUserSetDefaultValues()
	{
		bbSetInputIn0(NULL);
		bbSetInputIn1(NULL);
		bbSetInputIn2(NULL);
		bbSetInputIn3(NULL);
		bbSetInputIn4(NULL);
		bbSetInputRenderer(NULL);
		bbSetInputInteractor(NULL);
		bbSetOutputWidget(NULL);
		bbSetOutputOut1(NULL);
		bbSetOutputOut2(NULL);
		bbSetOutputOut3(NULL);
		bbSetOutputOut4(NULL);
	}
	
	//-----------------------------------------------------------------	
	void SurfaceRendering::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void SurfaceRendering::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	
	

}
// EO namespace bbcreaMaracasVisu


