/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbcreaMaracasVisuTubeFilter.h"
#include "bbcreaMaracasVisuPackage.h"


#include <vtkPolyData.h>
#include <vtkPoints.h>
#include <vtkCellArray.h>
#include <vtkDoubleArray.h>
#include <vtkPolyData.h>
#include <vtkPointData.h>

#include <vtkCell.h>
#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkDataSetAttributes.h>
#include <vtkProperty.h>
#include <vtkTubeFilter.h>

#include <vtkDataSetMapper.h>
#include <vtkPolyDataMapper.h>


namespace bbcreaMaracasVisu
{

	MaracasTubeFilter::MaracasTubeFilter()
	{
	}

	MaracasTubeFilter::~MaracasTubeFilter()
	{
		// Interface Update
		if (renderer!=NULL )
		{
			renderer->RemoveActor(actor);
		}
		
	}
	

	void MaracasTubeFilter::SetvtkRenderer(vtkRenderer *render)
	{
		this->renderer = render;
	}
	

	
	void MaracasTubeFilter::SetlstPoints( std::vector<double> lstPointX , std::vector<double> lstPointY , std::vector<double> lstPointZ )
	{
		this->lstPointX = lstPointX;
		this->lstPointY = lstPointY;
		this->lstPointZ = lstPointZ;
	}
	
	
	void MaracasTubeFilter::SetlstColour( std::vector<double> lstColour  )
	{
		this->lstColour=lstColour;
	}

	
	void MaracasTubeFilter::SetlstRadius( std::vector<double> lstRadius  )
	{
		this->lstRadius = lstRadius;
	}
	
	void MaracasTubeFilter::SetOpacity(double opacity)
	{
		this->opacity = opacity;
	}
	
	void MaracasTubeFilter::SetTransform( vtkLinearTransform* transform  )
	{
		this->transform = transform;
	}

	vtkActor *MaracasTubeFilter::GetActor()
	{
		return actor;
	}
	
	void MaracasTubeFilter::Run()
	{
		unsigned int i;
		unsigned int nTv = 8;       // No. of surface elements for each tube vertex		
		
		// Create points and cells 
		vtkSmartPointer<vtkPoints> points = vtkSmartPointer<vtkPoints>::New();
		for(i = 0; i < lstPointX.size(); i++)
		{
			points->InsertPoint(i, lstPointX[i],  lstPointY[i],  lstPointZ[i]);
		}
		
		vtkSmartPointer<vtkCellArray> lines =	vtkSmartPointer<vtkCellArray>::New();
		lines->InsertNextCell( lstPointX.size() );
		for (i = 0; i < lstPointX.size(); i++)
		{
			lines->InsertCellPoint(i);
		}
		
		vtkSmartPointer<vtkPolyData> polyData =	vtkSmartPointer<vtkPolyData>::New();
		polyData->SetPoints(points);
		polyData->SetLines(lines);
		
		double radio;
		// Varying tube radius using sine-function
		vtkSmartPointer<vtkDoubleArray> tubeRadius = vtkSmartPointer<vtkDoubleArray>::New();
		tubeRadius->SetName("TubeRadius");
		tubeRadius->SetNumberOfTuples( lstPointX.size() );
		for (i=0 ;i<lstPointX.size() ; i++)
		{
			if (lstRadius.size()==0)
			{ 
			   radio=1;
			} else if (i<lstRadius.size()) {
			  radio = lstRadius[i];
			} else if (i>=lstRadius.size()) {
			  radio= lstRadius[ lstRadius.size()-1 ];
			}   

			tubeRadius->SetTuple1(i, radio );
		}
		polyData->GetPointData()->AddArray(tubeRadius);
		polyData->GetPointData()->SetActiveScalars("TubeRadius");
		
		// RBG array (could add Alpha channel too I guess...)
		// Varying from blue to red
		vtkSmartPointer<vtkUnsignedCharArray> colors = vtkSmartPointer<vtkUnsignedCharArray>::New();
		colors->SetName("Colors");
		colors->SetNumberOfComponents(3);
		colors->SetNumberOfTuples( lstPointX.size() );
		int numberOfColours = lstColour.size()/3;
		int indexcolour;
		for (i = 0; i < lstPointX.size() ;i++)
		{			
			if (numberOfColours==0){
				colors->InsertTuple3(i, 1 ,  1 ,  1 );
			} else {
				if (i<numberOfColours){
					indexcolour=i*3;
				} else {
					indexcolour=(numberOfColours-1)*3;
				}
				colors->InsertTuple3(i, 255*lstColour[indexcolour+0] ,  255*lstColour[indexcolour+1] ,  255*lstColour[indexcolour+2] );
			}
		} // for
		polyData->GetPointData()->AddArray(colors);
		
		vtkSmartPointer<vtkTubeFilter> tube = vtkSmartPointer<vtkTubeFilter>::New();
		tube->CappingOn();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		tube->SetInput(polyData);
#else
		tube->SetInputData(polyData);
#endif

		tube->SetNumberOfSides(nTv);
		tube->SetVaryRadiusToVaryRadiusByAbsoluteScalar();
		
		vtkSmartPointer<vtkPolyDataMapper> mapper =	vtkSmartPointer<vtkPolyDataMapper>::New();
		mapper->SetInputConnection(tube->GetOutputPort());
//		mapper->ScalarVisibilityOn();
//		mapper->SetScalarModeToUsePointFieldData();
		
		mapper->ScalarVisibilityOn();
		
//		mapper->SetScalarModeToUseCellData();
//		mapper->SetScalarModeToUseCellFieldData();
//		mapper->SetScalarModeToUseFieldData();
//		mapper->SetScalarModeToUsePointData();
		mapper->SetScalarModeToUsePointFieldData();
		
		mapper->SetColorModeToDefault();
//		mapper->SetColorModeToMapScalars();		
		
		
		mapper->SelectColorArray("Colors");
		
		//		vtkSmartPointer<vtkActor> actor =vtkSmartPointer<vtkActor>::New();
		actor = vtkSmartPointer<vtkActor>::New();
		actor->SetMapper(mapper);
		actor->GetProperty()->SetOpacity( opacity );

		if ( transform!=NULL )
		{
			actor->SetUserTransform( transform );
		}
		
		// Interface Update
		if (renderer!=NULL )
		{
			renderer->AddActor(actor);
		}
				
	}
	
	
	
	
BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,TubeFilter)
BBTK_BLACK_BOX_IMPLEMENTATION(TubeFilter,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TubeFilter::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')
	
	if (tubefilter!=NULL) 
	{ 
		delete tubefilter;
	}
	
	tubefilter = new MaracasTubeFilter();
	tubefilter->SetvtkRenderer( bbGetInputRenderer() );	
	tubefilter->SetlstPoints( bbGetInputlstPointX(), bbGetInputlstPointY(), bbGetInputlstPointZ() );

	// Sets the default value for radius to 1 everywhere, if the radius input vevctor is empty.
	if (bbGetInputlstRadio().size() == 0)
	  {
	    std::vector<double> radio;
	    radio.resize(bbGetInputlstPointX().size(), 1.);
	    bbSetInputlstRadio(radio);
	  }
	tubefilter->SetlstRadius( bbGetInputlstRadio() );
	tubefilter->SetOpacity( bbGetInputOpacity() );
	tubefilter->SetTransform( bbGetInputTransform() );	
	tubefilter->SetlstColour( bbGetInputColour() );	
	tubefilter->Run();
    bbSetOutputOutAxis( tubefilter->GetActor() );	
}
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TubeFilter::bbUserSetDefaultValues()
{
//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
	bbSetInputOpacity(1);
	bbSetInputTransform(NULL);
	
	std::vector<double> colour;
	// 0- gray
	colour.push_back(1.0);
	colour.push_back(0.0);
	colour.push_back(0.0);
	bbSetInputColour(colour);

 	std::vector<double> lstRadius;
	lstRadius.push_back(1);
        bbSetInputColour(lstRadius);
}
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TubeFilter::bbUserInitializeProcessing()
{
//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 	
	tubefilter = NULL; 
}
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TubeFilter::bbUserFinalizeProcessing()
{
//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
}
	
}
// EO namespace bbcreaMaracasVisu


