/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
#include "bbcreaMaracasVisuTubeTreeFilter.h"
#include "bbcreaMaracasVisuPackage.h"

#include <vtkSmartPointer.h>
#include <vtkDoubleArray.h>
#include <vtkPolyData.h>
#include <vtkPointData.h>
#include <vtkTubeFilter.h>
#include "vtkObjectFactory.h"


	
	vtkStandardNewMacro(vtkLookupTableEED);
	
	// Construct with range=(0,1); and hsv ranges set up for rainbow color table 
	// (from red to blue).
	vtkLookupTableEED::vtkLookupTableEED(int sze, int ext)
	{
		this->TableRange[0] = 0.0;
		this->TableRange[1] = 1.0;
	}
	
	//----------------------------------------------------------------------------
	vtkLookupTableEED::~vtkLookupTableEED()
	{
	}
	
	
	
	unsigned char *vtkLookupTableEED::MapValue(double v)
	{
		
		//int idx = this->GetIndex(v);
		//return (this->Table->GetPointer(0) + 4*idx);
		
		return 0;
	}
	
	void vtkLookupTableEED::GetColor(double v, double rgb[3])
	{
		//	unsigned char *rgb8 = this->MapValue(v);
		//	rgb[0] = rgb8[0]/255.0;
		//	rgb[1] = rgb8[1]/255.0;
		//	rgb[2] = rgb8[2]/255.0;
		
		rgb[0] = 1;
		rgb[1] = 1;
		rgb[2] = 0;
	}
	
	
	void vtkLookupTableEED::SetTableRange(double r[2])
	{
		this->SetTableRange(r[0],r[1]);
	}
	
	//----------------------------------------------------------------------------
	// Set the minimum/maximum scalar values for scalar mapping. Scalar values
	// less than minimum range value are clamped to minimum range value.
	// Scalar values greater than maximum range value are clamped to maximum
	// range value.
	void vtkLookupTableEED::SetTableRange(double rmin, double rmax)
	{
		if (rmax < rmin)
		{
			vtkErrorMacro("Bad table range: ["<<rmin<<", "<<rmax<<"]");
			return;
		}
		
		if (this->TableRange[0] == rmin && this->TableRange[1] == rmax)
		{
			return;
		}
		
		this->TableRange[0] = rmin;
		this->TableRange[1] = rmax;
		
		this->Modified();
	}
	
	
	
	//----------------------------------------------------------------------------
	// Although this is a relatively expensive calculation,
	// it is only done on the first render. Colors are cached
	// for subsequent renders.
	template<class T>
	void vtkLookupTableMapDirVectorEED(vtkLookupTableEED *self, T *input, 
									   unsigned char *output, int length, 
									   int inIncr, int outFormat)
	{
		double tmp,sum;
		//	double *mag;
		int i, j;
		double dirx,diry,dirz;
		
		
		printf("EED length %d  %p\n", length,input);
		//	mag = new double[length];
		for (i = 0; i < length; ++i)
		{
			dirx	= 0;
			diry	= 0;
			dirz	= 0;
			sum		= 0;
			for (j = 0; j < inIncr; ++j)
			{
				if (j==0) dirx= static_cast<double>(*input);  
				if (j==1) diry= static_cast<double>(*input);  
				if (j==2) dirz= static_cast<double>(*input);  
				tmp = static_cast<double>(*input);  
				sum += (tmp * tmp);
				++input;
			}
			sum=sqrt(sum);
			*output++ = (unsigned char) abs( (255*dirx/sum) );
			*output++ = (unsigned char) abs( (255*diry/sum) );
			*output++ = (unsigned char) abs( (255*dirz/sum) );
			*output++ = 255;
			//		printf("%d %d %d   ",(int)(255*dirx/sum),(int)(255*diry/sum),(int)(255*dirz/sum));
		}
		
		//	vtkLookupTableMapData(self, mag, output, length, 1, outFormat);
		
		//	delete [] mag;
	}
	
	
	
	//----------------------------------------------------------------------------
	void vtkLookupTableEED::MapScalarsThroughTable2(void *input, 
													unsigned char *output,
													int inputDataType, 
													int numberOfValues,
													int inputIncrement,
													int outputFormat)
	{
		
		printf("vtkLookupTableEED::MapScalarsThroughTable2 inputIncrement=%d   inputDataType=%d\n",inputIncrement,inputDataType);
		
		
		//	if (this->UseMagnitude && inputIncrement > 1)
		//  {
		switch (inputDataType)
		{
				vtkTemplateMacro(
								 vtkLookupTableMapDirVectorEED(this,static_cast<VTK_TT*>(input),output,
															   numberOfValues,inputIncrement,outputFormat);
								 return
								 );				
			case VTK_BIT:
				vtkErrorMacro("Cannot comput magnitude of bit array.");
				break;
			default:
				vtkErrorMacro(<< "MapImageThroughTable: Unknown input ScalarType");
		}
		//  }
		
	}  
	
	
	//----------------------------------------------------------------------------
	void vtkLookupTableEED::PrintSelf(ostream& os, vtkIndent indent)
	{
		this->Superclass::PrintSelf(os,indent);	
	}
	
	
	
	
	//----------------------------------
	//----------------------------------
	//----------------------------------
	//----------------------------------
	//----------------------------------
	
	
	
namespace bbcreaMaracasVisu
{
	
	

	
BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,TubeTreeFilter)
BBTK_BLACK_BOX_IMPLEMENTATION(TubeTreeFilter,bbtk::AtomicBlackBox);


void TubeTreeFilter::SetRadioTube(int iGeneral,int numPoints, int iTube)
{
	int i;
	double radiotmp=1;
	int size=iGeneral+numPoints;
	vtkDoubleArray *tubeRadius = vecTubeRadiosArray[iTube];

	if (bbGetInputlstRadio().size()>=1) 
	{
	   if (bbGetInputlstRadioLaw()==0)  // for All
	   {
		radiotmp=bbGetInputlstRadio()[0];
	   }  // Law 0  for All

	   if (bbGetInputlstRadioLaw()==1)  // by segment
	   {
	       if (bbGetInputlstRadio().size()>=iTube) 
	       {
	 	   radiotmp=bbGetInputlstRadio()[iTube];
	       } else {
		   radiotmp=bbGetInputlstRadio()[ bbGetInputlstRadio().size()-1 ];
	       }
	   }  // Law 1  by segment

  	   for (i=iGeneral;i<size;i++)
	   {
		if (bbGetInputlstRadioLaw()==2)  // by point
		{
		    if (bbGetInputlstRadio().size()>=i) 
	       	    {
			radiotmp=bbGetInputlstRadio()[i];
		    } else {
 			radiotmp=bbGetInputlstRadio()[ bbGetInputlstRadio().size()-1 ]; 
 		    } 
 		} // Law 2  by points
		tubeRadius->SetTuple1(i-iGeneral, radiotmp );
	   } // for
	tubeRadius->Modified();
	 }  // bbGetInputlstRadio().size()>=1


}


void TubeTreeFilter::DrawOneTube(int iGeneral,int numPoints, int iTube)
{
	int i;
	unsigned int nTv = 8;       // No. of surface elements for each tube vertex

	double spc[3];
	//	img->GetSpacing(spc);
	spc[0]=1;
	spc[1]=1;
	spc[2]=1;

	int size=iGeneral+numPoints;

	// Create points and cells
	vtkSmartPointer<vtkPoints> points = vtkSmartPointer<vtkPoints>::New();
//EED	vtkPoints *points = vtkPoints::New();
	vtkSmartPointer<vtkCellArray> lines = vtkSmartPointer<vtkCellArray>::New();
//EED	vtkCellArray *lines = vtkCellArray::New();

	lines->InsertNextCell( numPoints );

	for (i=iGeneral;i<size;i++)
	{
		points->InsertPoint(i-iGeneral,	bbGetInputlstPointX()[i]*spc[0],
								bbGetInputlstPointY()[i]*spc[1],
								bbGetInputlstPointZ()[i]*spc[2] );
		lines->InsertCellPoint(i-iGeneral);
	}

	vtkSmartPointer<vtkPolyData> polyData = vtkSmartPointer<vtkPolyData>::New();
//EED	vtkPolyData *polyData = vtkPolyData::New();
	polyData->SetPoints(points);
	polyData->SetLines(lines);


	// Varying tube radius using sine-function
	vtkSmartPointer<vtkDoubleArray> tubeRadius = vtkSmartPointer<vtkDoubleArray>::New();
//EED	vtkDoubleArray *tubeRadius = vtkDoubleArray::New();
	tubeRadius->SetName("TubeRadius");
	tubeRadius->SetNumberOfTuples( numPoints );
	vecTubeRadiosArray.push_back( tubeRadius );


	polyData->GetPointData()->AddArray(tubeRadius);
	polyData->GetPointData()->SetActiveScalars("TubeRadius");



	vtkSmartPointer<vtkTubeFilter> tube = vtkSmartPointer<vtkTubeFilter>::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	tube->SetInput(polyData);
#else
	tube->SetInputData(polyData);
#endif
	tube->SetNumberOfSides(nTv);
	tube->SetVaryRadiusToVaryRadiusByAbsoluteScalar();
        tube->CappingOn();
	
	vtkLookupTableEED* vLutEED 				 = vtkLookupTableEED::New();

	vtkSmartPointer<vtkPolyDataMapper> mapper =	vtkSmartPointer<vtkPolyDataMapper>::New();
	mapper->SetInputConnection(tube->GetOutputPort());
	mapper->ScalarVisibilityOn();
	
// EED fev 02/ 20112	
	mapper->SetScalarModeToUsePointFieldData();	
	mapper->SetLookupTable( vLutEED );
	mapper->SelectColorArray( "points_axe" );
	
	//		vtkSmartPointer<vtkActor> actor =vtkSmartPointer<vtkActor>::New();
    vtkSmartPointer<vtkActor> actor = vtkSmartPointer<vtkActor>::New();
	actor->SetMapper(mapper);

    vecVtkActors.push_back( actor );

	// Interface Update    // Interface Update
     if  (bbGetInputRenderer()!=NULL )
     {
	    bbGetInputRenderer()->AddActor( actor );
     }
}


void TubeTreeFilter::SetGraphicProperties()
{
    int iTube,sizeLstAxis=bbGetInputlstIndexs().size();

    int iGeneral=0;
    int numPoints;

    vtkActor *actorTube;

    double r,g,b;
    r = bbGetInputColour()[0];
    g = bbGetInputColour()[1];
    b = bbGetInputColour()[2];
    for (iTube=0 ; iTube<sizeLstAxis; iTube++)
    {
        // Get Actor

        actorTube=vecVtkActors[iTube];

        // Set Opacity
        actorTube->GetProperty()->SetOpacity( bbGetInputOpacity() );

 	// Set Transform
        if ( bbGetInputTransform()!=NULL )
        {
            actorTube->SetUserTransform( bbGetInputTransform() );
        }

        //Set Colour
        if (bbGetInputColourLaw()==1)  // One solide colour
        {
            //
        }

        if (bbGetInputColourLaw()==2)  // color for differents tubes
        {
            if ( (iTube*3+1) < (int)(bbGetInputColour().size()) )
            {
                r = bbGetInputColour()[0+iTube*3];
                g = bbGetInputColour()[1+iTube*3];
                b = bbGetInputColour()[2+iTube*3];
            } else {
                r = (rand() % 100) / 100.0;
                g = (rand() % 100) / 100.0;
                b = (rand() % 100) / 100.0;
            }
        }

        actorTube->GetProperty()->SetColor( r,g,b );


// Setting radio
	 numPoints = bbGetInputlstIndexs()[iTube];
 	 SetRadioTube(iGeneral,numPoints,iTube);
	 iGeneral = iGeneral+numPoints;

    } // for
}

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
void TubeTreeFilter::Process()
{

	printf("EED TubeTreeFilter::Process start \n");

	int iGeneral=0;
	int iTube,sizeLstAxis=bbGetInputlstIndexs().size();
	int iActor,sizeActors = vecVtkActors.size();

	int numPoints;
    if (oldLstSize!=sizeLstAxis)
    {
        oldLstSize=sizeLstAxis;
        for (iActor=0 ; iActor<sizeActors; iActor++)
        {
            if (bbGetInputRenderer()!=NULL )
            {
                bbGetInputRenderer()->RemoveActor( vecVtkActors[iActor] );
    //EED			vecVtkPolyData[iActor]->Delete();
    //EED			vecVtkPolyDataMaper[iActor]->Delete();
    //EED			vecVtkActors[iActor]->Delete();
            }
        }

    //EED	vecVtkPolyData.clear();
    //EED	vecVtkPolyDataMaper.clear();
        vecVtkActors.clear();
	vecTubeRadiosArray.clear();

        for ( iTube=0 ; iTube<sizeLstAxis ; iTube++)
        {
            numPoints = bbGetInputlstIndexs()[iTube];
            DrawOneTube(iGeneral,numPoints,iTube);
            iGeneral = iGeneral+numPoints;
        }

        if ( bbGetInputiTube() <= (int)(vecVtkActors.size()-1) )
        {
            bbSetOutputOutTube( vecVtkActors[ bbGetInputiTube() ] );
        } else 	{
                printf("TubeTreeFilter .ERROR. missing index vector...\n");
        }// vector Actor size

    } // oldLstSize
    SetGraphicProperties();

	printf("EED TubeTreeFilter::Process end \n");
}
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
void TubeTreeFilter::bbUserSetDefaultValues()
{
    oldLstSize=-1;

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
	bbSetInputiTube(0);
	std::vector<double> colour;
	// 0- gray
	colour.push_back(0.5);
	colour.push_back(0.5);
	colour.push_back(0.5);
	// 1- red
	colour.push_back(1.0);
	colour.push_back(0.0);
	colour.push_back(0.0);
	// 2- blue
	colour.push_back(0.0);
	colour.push_back(0.0);
	colour.push_back(1.0);
	// 3- yellow
	colour.push_back(1.0);
	colour.push_back(1.0);
	colour.push_back(0.0);
	// 4- green
	colour.push_back(0.0);
	colour.push_back(1.0);
	colour.push_back(0.0);
	// 5-
	colour.push_back(0.0);
	colour.push_back(1.0);
	colour.push_back(1.0);

	// 6-
	colour.push_back(0.5);
	colour.push_back(0.5);
	colour.push_back(0.5);

	bbSetInputColour(colour);
	bbSetInputTransform(NULL);
	bbSetInputRenderer(NULL);
    bbSetInputColourLaw(1);
    bbSetInputOpacity(1);

   std::vector<double> radio;
	radio.push_back(1);
	bbSetInputlstRadio( radio );
	bbSetInputlstRadioLaw( 0 );  // for all

}
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
void TubeTreeFilter::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
void TubeTreeFilter::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}
}
// EO namespace bbcreaMaracasVisu


