/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbcreaMaracasVisuVolumeRendering.h"
#include "bbcreaMaracasVisuPackage.h"

#include "wxMaracasMultipleVolumeRendererView.h"

namespace bbcreaMaracasVisu
{

	BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,VolumeRendering)
	BBTK_BLACK_BOX_IMPLEMENTATION(VolumeRendering,bbtk::WxBlackBox);
	void VolumeRendering::Process()
	{
	 
	// THE MAIN PROCESSING METHOD BODY 
	//   Here we simply set the input 'In' value to the output 'Out' 
	//   And print out the output value 
	// INPUT/OUTPUT ACCESSORS ARE OF THE FORM : 
	//    void bbSet{Input|Output}NAME(const TYPE&) 
	//    const TYPE& bbGet{Input|Output}NAME() const  
	//    Where : 
	//    * NAME is the name of the input/output 
	//      (the one provided in the attribute 'name' of the tag 'input') 
	//    * TYPE is the C++ type of the input/output 
	//      (the one provided in the attribute 'type' of the tag 'input') 
    		wxMaracasMultipleVolumeRendererView* volview = (wxMaracasMultipleVolumeRendererView*)bbGetOutputWidget();
		vtkImageData* _img1 = bbGetInputIn0();
		vtkImageData* _img2 = bbGetInputIn1();
		vtkImageData* _img3 = bbGetInputIn2();
		vtkImageData* _img4 = bbGetInputIn3();
		vtkRenderer* renderer = bbGetInputRenderer();

		if(volview!=NULL){
			if(renderer!=NULL&&_currentrenderer != renderer){
				volview->setRenderer(renderer);			
				_currentrenderer = renderer;
			}
			if(_currentrenderer!=NULL){
				if(_img1 !=NULL){
				volview->addVolume(_img1, "INPUT 1");
				}
				if(_img2 !=NULL){
					volview->addVolume(_img2, "INPUT 2");
				}
				if(_img3 !=NULL){
					volview->addVolume(_img3, "INPUT 3");
				}
				if(_img4 !=NULL){
					volview->addVolume(_img4, "INPUT 4");
				}
			}	
		}

			//vtkImageData* img1 = ;

			/*bbSetOutputOut0(volview->GetOutputImages()[0]);
			bbSetOutputOut1(volview->GetOutputImages()[1]);
			bbSetOutputOut2(volview->GetOutputImages()[2]);
			bbSetOutputOut3(volview->GetOutputImages()[3]);*/

	}
	void VolumeRendering::CreateWidget(wxWindow* parent)
	{
		wxMaracasMultipleVolumeRendererView* volview = wxMaracasMultipleVolumeRendererView::getInstance(parent);
		bbSetOutputWidget(volview);
	}
	void VolumeRendering::bbUserSetDefaultValues()
	{
	 
	//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX  
	//  Here we initialize the input 'In' to 0 
		bbSetInputIn0(0); 
		bbSetInputIn1(0); 
		bbSetInputIn2(0); 
		bbSetInputIn3(0); 
		bbSetInputRenderer(0);  

		bbSetOutputOut0(NULL);
		bbSetOutputOut1(NULL);
		bbSetOutputOut2(NULL);
		bbSetOutputOut3(NULL);
	  
	}
	void VolumeRendering::bbUserInitializeProcessing()
	{ 
		_currentrenderer = NULL;
	}
	void VolumeRendering::bbUserFinalizeProcessing()
	{
	 
	//  THE FINALIZATION METHOD BODY : 
	//    Here does nothing  
	//    but this is where you should desallocate the internal/output pointers  
	//    if any 
	  
	}
}
// EO namespace bbcreaMaracasVisu


