/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuAnimationSphere.h"
#include "bbcreaMaracasVisuPackage.h"


#include <vtkPolyDataMapper.h>
#include <vtkProperty.h>
#include <vtkRenderWindow.h>
#include <vtkWindowToImageFilter.h>
#include <vtkPNGWriter.h>



namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,AnimationSphere)
BBTK_BLACK_BOX_IMPLEMENTATION(AnimationSphere,bbtk::AtomicBlackBox);


void AnimationSphere::Process()
{
	int iMin,iMax;
	double px;
	double py;
	double pz;
	double radio;
	double spc[3];
  
	if (sphereActor==NULL)
	{
		// Sphere
		vtksphere		= vtkSphereSource::New();
  			vtksphere->SetThetaResolution (20);
			vtksphere->SetPhiResolution (20);
			vtksphere->SetRadius( 1  ); 

		vtkPolyDataMapper	*sphereMapper	= vtkPolyDataMapper::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			sphereMapper->SetInput( vtksphere->GetOutput() );
#else
			sphereMapper->SetInputData( vtksphere->GetOutput() );
#endif

		sphereActor		= vtkActor::New();
 			sphereActor->SetMapper(sphereMapper);
			sphereActor->SetOrigin(0, 0, 0);
			sphereActor->GetProperty()->SetColor( bbGetInputColour()[0] , bbGetInputColour()[1] , bbGetInputColour()[2] );
			sphereActor->GetProperty()->SetOpacity( bbGetInputOpacity() );
	} else {
		bbGetInputRenderer()->RemoveActor( sphereActor );
	}// if (sphereActor


	if (bbGetInputRenderer()!=NULL)
	{
		bbGetInputRenderer()->AddActor( sphereActor );
	} // if


	if (bbGetInputRenderer()!=NULL)
	{
		spc[0]=spc[1]=spc[2]=1;
		int i,size;

		if ( (bbGetInputIndex()==0) ){
			iMin=0;
			iMax=bbGetInputlstPointX().size();
		}  
		else if ( bbGetInputIndex()<=(int)(bbGetInputlstIndexs().size()) ) 
		{
			iMin = 0;
			iMax = 0;
			size = bbGetInputIndex();
			for (i=0;i<size; i++)
			{
				iMax = iMax + bbGetInputlstIndexs()[i];
				if (i-1>=0){
					iMin = iMin + bbGetInputlstIndexs()[i-1];
				}
			}
		} else {
			iMin=0;
			iMax=-1;
		}

		bbSetInputIndex(0);

		std::string newFileName;


		for ( i=iMin ; i<iMax ; i=i+1 )
		{
			px		= bbGetInputlstPointX()[i]*spc[0];
			py		= bbGetInputlstPointY()[i]*spc[1];
			pz		= bbGetInputlstPointZ()[i]*spc[2];
			radio	= bbGetInputlstRadio()[i];
			sphereActor->SetPosition( px,py,pz );
			vtksphere->SetRadius( radio  ); 
			if ( bbGetInputTransform()!=NULL )
			{
				sphereActor->SetUserTransform( bbGetInputTransform() );
			}


			bbGetInputRenderer()->Render();
			bbGetInputRenderer()->GetRenderWindow()->Render();

			if (i%bbGetInputStep()==0)
			{
				//writing file
				std::stringstream strId;
				strId << i;
				std::string strtmp1 =strId.str();
				std::string strtmp2 = "00000";
				for (int iStr = 0; iStr<(int)(strtmp1.length()) ; iStr++  )
				{
					strtmp2[ strtmp2.length()-1-iStr ] = strtmp1[ strtmp1.length()-1-iStr ];
				}
				newFileName = "c:/temp/image"+strtmp2+".png";

				vtkWindowToImageFilter	*w2i;
				vtkPNGWriter			*png;
				w2i = vtkWindowToImageFilter::New();
				png = vtkPNGWriter::New();
				w2i->SetInput( bbGetInputRenderer()->GetRenderWindow() );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
				png->SetInput( w2i->GetOutput() );     
#else
				png->SetInputData( w2i->GetOutput() );     
#endif

				png->SetFileName( newFileName.c_str() );
				png->Write();
				png->Delete();
				w2i->Delete();
			} // if i%10
		} // for
	} // 	if (bbGetInputRenderer()
}


void AnimationSphere::bbUserSetDefaultValues()
{
     sphereActor=NULL;

	bbSetInputRenderer(NULL);

	std::vector<double> colour;
	colour.push_back(1.0);
	colour.push_back(0.0);
	colour.push_back(0.0);
	bbSetInputColour(colour);

	bbSetInputOpacity(1);

	std::vector<int> lstInd;
	lstInd.push_back(0);
	std::vector<double> lstX;
	std::vector<double> lstY;
	std::vector<double> lstZ;
	std::vector<double> lstR;

	bbSetInputTransform(NULL);
	bbSetInputIndex(0);
	bbSetInputStep(1);
}

	
	//-----------------------------------------------------------------	
	void AnimationSphere::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void AnimationSphere::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	

}
// EO namespace bbcreaMaracasVisu


