/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuAxeVolume.h"
#include "bbcreaMaracasVisuPackage.h"

#include "creaVtk_MACROS.h"

namespace bbcreaMaracasVisu
{


BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,AxeVolume)
BBTK_BLACK_BOX_IMPLEMENTATION(AxeVolume,bbtk::AtomicBlackBox);

int AxeVolume::GetTypeFormat( std::string formatStr , vtkImageData* image )
{
	int outputformat = VTK_UNSIGNED_CHAR;
	if (formatStr=="SAME")
	{						
		if (image!=NULL) outputformat = image->GetScalarType();
	}
	else if (formatStr=="VTK_BIT")				outputformat = VTK_BIT;   	   		// 1
	else if (formatStr=="VTK_CHAR")				outputformat = VTK_CHAR;  	   		// 2
	else if (formatStr=="VTK_SIGNED_CHAR")		outputformat = VTK_SIGNED_CHAR;    	// 15
	else if (formatStr=="VTK_UNSIGNED_CHAR")	outputformat = VTK_UNSIGNED_CHAR;  	// 3
	else if (formatStr=="VTK_SHORT") 			outputformat = VTK_SHORT; 	   		// 4
	else if (formatStr=="VTK_UNSIGNED_SHORT") 	outputformat = VTK_UNSIGNED_SHORT; 	// 5
	else if (formatStr=="VTK_INT")				outputformat = VTK_INT;            	// 6
	else if (formatStr=="VTK_UNSIGNED_INT")		outputformat = VTK_UNSIGNED_INT;   	// 7
	else if (formatStr=="VTK_LONG")				outputformat = VTK_LONG;           	// 8  
	else if (formatStr=="VTK_UNSIGNED_LONG")	outputformat = VTK_UNSIGNED_LONG;  	// 9
	else if (formatStr=="VTK_FLOAT")			outputformat = VTK_FLOAT;          	// 10
	else if (formatStr=="VTK_DOUBLE")			outputformat = VTK_DOUBLE;         	// 11 
	else if (formatStr=="MET_CHAR")				outputformat = VTK_CHAR;  	   		// 2
	else if (formatStr=="MET_UCHAR")			outputformat = VTK_UNSIGNED_CHAR;  	// 3
	else if (formatStr=="MET_SHORT") 			outputformat = VTK_SHORT; 	   		// 4
	else if (formatStr=="MET_USHORT") 			outputformat = VTK_UNSIGNED_SHORT; 	// 5
	else if (formatStr=="MET_SHORT")			outputformat = VTK_SHORT;          	// 4
	else if (formatStr=="MET_FLOAT")			outputformat = VTK_FLOAT;   		// 10
	else if (formatStr=="MET_DOUBLE")			outputformat = VTK_DOUBLE;       	// 11  

    return outputformat;
}


void AxeVolume::Process()
{
	if (bbGetInputIn()!=NULL)
	{
		if ( mimage!=NULL )
		{
			mimage->Delete();
		}

		int ext[6];
		bbGetInputIn()->GetExtent(ext);
		int sizeX=ext[1]-ext[0]+1;
		int sizeY=ext[3]-ext[2]+1;
		int sizeZ=ext[5]-ext[4]+1;

		double spc[3];
		bbGetInputIn()->GetSpacing(spc);
		double invSpc[3];
		invSpc[0] = 1/spc[0];
		invSpc[1] = 1/spc[1];
		invSpc[2] = 1/spc[2];

		int outputformat = GetTypeFormat( bbGetInputOutputFormat() , bbGetInputIn() );

		mimage = vtkImageData::New();
		mimage->SetSpacing(bbGetInputIn()->GetSpacing());
		mimage->SetDimensions(bbGetInputIn()->GetDimensions());
		mimage->SetExtent(bbGetInputIn()->GetExtent());
		mimage->SetOrigin(bbGetInputIn()->GetOrigin());
	//EED 2017-01-01 Migration VTK7
	#if VTK_MAJOR_VERSION <= 5
		mimage->SetScalarType( outputformat );
		mimage->AllocateScalars();
	#else
		mimage->AllocateScalars( outputformat , 1);
	#endif

		int sizeLstPointR 	= bbGetInputlstPointR().size();
		int iAxe,sizeAxe	= bbGetInputlstPointX().size();
		int ii;
		int sizeImage 		= sizeX*sizeY*sizeZ;
	//	unsigned short *p;

		// Clean image
		memset( (char*)mimage->GetScalarPointer(0,0,0) , 0, sizeImage*(mimage->GetScalarSize()) );

	//	p = (unsigned short*)mimage->GetScalarPointer (0, 0, 0);
	//	for ( ii=0 ; ii<sizeImage ; ii++)
	//	{
	//		*p = 0;
	//		p++;
	//	}


	DEF_POINTER_IMAGE_VTK_CREA(vI,ssI,pI,stI,mimage)


	int k1omp=(double)(sizeAxe-1)*0.0;
	int k2omp=(double)(sizeAxe-1)*0.2;
	int k3omp=(double)(sizeAxe-1)*0.4;
	int k4omp=(double)(sizeAxe-1)*0.6;
	int k5omp=(double)(sizeAxe-1)*0.8;
	int k6omp=(double)(sizeAxe-1)*1.0;

	printf("EED AxeVolume::Process (with openmp)\n");

	#pragma omp parallel for 
		for (iAxe=0 ; iAxe<sizeAxe; iAxe++)
		 {
	if ( (k1omp==iAxe) || (k2omp==iAxe) || (k3omp==iAxe) || 
		 (k4omp==iAxe) || (k5omp==iAxe) || (k6omp==iAxe) ) { printf("  %d%\n", (int)(((double)iAxe/(double)(sizeAxe-1))*100 )); }
			int i,j,k;
			double rx,ry,rz;
			double r,rr;
			double px,py,pz;
			double px1,py1,pz1;
			double px2,py2,pz2;
			double vItmpOMP;

			if (iAxe<sizeLstPointR)
			{
				r = bbGetInputlstPointR()[ iAxe ]* invSpc[0];
			} else {
				if (bbGetInputlstPointR().size()>=1)
				{
					r = bbGetInputlstPointR()[ bbGetInputlstPointR().size()-1 ]    * invSpc[0];
				} else {
					r = 1;
				}
			} // if iAxe sizeLstPointR
			px = bbGetInputlstPointX()[iAxe] * invSpc[0];
			py = bbGetInputlstPointY()[iAxe] * invSpc[1];
			pz = bbGetInputlstPointZ()[iAxe] * invSpc[2];
			px1 = px - r;
			py1 = py - r;
			pz1 = pz - r;
			px2 = px + r;
			py2 = py + r;
			pz2 = pz + r;
			rr=r*r;

			long int index;
			for ( i=px1 ; i<=px2 ; i++ )
			{
				rx	=	i - px;
				rx	=	rx*rx;
				for ( j=py1 ; j<py2 ; j++ )
				{
					ry	=	j - py;
					ry	=	ry*ry;
					for ( k=pz1 ; k<pz2 ; k++ )
					{
						if ( (i>=0) && (i<sizeX) && (j>=0) && (j<sizeY) &&(k>=0) && (k<sizeZ) )
						{
	//						p = (unsigned short*)mimage->GetScalarPointer (i, j, k);
	//						if (*p==0)
							index=i+j*sizeX+k*sizeX*sizeY;
							GETVALUE2_VTK_CREA(vItmpOMP,pI,stI,index)
	// EED2020-04-25						if ( mimage->GetScalarComponentAsDouble(i,j,k,0)==0 )
							if ( vI==0 )
							{
								rz	=	k - pz;
								rz	=	rz*rz;
								if ( rx + ry + rz <= rr )
								{
	//								*p=255;
									vItmpOMP=bbGetInputValue();
									SETVALUE2_VTK_CREA(vItmpOMP,pI,stI,index)
	// EED2020-04-25								mimage->SetScalarComponentFromDouble (i,j,k,0, bbGetInputValue() );
								}
							} // *p==0
						} // if inside point
					} //for k
				} //for j
			} //for i
		} // for iAxe
		bbSetOutputOut( mimage );
	} else  {
		printf("\n");
		printf("EED Warnning!!  AxeVolume::Process  The Input In is not set.\n");
		printf("\n");
	}// if bbGetInputIn()
}


	//-----------------------------------------------------------------
	void AxeVolume::bbUserSetDefaultValues()
	{
		mimage=NULL;
		bbSetInputOutputFormat("SAME");
		bbSetInputValue(255);
	}

	//-----------------------------------------------------------------
	void AxeVolume::bbUserInitializeProcessing()
	{
	}

	//-----------------------------------------------------------------
	void AxeVolume::bbUserFinalizeProcessing()
	{
	}

	//-----------------------------------------------------------------

}
// EO namespace bbcreaMaracasVisu


