/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuAxeVolume_h_INCLUDED__
#define __bbcreaMaracasVisuAxeVolume_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkVersionMacros.h>
#include "vtkImageData.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ AxeVolume
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(AxeVolume,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT( In , vtkImageData * );
  BBTK_DECLARE_INPUT( lstPointX , std::vector<double> );
  BBTK_DECLARE_INPUT( lstPointY , std::vector<double> );
  BBTK_DECLARE_INPUT( lstPointZ , std::vector<double> );
  BBTK_DECLARE_INPUT( lstPointR , std::vector<double> );
  BBTK_DECLARE_INPUT( OutputFormat , std::string );
  BBTK_DECLARE_INPUT( Value , double );


  BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
  BBTK_PROCESS(Process);
  void Process();

  int GetTypeFormat( std::string formatStr , vtkImageData* image );


private:
  vtkImageData *mimage;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(AxeVolume,bbtk::AtomicBlackBox);
  BBTK_NAME ( "AxeVolume" ) ;
  BBTK_AUTHOR("eduardo.davila@hotmail.com");
  BBTK_DESCRIPTION("Axe Volume" ) ;
  BBTK_CATEGORY("actor");
  BBTK_INPUT(AxeVolume,In,"Size image X",vtkImageData*,"");
  BBTK_INPUT(AxeVolume,lstPointX,"List of X values", std::vector<double> ,"");
  BBTK_INPUT(AxeVolume,lstPointY,"List of Y values", std::vector<double> ,"");
  BBTK_INPUT(AxeVolume,lstPointZ,"List of Z values", std::vector<double> ,"");
  BBTK_INPUT(AxeVolume,lstPointR,"List of Radius", std::vector<double> ,"");

  BBTK_INPUT(AxeVolume,OutputFormat,"Image output format:  SAME (default), VTK_BIT, VTK_CHAR, VTK_SIGNED_CHAR, VTK_UNSIGNED_CHAR, VTK_SHORT, VTK_UNSIGNED_SHORT, VTK_INT, VTK_UNSIGNED_INT, VTK_LONG, VTK_UNSIGNED_LONG, VTK_FLOAT, VTK_DOUBLE",std::string,"");
  BBTK_INPUT(AxeVolume,Value,"(255 default) Gray level in the output image", double ,"");

  BBTK_OUTPUT(AxeVolume,Out,"Result image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(AxeVolume);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuAxeVolume_h_INCLUDED__

