/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuColorBar.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ColorBar)
BBTK_BLACK_BOX_IMPLEMENTATION(ColorBar,bbtk::WxBlackBox);

//--------------------------------------------------
void ColorBar::Process()
{
}

//--------------------------------------------------
void ColorBar::CreateWidget(wxWindow* parent)
{
//   bbSetOutputWidget( new wxStaticText ( bbGetWxParent() , -1 , _T("") ) );
//   Process();
		bbtkDebugMessageInc("Core",9,"ColorBar::CreateWidget()"<<std::endl);
		mwxwidget = new pColorBar( parent ,bbGetInputInW(), bbGetInputInH(), bbGetInputOrientation()==1); 
		mwxwidget -> setActiveStateTo( true );
   	    mwxwidget -> setRepresentedValues(bbGetInputInMin(), bbGetInputInMax());
		mwxwidget -> setDeviceEndMargin(10);
		mwxwidget -> setDeviceBlitStart(10,10); 
		std::vector<int> vectRED = bbGetInputReds(); 	
		std::vector<int> vectGREEN = bbGetInputGreens(); 	
		std::vector<int> vectBLUE = bbGetInputBlues(); 	
		std::vector<int> vectVALUES = bbGetInputValues(); 	
		if(vectRED.size()==vectGREEN.size() && vectGREEN.size()==vectBLUE.size() && vectBLUE.size()==vectVALUES.size())
		{
			int i=0;
			while ( i< (int)(vectVALUES.size()))
			{
				mwxwidget -> addColorPoint ( (double)vectVALUES[i], wxColour(vectRED[i], vectGREEN[i], vectBLUE[i]));
				i++;
			}
		}
		
		    
    bbtkDebugDecTab("Core",9);

	bbSetOutputWidget( mwxwidget );
}

//--------------------------------------------------
void ColorBar::bbUserSetDefaultValues()
{
		mwxwidget = NULL;
		bbSetInputOrientation(1);
		bbSetInputInW(200);
		bbSetInputInH(80);
		bbSetInputInMax(1);
		bbSetInputInMin(1);	
}
	
	//-----------------------------------------------------------------	
	void ColorBar::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ColorBar::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	

}
// EO namespace bbcreaMaracasVisu


