/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuContourCrown.h"
#include "bbcreaMaracasVisuPackage.h"

#include <vtkImageData.h>

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ContourCrown)
BBTK_BLACK_BOX_IMPLEMENTATION(ContourCrown,bbtk::WxBlackBox);

//-----------------------------------------------------------
void ContourCrown::Process()
{

    if (firsttime==true)
	{
		firsttime=false;
		if (bbGetInputwxVtkBaseView()==NULL) 
		{
			wxMessageDialog(NULL,  bbtk::std2wx("(ContourCrown) Input 'wxVtkBaseView' is not set"),  bbtk::std2wx(bbGetFullName()) ).ShowModal();
		}
		if (bbGetInputIn()==NULL) 
		{
			wxMessageDialog(NULL,  bbtk::std2wx("(ContourCrown) Input 'In' is not set"),  bbtk::std2wx(bbGetFullName()) ).ShowModal();
		}
	
		mwxwidget->Init(  bbGetInputwxVtkBaseView(), bbGetInputIn() );
		mwxwidget->ConfigureVTK();
	
		bbSetOutputImageValueResult( mwxwidget->GetVtkImageValueResult() );
		bbSetOutputImageMaskResult( mwxwidget->GetVtkImageMaskResult() );
	}
	
	
	if (mwxwidget!=NULL){
		//JSTG 04-04-08
		mwxwidget->SetControlPoints( bbGetInputControlPointsInX(), bbGetInputControlPointsInY(), bbGetInputControlPointsInZ() );
		
		LstValuePosX.clear();
		LstValuePosY.clear();
		LstValuePosZ.clear();
		mwxwidget->GetValuesInsideCrown(&LstValue,&LstValuePosX,&LstValuePosY,&LstValuePosZ);

		//JSTG 226-02-08 ----------------------------------------------------------
		LstContourX.clear();
		LstContourY.clear();
		LstContourZ.clear();
		mwxwidget->GetSplinePoints(&LstContourX,&LstContourY,&LstContourZ);
		//-------------------------------------------------------------------------

		bbSetOutputLstValue(&LstValue);
		bbSetOutputLstValuePosX(&LstValuePosX);
		bbSetOutputLstValuePosY(&LstValuePosY);
		bbSetOutputLstValuePosZ(&LstValuePosZ);
		bbSetOutputLstContourX(&LstContourX);
		bbSetOutputLstContourY(&LstContourY);
		bbSetOutputLstContourZ(&LstContourZ);
		bbSetOutputLstContourCrlX(&LstContourCrlX);
		bbSetOutputLstContourCrlY(&LstContourCrlY);
		bbSetOutputLstContourCrlZ(&LstContourCrlZ);
		bbSetOutputLstContourCrlZ(&LstContourCrlZ);
	} // mwxwidget
}

//-----------------------------------------------------------
void ContourCrown::CreateWidget(wxWindow* parent)
{
	bbtkDebugMessageInc("Core",9,"ContourCrown::CreateWidget()"<<std::endl);
  
	mwxwidget = new wxMaracasCoutourTool( parent );
	bbSetOutputWidget( mwxwidget );
	bbtkDebugDecTab("Core",9);
}

//-----------------------------------------------------------
void ContourCrown::bbUserSetDefaultValues()
{
	firsttime=true;
	mwxwidget = NULL;
	bbSetInputIn(NULL);
	bbSetInputwxVtkBaseView(NULL);
//JSTG 26-02-08 ------------------------------------
	bbSetInputControlPointsInX(NULL);
	bbSetInputControlPointsInY(NULL);
	bbSetInputControlPointsInZ(NULL);
//--------------------------------------------------
}

	//-----------------------------------------------------------------	
	void ContourCrown::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ContourCrown::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	

}
// EO namespace bbcreaMaracasVisu


