/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuContourCrown_h_INCLUDED__
#define __bbcreaMaracasVisuContourCrown_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include <vtkImageData.h>

#include "Contour/ContourCrownWidget.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ ContourCrown
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ContourCrown,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In, vtkImageData*);
    BBTK_DECLARE_INPUT(wxVtkBaseView, wxVtkBaseView*);
//JSTG 26-02-08 -------------------------------------------------------
    BBTK_DECLARE_INPUT(ControlPointsInX,std::vector<double>*);
	BBTK_DECLARE_INPUT(ControlPointsInY,std::vector<double>*);
	BBTK_DECLARE_INPUT(ControlPointsInZ,std::vector<double>*);
//---------------------------------------------------------------------
 	BBTK_DECLARE_OUTPUT(LstValue,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstValuePosX,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstValuePosY,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstValuePosZ,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourX,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourY,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourZ,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourCrlX,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourCrlY,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(LstContourCrlZ,std::vector<double>*);
	BBTK_DECLARE_OUTPUT(ImageValueResult,vtkImageData*);
	BBTK_DECLARE_OUTPUT(ImageMaskResult,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	bool					firsttime;
  	wxMaracasCoutourTool	*mwxwidget;
 	std::vector<double>		LstValue;
	std::vector<double>		LstValuePosX;
	std::vector<double>		LstValuePosY;
	std::vector<double>		LstValuePosZ;
	std::vector<double>		LstContourX;
	std::vector<double>		LstContourY;
	std::vector<double>		LstContourZ;
	std::vector<double>		LstContourCrlX;
	std::vector<double>		LstContourCrlY;
	std::vector<double>		LstContourCrlZ;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ContourCrown,bbtk::WxBlackBox);
BBTK_NAME("ContourCrown");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Contour crown tool");
    BBTK_CATEGORY("specific_appli");
	BBTK_INPUT(ContourCrown,In,"Input Image", vtkImageData *,"" );
	BBTK_INPUT(ContourCrown,wxVtkBaseView,"maracas visu wxVtkBaseView",wxVtkBaseView*,"");
//JSTG 26-02-08 ---------------------------------------------------------------------------------------------------------
	BBTK_INPUT(ContourCrown,ControlPointsInX,"Control Points X Coords ",std::vector<double>*,"");
	BBTK_INPUT(ContourCrown,ControlPointsInY,"Control Points Y Coords ",std::vector<double>*,"");
	BBTK_INPUT(ContourCrown,ControlPointsInZ,"Control Points Z Coords ",std::vector<double>*,"");
//-----------------------------------------------------------------------------------------------------------------------
	BBTK_OUTPUT(ContourCrown,LstValue	   , "Pixel values"								,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstValuePosX  , "Positions X of the values"					,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstValuePosY  , "Positions Y of the values"					,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstValuePosZ  , "Positions Z of the values"					,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourX   , "Positions X of the contours"				,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourY   , "Positions Y of the contours"				,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourZ   , "Positions Z of the contours"				,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourCrlX, "Positions X of the contour control points"	,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourCrlY, "Positions Y of the contour control points"	,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,LstContourCrlZ, "Positions Z of the contour control points"	,	std::vector<double>*,"");
	BBTK_OUTPUT(ContourCrown,ImageValueResult, "vtkImagedata with the values"	,	vtkImageData *,"" );
	BBTK_OUTPUT(ContourCrown,ImageMaskResult, "vtkImagedata with the mask"	,	vtkImageData *,"" );
BBTK_END_DESCRIBE_BLACK_BOX(ContourCrown);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuContourCrown_h_INCLUDED__
#endif // _USE_WXWIDGETS_

