/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuContourStatistics.h"
#include "bbcreaMaracasVisuPackage.h"
#include <math.h>
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ContourStatistics)
BBTK_BLACK_BOX_IMPLEMENTATION(ContourStatistics,bbtk::AtomicBlackBox);

//------------------------------------------------------------
void ContourStatistics::Process()
{

	  double max=0,min=0;
	  double average=0,standardeviation=0;
	  double acum=0;
	  double ng;
	  int size=0;
	  if (bbGetInputLstValue()!=NULL)
	  {
		size=bbGetInputLstValue()->size();
		if (size>0){
	       max=(*bbGetInputLstValue())[0];
		   min=(*bbGetInputLstValue())[0];
     // Average
			int i;
			for ( i=0; i<size; i++ )
			{
				ng=(*bbGetInputLstValue())[i];
				acum = acum + ng;
				if (max<ng) max=ng;		// Max
				if (min>ng) min=ng;     // Min
			}
			average = acum / size;

	  // Standar Deviation
			acum=0;
			double tmp;
  			for ( i=0; i<size; i++ )
			{
                tmp = (*bbGetInputLstValue())[i] - average;
				acum = acum + tmp*tmp;
			}
			standardeviation = sqrt(acum/size);

		}
	  }

	  // OUTPUT
      bbSetOutputMax( max );
      bbSetOutputnPoints( size );
      bbSetOutputMin( min );
      bbSetOutputAverage( average );
      bbSetOutputStandarDeviation( standardeviation );
}

//------------------------------------------------------------
void ContourStatistics::bbUserSetDefaultValues()
{
      bbSetInputLstValue(NULL);
}

	
	//-----------------------------------------------------------------	
	void ContourStatistics::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ContourStatistics::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	

}
// EO namespace bbcreaMaracasVisu


