/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuContourStatistics_h_INCLUDED__
#define __bbcreaMaracasVisuContourStatistics_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ ContourStatistics
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ContourStatistics,bbtk::AtomicBlackBox);
	BBTK_DECLARE_INPUT(LstValue,std::vector<double>*);
	BBTK_DECLARE_INPUT(LstValuePosX,std::vector<double>*);
	BBTK_DECLARE_INPUT(LstValuePosY,std::vector<double>*);
	BBTK_DECLARE_INPUT(LstValuePosZ,std::vector<double>*);
    BBTK_DECLARE_OUTPUT(Max,double);
    BBTK_DECLARE_OUTPUT(Min,double);
    BBTK_DECLARE_OUTPUT(Average,double);
    BBTK_DECLARE_OUTPUT(StandarDeviation,double);
	BBTK_DECLARE_OUTPUT(nPoints,int);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ContourStatistics,bbtk::AtomicBlackBox);
BBTK_NAME("ContourStatistics");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Basic contour statistics");
BBTK_CATEGORY("math");
    BBTK_INPUT(ContourStatistics,LstValue,"Pixel values",std::vector<double>*,"");
    BBTK_INPUT(ContourStatistics,LstValuePosX,"Pixel position X",std::vector<double>*,"");
    BBTK_INPUT(ContourStatistics,LstValuePosY,"Pixel position Y",std::vector<double>*,"");
    BBTK_INPUT(ContourStatistics,LstValuePosZ,"Pixel position Z",std::vector<double>*,"");
    BBTK_OUTPUT(ContourStatistics,Max,"Max",double,"");
    BBTK_OUTPUT(ContourStatistics,Min,"Min",double,"");
    BBTK_OUTPUT(ContourStatistics,Average,"Average",double,"");
    BBTK_OUTPUT(ContourStatistics,StandarDeviation,"Standar Deviation",double,"");
    BBTK_OUTPUT(ContourStatistics,nPoints,"Number of values",int,"");
BBTK_END_DESCRIBE_BLACK_BOX(ContourStatistics);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuContourStatistics_h_INCLUDED__

