/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_VTK_
#ifdef _USE_ITK_

#include "bbmaracasvisuContourToControlPoints.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ContourToControlPoints)
//BBTK_USER_BLACK_BOX_IMPLEMENTATION(ContourToControlPoints,bbtk::AtomicBlackBox);
BBTK_BLACK_BOX_IMPLEMENTATION(ContourToControlPoints,bbtk::AtomicBlackBox);

//------------------------------------------------------------
void ContourToControlPoints::Process()
{
		if ( bbGetInputSampling() >= 3.0 )
		{
			OutContourX.clear();
			OutContourY.clear();
			OutContourZ.clear();
			_ext2D->SetContour( bbGetInputInContourX(),bbGetInputInContourY(),bbGetInputInContourZ() );
			_ext2D->SetSamplingControlPoints( bbGetInputSampling() );
			_ext2D->GetSamplingControlPoints( &OutContourX,&OutContourY,&OutContourZ );
		}
		if(bbGetInputSampling() == 2.0)
		{
			OutContourX.clear();
			OutContourY.clear();
			OutContourZ.clear();
			_ext2D->SetContour( bbGetInputInContourX(),bbGetInputInContourY(),bbGetInputInContourZ() );
			_ext2D->GetControlPoints( &OutContourX,&OutContourY,&OutContourZ );
		}
		
		//Liberates the memory from the VTK's objects. Always must do that!!	
		if ( bbGetInputLoadContour()== 1 )
		{
			if (_imagedata!=NULL)
			{
				_imagedata->Delete();
			}
			KeyContourX.clear();
			KeyContourY.clear();
			KeyContourZ.clear();
			KeySizes.clear();
			FILE* fd;
			fd = fopen("C:/bbtk_JS/data/SavedContours.txt","r"); 
			_propgdata->ReadKeyContour( fd );
			fclose(fd);
			_propgdata->GetKeyContours(&KeyContourX,&KeyContourY,&KeyContourZ,&KeySizes);
			if(KeySizes.size() == 1)
			{
				//Method for 2D
			//	_imagedata = _propgdata->method_RBF(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			}
			if(KeySizes.size() >= 2)
			{
				//Method for 3D
				//_imagedata = _propgdata->method_RBF_3D(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			//	_imagedata = _propgdata->method_RBF_3D_ThinPlate(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			}
		}
		if ( bbGetInputLoadContour()== 2 )
		{
			if (_imagedata!=NULL)
			{
				_imagedata->Delete();
			}
			FILE* fd;
			fd = fopen("C:/bbtk_JS/data/SavedManualPoints.txt","r"); 
			_propgdata->ReadKeyContour( fd );
			fclose(fd);
			_propgdata->GetKeyContours(&KeyContourX,&KeyContourY,&KeyContourZ,&KeySizes);
			if(KeySizes.size() == 1)
			{
				//Method for 2D
			//	_imagedata = _propgdata->method_RBF(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			}
			if(KeySizes.size() >= 2)
			{
				//Method for 3D
				//_imagedata = _propgdata->method_RBF_3D(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			//	_imagedata = _propgdata->method_RBF_3D_ThinPlate(bbGetInputRadRBF(),&KeyContourX,&KeyContourY,&KeyContourZ);
			}
		}

		if ( bbGetInputLoadContour()== 3 )
		{
			if (_imagedata!=NULL)
			{
				_imagedata->Delete();
			}
			vtkImageData *itemp = vtkImageData::New();
			_contprop->appendContour();
			_contprop->setInterpolationNumber(300);
			itemp = _contprop->GetKeyContours(&KeyContourX,&KeyContourY,&KeyContourZ,&KeySizes);
			if(KeySizes.size() == 1)
			{
			}
			if(KeySizes.size() >= 2)
			{
				//Method for 3D
				_imagedata = itemp;
				_contprop->resetAppend();
				_contprop->appendContour(&KeyContourX,&KeyContourY,&KeyContourZ);
				//_contprop->GetContour(bbGetInputSlice(),&OutContourX,&OutContourY,&OutContourZ);
				_contprop->GetControlPoints(bbGetInputSlice(),&OutContourX,&OutContourY,&OutContourZ);
				printf("\n Size OutContourX = %d",(int)(OutContourX.size()));
			}
		}

		bbSetOutputControlPointX( &OutContourX );
		bbSetOutputControlPointY( &OutContourY );
		bbSetOutputControlPointZ( &OutContourZ );
		bbSetOutputImagePropg( _imagedata );
}
	
	
//------------------------------------------------------------
void ContourToControlPoints::bbUserSetDefaultValues()
{
		bbSetInputSampling(5.0);
		bbSetInputSlice(0);
		bbSetInputInContourX(NULL);
		bbSetInputInContourY(NULL);
		bbSetInputInContourZ(NULL);
		bbSetInputRadRBF(1000.0);
		bbSetInputOption(1);
		bbSetInputLoadContour(0);

		_contprop	= NULL;
		_propgdata	= NULL;
		_imagedata	= NULL;
		_ext2D		= NULL;
	
		_fd = NULL;
		pos = 0;
}

	
	//-----------------------------------------------------------------	
	void ContourToControlPoints::bbUserInitializeProcessing()
	{
		_contprop	= new ContourPropagation();
		_propgdata	= new PropContour();
		_imagedata	= vtkImageData::New();
		_ext2D		= new ExtractControlPoints2D();
	}
	
	//-----------------------------------------------------------------	
	void ContourToControlPoints::bbUserFinalizeProcessing()
	{
		if (_contprop!=NULL) delete _contprop;
		if (_propgdata!=NULL) delete _propgdata;
		if (_imagedata!=NULL) _imagedata->Delete();
		if (_ext2D!=NULL) delete _ext2D;

		_contprop	= NULL;
		_propgdata	= NULL;
		_imagedata	= NULL;
		_ext2D		= NULL;
	}
	
	//-----------------------------------------------------------------	

	

}
// EO namespace bbcreaMaracasVisu

#endif //_USE_ITK_
#endif //_USE_VTK_
