/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuContourToControlPoints_h_INCLUDED__
#define __bbcreaMaracasVisuContourToControlPoints_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "Contour/ExtractControlPoints2D.h"
#include "Contour/ContourPropagation.h"
#include "Contour/Propagation.h"

#include "vtkImageData.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ ContourToControlPoints
 : 
   public bbtk::AtomicBlackBox
{
	//BBTK_USER_BLACK_BOX_INTERFACE(ContourToControlPoints,bbtk::AtomicBlackBox);
	BBTK_BLACK_BOX_INTERFACE(ContourToControlPoints,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,double);
		BBTK_DECLARE_INPUT(Sampling, double);
		BBTK_DECLARE_INPUT(Slice,int);
		BBTK_DECLARE_INPUT(InContourX, std::vector<double>*);
		BBTK_DECLARE_INPUT(InContourY, std::vector<double>*);
		BBTK_DECLARE_INPUT(InContourZ, std::vector<double>*);
		BBTK_DECLARE_INPUT(RadRBF, double);
		BBTK_DECLARE_INPUT(Option, int);
		BBTK_DECLARE_INPUT(LoadContour, int);
  BBTK_DECLARE_OUTPUT(Out,double);
		BBTK_DECLARE_OUTPUT(ControlPointX, std::vector<double>*);
		BBTK_DECLARE_OUTPUT(ControlPointY, std::vector<double>*);
		BBTK_DECLARE_OUTPUT(ControlPointZ, std::vector<double>*);
		BBTK_DECLARE_OUTPUT(ImagePropg, vtkImageData*);

  BBTK_PROCESS(Process);
  void Process();
  private:
			int pos;
			bool inic;
			
			ContourPropagation		*_contprop;
			PropContour				*_propgdata;
			ExtractControlPoints2D	*_ext2D;

			vtkImageData			*_imagedata;
			FILE					*_fd;
	  		
			std::vector<double> OutContourX;
			std::vector<double> OutContourY;
			std::vector<double> OutContourZ;

			std::vector<double> KeyContourX;
			std::vector<double> KeyContourY;
			std::vector<double> KeyContourZ;
			std::vector<int> KeySizes;
			
			//TEMP DATA
			std::vector<double> tempX;
			std::vector<double> tempY;
			std::vector<double> tempZ;
			std::vector<int>::iterator it;
  
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ContourToControlPoints,bbtk::AtomicBlackBox);
BBTK_NAME("ContourToControlPoints");
BBTK_AUTHOR("Juan Sebasltian Torres");
BBTK_DESCRIPTION("Generates the control points of a contour");
BBTK_CATEGORY("filter");
   BBTK_INPUT(ContourToControlPoints,Sampling,"Sampling (in %) to obtain the control points",double,"");
   BBTK_INPUT(ContourToControlPoints,Slice,"Slice Number Propagation",int,"");
   BBTK_INPUT(ContourToControlPoints,InContourX,"Coordinate X of a Contour",std::vector<double>*,"");
   BBTK_INPUT(ContourToControlPoints,InContourY,"Coordinate Y of a Contour",std::vector<double>*,"");
   BBTK_INPUT(ContourToControlPoints,InContourZ,"Coordinate Z of a Contour",std::vector<double>*,"");
   BBTK_INPUT(ContourToControlPoints,RadRBF,"Radius of th RBF method",double,"");
   BBTK_INPUT(ContourToControlPoints,Option,"1 -> Control Points || 2 -> Propagation",int,"");
   BBTK_INPUT(ContourToControlPoints,LoadContour,"1 -> Load Saved Manual Points",int,"");
//THE OUTPUTS
   BBTK_OUTPUT(ContourToControlPoints,ControlPointX,"Processed Coordinate X of the Boundary",std::vector<double>*,"");
   BBTK_OUTPUT(ContourToControlPoints,ControlPointY,"Processed Coordinate Y of the Boundary",std::vector<double>*,"");
   BBTK_OUTPUT(ContourToControlPoints,ControlPointZ,"Processed Coordinate Z of the Boundary",std::vector<double>*,"");
   BBTK_OUTPUT(ContourToControlPoints,ImagePropg,"vtkImageData of the propagation image-3D",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ContourToControlPoints);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuContourToControlPoints_h_INCLUDED__

