/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//HOLA!!!
//HOLA!!!

#include "bbmaracasvisuContourVOI.h"
#include "bbcreaMaracasVisuPackage.h"



namespace bbcreaMaracasVisu
{

  //--------------------------------------------------------------------------
  // wxWidgetMPR
  //--------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxWidgetVOI, wxPanel )
	EVT_MENU( 12121, wxWidgetVOI::OnRefreshView )
	EVT_MENU( 12122, wxWidgetVOI::OnDClickLeft  )
END_EVENT_TABLE( );

  //-----------
  //Constructor
  //-----------
  wxWidgetVOI::wxWidgetVOI(wxWindow* parent,  wxVtkBaseView *wxvtkbaseview, vtkImageData *imagedata)
	  : wxPanel( parent, -1 )
  {
//		wxPanel	*panel	= this;

		wxFlexGridSizer *sizer=new wxFlexGridSizer(1);		
		sizer	-> AddGrowableCol(0);
		this	-> SetSizer(sizer);
		this	-> SetAutoLayout(true);
		this->wxvtkbaseview = NULL;
		mcontourvoiwidget=NULL;

		if(wxvtkbaseview!=NULL&&imagedata!=NULL){

			setBaseView(wxvtkbaseview);
			setImageData(imagedata);
			initializeVOIWidget();
		}			
  }

   void wxWidgetVOI::initializeVOIWidget()
	{
	   wxSizer* sizer = this->GetSizer();


/// \TODO fix deprecated warning: virtual bool wxSizer::Remove(wxWindow*) is deprecated (declared at /usr/include/wx-2.8/wx/sizer.h:513)		
		if(mcontourvoiwidget!=NULL)
		{
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			sizer->Remove( mcontourvoiwidget );	
#else
			sizer->Detach( mcontourvoiwidget );	
#endif
			mcontourvoiwidget->Destroy();
		}

		mcontourvoiwidget = new ContourVOIWidget( this, wxvtkbaseview, imagedata );
		mcontourvoiwidget->ConfigureVTK();

		sizer	-> Add( mcontourvoiwidget,1,wxGROW ); 
//		wxwidget = new wxMPRWidget2( panel, marimagedata , 1 );	
//		wxwidget->ConfigureVTK();	
		
		this->Refresh();
  }

  void wxWidgetVOI::setBaseView(wxVtkBaseView * wxvtkbaseview)
	{
	  this->wxvtkbaseview = wxvtkbaseview;
  }

  void wxWidgetVOI::setImageData(vtkImageData * imagedata)
	{
	  this->imagedata = imagedata;
  }

 
//--------------------------------------------------------------------------
  wxWidgetVOI::~wxWidgetVOI()
  {
  }
	
//--------------------------------------------------------------------------
  void wxWidgetVOI::Refresh()
  { 
//	  wxwidget->RefreshView();
  }

//--------------------------------------------------------------------------
  //---------------
  //Handling events
  //---------------
  void wxWidgetVOI::OnRefreshView(wxCommandEvent &event)
  {
/*
	  if((wxwidget!=NULL) && (mbbViewerMPR!=NULL))
	  {
	    point.clear();
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetX());
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetY());
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetZ());
		mbbViewerMPR->bbSetOutputPoint(point);
		mbbViewerMPR->bbSetModifiedStatus();
		wxwidget->RefreshView();
	  }
*/
  }

//--------------------------------------------------------------------------
  void wxWidgetVOI::OnDClickLeft(wxCommandEvent & event) 
  {
//	wxwidget->RefreshView();
  }

//------------------------------------------------------
ContourVOIWidget* wxWidgetVOI::GetContourVOIWidget()
{
	return mcontourvoiwidget;
}

//--------------------------------------------------------------------------------------------------------------------------------

//------------------------------------------------------
//------------------------------------------------------
//------------------------------------------------------


BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ContourVOI)
BBTK_BLACK_BOX_IMPLEMENTATION(ContourVOI,bbtk::WxBlackBox);

//------------------------------------------------------
void ContourVOI::Process()
{  

	/*if (bbGetInputwxVtkBaseView()==NULL) 
    {
      wxMessageDialog(NULL,  bbtk::std2wx("(ContourVOI) Input 'wxVtkBaseView' is not set"),  bbtk::std2wx(bbGetFullName()) ).ShowModal();	  
    }
	if (bbGetInputIn()==NULL) 
    {
      wxMessageDialog(NULL,  bbtk::std2wx("(ContourVOI) Input 'In' is not set"),  bbtk::std2wx(bbGetFullName()) ).ShowModal();
    }*/

	vtkImageData* img = bbGetInputIn();
	wxVtkBaseView* base = bbGetInputwxVtkBaseView();

	wxWidgetVOI* wxwidgetvoi = (wxWidgetVOI*)bbGetOutputWidget();

	if(base !=NULL && img != NULL && _img != img){

		_img = img;
		_base = base;
		
		wxwidgetvoi->setBaseView(base);
		wxwidgetvoi->setImageData(img);
		wxwidgetvoi->initializeVOIWidget();		
	}

	if (wxwidgetvoi!=NULL && _img!=NULL && _base != NULL){
		ContourVOIWidget* contourvoiwidget = wxwidgetvoi->GetContourVOIWidget();
		
		int voi[6];
		contourvoiwidget->GetVOI(voi);
		char buffer[40];
		sprintf(buffer,"%d %d %d ", voi[0], voi[2], voi[4] );
		std::string Index(buffer);
		sprintf(buffer,"%d %d %d ", voi[1]-voi[0]+1, voi[3]-voi[2]+1, voi[5]-voi[4]+1 );
		std::string Size(buffer);

		std::cout<<"ContourVOI index "<<Index<<" size "<<Size<<std::endl;

	/*EED 20 Juin 2011	
	  This go out of the box ... see ExtractVtkImageFilter ...
	 
		//JCP
		if(_extract!=NULL){		
			_extract->Delete();
		}
		_extract = vtkExtractVOI::New();
		_extract->RemoveAllInputs();
		_extract->SetInput(img);
		_extract->SetVOI(voi);	
		_extract->UpdateWholeExtent();
		_extract->Update();
		bbSetOutputVOI(_extract->GetOutput());
		//JCP
  */
	
		bbSetOutputIndex( Index );
		bbSetOutputSize( Size );
	} 
}

//------------------------------------------------------
void ContourVOI::CreateWidget(wxWindow*  parent)
{  
	bbtkDebugMessageInc("Core",9,"ContourVOI::CreateWidget()"<<std::endl);
	wxWidgetVOI *mwxwidget = new wxWidgetVOI( parent );
	bbSetOutputWidget(mwxwidget);
	bbtkDebugDecTab("Core",9);
	this->bbSignalOutputModification();

	//Process();
}

//------------------------------------------------------
void ContourVOI::bbUserSetDefaultValues()
{
	_img = NULL;
	_base = NULL;
//EED 20Juin2011	_extract =NULL;
	bbSetInputwxVtkBaseView(NULL);
	bbSetInputIn(NULL);
	bbSetOutputWidget(NULL);
	bbSetOutputVOI(NULL);

	bbSetInputIn(NULL);
	bbSetInputwxVtkBaseView(NULL);

}

//-----------------------------------------------------------------	
void ContourVOI::bbUserInitializeProcessing()
{
}
	
//-----------------------------------------------------------------	
void ContourVOI::bbUserFinalizeProcessing()
{
}
	
//-----------------------------------------------------------------	
	
}
// EO namespace bbcreaMaracasVisu
