/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuDrawAxe3D.h"
#include "bbcreaMaracasVisuPackage.h"

#include "vtkImageData.h"
#include "vtkActor.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkProperty.h"

#include "vtkLinearTransform.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,DrawAxe3D)
BBTK_BLACK_BOX_IMPLEMENTATION(DrawAxe3D,bbtk::AtomicBlackBox);
void DrawAxe3D::Process()
{
	std::vector< double > vectx = bbGetInputlstPointX();
	std::vector< double > vecty = bbGetInputlstPointY();
	std::vector< double > vectz = bbGetInputlstPointZ();	


//	vtkImageData* img = bbGetInputImage();	
	unsigned int i;
	double spc[3];	
//	img->GetSpacing(spc);
	spc[0]=1;
	spc[1]=1;
	spc[2]=1;

	if(!vectx.empty()&&!vecty.empty()&&!vectz.empty())
        {
		vtkPoints* allPoints = vtkPoints::New( );
		vtkCellArray* allTopology = vtkCellArray::New( );
		allTopology->InsertNextCell( vectx.size() );

		for( i = 0; i < vectx.size( ); i++) {	
			//multiplicar ver parametros spacing, en maracas cuando se toca la imagen y se ve dycom
			//hay parametro dicom, vtkImagedata valor spacing y esos datos hay que multiplicar al polydata
			allPoints->InsertNextPoint( vectx[i]*spc[0],  vecty[i]*spc[1], vectz[i]*spc[2] );
			allTopology->InsertCellPoint( i );
		} // rof
		mallData->SetPoints( allPoints );
		mallData->SetLines( allTopology );
		allPoints->Delete();
		allTopology->Delete();	
	}

	mvtkactor->GetProperty()->SetColor( bbGetInputColour()[0],  
				bbGetInputColour()[1], 
				bbGetInputColour()[2] );
	//EC Axe Opacity property added
	///Default Values
	double opacity=bbGetInputOpacity();
	mvtkactor->GetProperty()->SetOpacity( opacity );
	if ( bbGetInputTransform()!=NULL )
	{
		mvtkactor->SetUserTransform( bbGetInputTransform() );
	}

     // Interface Update
     if ((firsttime==true) && (bbGetInputRenderer()!=NULL ))
     {
		firsttime=false;
	    bbGetInputRenderer()->AddActor( mvtkactor );
     }
}




void DrawAxe3D::bbUserSetDefaultValues()
{
	firsttime        = true;
	mallData         = NULL;
	polydatamapper   = NULL;
	mvtkactor        = NULL;

    std::vector<double> colour;
    colour.push_back(1.0);
    colour.push_back(0.0);
    colour.push_back(0.0);
    bbSetInputColour(colour);
    bbSetInputOpacity(1.0);
    bbSetInputRenderer(NULL);
    bbSetInputTransform(NULL);
}



	//-----------------------------------------------------------------	
	void DrawAxe3D::bbUserInitializeProcessing()
	{
		mallData       = vtkPolyData::New( );
		polydatamapper = vtkPolyDataMapper::New();
		mvtkactor      = vtkActor::New();
		
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		polydatamapper->SetInput(mallData);
#else
		polydatamapper->SetInputData(mallData);
#endif

		mvtkactor->SetMapper(polydatamapper);
		bbSetOutputOut(mvtkactor);
	}

	//-----------------------------------------------------------------	
	void DrawAxe3D::bbUserFinalizeProcessing()
	{
		if (mallData!=NULL)
		{
			mallData->Delete();
			mallData=NULL;
		}
		
		if (polydatamapper!=NULL)
		{
			polydatamapper->Delete();
			polydatamapper=NULL;
		}
		
		if (mvtkactor!=NULL)
		{
			mvtkactor->Delete();
			mvtkactor=NULL;
		}
	}

	//-----------------------------------------------------------------	
}

// EO namespace bbcreaMaracasVisu


