/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuDrawAxe3D_h_INCLUDED__
#define __bbcreaMaracasVisuDrawAxe3D_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"


#include "vtkRenderer.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkLinearTransform.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ DrawAxe3D
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(DrawAxe3D,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_INPUT(lstPointX,std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointY,std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointZ,std::vector<double>);
  BBTK_DECLARE_INPUT(Colour,std::vector<double>);
  BBTK_DECLARE_INPUT(Opacity,double);
  BBTK_DECLARE_INPUT(Transform, vtkLinearTransform *);
  BBTK_DECLARE_OUTPUT(Out,vtkProp3D *);

//  BBTK_DECLARE_OUTPUT(Out,double);
  BBTK_PROCESS(Process);
  void Process();

  private:
    bool						firsttime;
    vtkPolyData			*mallData;
    vtkActor				*mvtkactor;
    vtkPolyDataMapper	*polydatamapper;
};


BBTK_BEGIN_DESCRIBE_BLACK_BOX(DrawAxe3D,bbtk::AtomicBlackBox);
BBTK_NAME("DrawAxe3D");
BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Draw a 3D axe in a vtk 3D Viewer");
BBTK_CATEGORY("actor");
  BBTK_INPUT(DrawAxe3D,Renderer,"vtk Renderer 3D universe",vtkRenderer*,"");
  BBTK_INPUT(DrawAxe3D,lstPointX,"list of point X",std::vector<double>,"");
  BBTK_INPUT(DrawAxe3D,lstPointY,"list of point Y",std::vector<double>,"");
  BBTK_INPUT(DrawAxe3D,lstPointZ,"list of point Z",std::vector<double>,"");
  BBTK_INPUT(DrawAxe3D,Colour,"Color of the line R(0..1) G(0..1) B(0..1) ",std::vector<double>,"colour");
  BBTK_INPUT(DrawAxe3D,Opacity,"Axe opacity property ",double,"intensity");
  BBTK_INPUT(DrawAxe3D,Transform,"vtkTransform", vtkLinearTransform *,"");
  BBTK_OUTPUT(DrawAxe3D,Out,"Actor",vtkProp3D*,"");
BBTK_END_DESCRIBE_BLACK_BOX(DrawAxe3D);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuDrawAxe3D_h_INCLUDED__

