/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuDrawAxisTree3D.h"
#include "bbcreaMaracasVisuPackage.h"
#include "vtkLinearTransform.h"

#include "vtkUnsignedCharArray.h"
#include "vtkCellData.h"
#include "vtkPolyLine.h"
#include "vtkLine.h"



namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,DrawAxisTree3D)
BBTK_BLACK_BOX_IMPLEMENTATION(DrawAxisTree3D,bbtk::AtomicBlackBox);



void DrawAxisTree3D::DrawOneAxis(int iGeneral,int numPoints, int iAxis)
{
	vtkPolyData			*polydata		= vtkPolyData::New( );
	vtkPolyDataMapper	*polydatamapper	= vtkPolyDataMapper::New();
	vtkActor			*vtkactor		= vtkActor::New();

//	polydatamapper->ScalarVisibilityOff();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	polydatamapper->SetInput(polydata);
#else
	polydatamapper->SetInputData(polydata);
	polydatamapper->Update();
#endif
	vtkactor->SetMapper(polydatamapper);

	vecVtkPolyData.push_back( polydata );
	vecVtkPolyDataMaper.push_back( polydatamapper );
	vecVtkActors.push_back( vtkactor );

//	vtkImageData* img = bbGetInputImage();
	unsigned int i,size;
	double spc[3];
//	img->GetSpacing(spc);
	spc[0]=1;
	spc[1]=1;
	spc[2]=1;

	int lstpointsXsize =bbGetInputlstPointX().size();
	if( lstpointsXsize>0 )
	{
		vtkPoints	 *allPoints		= vtkPoints::New( );
		vtkPolyLine  *polyline 		= vtkPolyLine::New();
		vtkCellArray *allTopology	= vtkCellArray::New( );
//		allTopology->InsertNextCell( numPoints );
		size=iGeneral+numPoints;
        std::vector<double> lstX    = bbGetInputlstPointX();
        std::vector<double> lstY    = bbGetInputlstPointY();
        std::vector<double> lstZ    = bbGetInputlstPointZ();
		for (i=iGeneral;i<size;i++)
		{
			//multiplicar ver parametros spacing, en maracas cuando se toca la imagen y se ve dycom
			//hay par·metro dycom, vtkImagedata valor spacing y esos datos hay que multiplicar al polydata
            allPoints->InsertNextPoint( lstX[i],
                                        lstY[i],
                                        lstZ[i] );

//			printf("DrawAxisTree3D::DrawOneAxis point  %d -> %f, %f, %f \n", i,  bbGetInputlstPointX()[i], bbGetInputlstPointY()[i], bbGetInputlstPointZ()[i] );
            polyline->GetPointIds()->InsertNextId(i-iGeneral);
//			allTopology->InsertCellPoint( i-iGeneral );
		} // rof
        allTopology->InsertNextCell(polyline);
	 // create cell array for edges
        vtkCellArray *edges = vtkCellArray::New();
	// connect edge's and vertexes point ids
        for(vtkIdType i = iGeneral; i < size-1; i++)
        {
          vtkLine *edge = vtkLine::New();
          edge->GetPointIds()->SetId(0, i-iGeneral);
          edge->GetPointIds()->SetId(1, (i-iGeneral+1) );
          edges->InsertNextCell(edge);
          edge->Delete();
	//      vtkSmartPointer<vtkVertex> vertex = vtkSmartPointer<vtkVertex>::New();
	//      vertex->GetPointIds()->SetId(0, i);
	//      vertexes->InsertNextCell(vertex);
        } // for i
        polydata->SetPoints( allPoints );
        polydata->SetLines(edges);
        //	polydata->SetLines( allTopology );
        //   polydata->SetPolys( allTopology );
        edges->Delete();
        allPoints->Delete();
        allTopology->Delete();
	} // if lstpointsXsize
    
	// color
	double r,g,b;
    std::vector<double> lstColor = bbGetInputColour();
	if (bbGetInputColourLaw()==1)  // the same color for all 
	{
		r = lstColor[0];
		g = lstColor[1];
		b = lstColor[2];
		vtkactor->GetProperty()->SetColor( r,g,b );
	} // Law 1  color for all
	if (bbGetInputColourLaw()==2) // different colors for each segment
	{
		if ( (iAxis*3+1) < (int)(bbGetInputColour().size()) )	
		{
			r = lstColor[0+iAxis*3];
			g = lstColor[1+iAxis*3];
			b = lstColor[2+iAxis*3];
		} else {
			r = (rand() % 100) / 100.0;
			g = (rand() % 100) / 100.0;
			b = (rand() % 100) / 100.0;
		}
		vtkactor->GetProperty()->SetColor( r,g,b );
	}  // Law 2  color for each segment
	if (bbGetInputColourLaw()==3)  // color for each point 
	{
		// Setup the colors array
  		vtkUnsignedCharArray *colors = vtkUnsignedCharArray::New();
	  	colors->SetNumberOfComponents(3);
	  	colors->SetName("Colors");
//	  	colors->SetName("vertex color");
		int iPoint,pointSize=iGeneral+numPoints;
		for (iPoint=iGeneral; iPoint<pointSize; iPoint++)
		{
			r = lstColor[0+iPoint*3]*255.0;
			g = lstColor[1+iPoint*3]*255.0;
			b = lstColor[2+iPoint*3]*255.0;
			colors->InsertNextTuple3(r,g,b);
		}
		polydata->GetCellData()->SetScalars(colors);
		polydata->Modified();
	}  // Law 3 color for each point

	vtkactor->GetProperty()->SetLineWidth( bbGetInputLineWidth() );
	vtkactor->GetProperty()->SetOpacity( bbGetInputOpacity() );
	if ( bbGetInputTransform()!=NULL )
	{
		vtkactor->SetUserTransform( bbGetInputTransform() );
	}
    // Interface Update
    if  (bbGetInputRenderer()!=NULL )
    {
	   bbGetInputRenderer()->AddActor( vtkactor );
    }
}


void DrawAxisTree3D::Process()
{
	// Removing actors
	int iActor,sizeActors = vecVtkActors.size();
	for (iActor=0 ; iActor<sizeActors; iActor++)
	{
		if (bbGetInputRenderer()!=NULL )
		{ 
			bbGetInputRenderer()->RemoveActor( vecVtkActors[iActor] );
			vecVtkPolyData[iActor]->Delete();
			vecVtkPolyDataMaper[iActor]->Delete();
			vecVtkActors[iActor]->Delete();
		} // if
	} // for iActor
	vecVtkPolyData.clear();
	vecVtkPolyDataMaper.clear();
	vecVtkActors.clear();
	// Adding actors
	if (bbGetInputActive()==true)
	{
	   if ( (bbGetInputlstPointX().size()==bbGetInputlstPointY().size()) && 
	   		(bbGetInputlstPointX().size()==bbGetInputlstPointZ().size())      )
		{
			int iGeneral=0;
			std::vector<int> lstIndexs = bbGetInputlstIndexs();
			if ( bbGetInputlstIndexs().size()==0 )
			{
				lstIndexs.push_back( bbGetInputlstPointX().size() );
			} // if
			int iAxis,sizeLstAxis=lstIndexs.size();
			int numPoints;
			for ( iAxis=0 ; iAxis<sizeLstAxis ; iAxis++)
			{
				numPoints = lstIndexs[iAxis];
				DrawOneAxis(iGeneral,numPoints,iAxis);
				iGeneral = iGeneral+numPoints;
			} // for iAxis
			if ( bbGetInputiAxis() < (int)(vecVtkActors.size() ) )
			{
				bbSetOutputOutAxis( vecVtkActors[ bbGetInputiAxis() ] );            
			} else 	{
				printf("DrawAxisTree3D .ERROR.  iAxis for exist in actors vector ...\n");
			} // if 
		} else {
			printf("\nDrawAxisTree3D .ERROR.  size of vectors lstPointX.size=%d lstPointY.size=%d lstPointZ.size=%d are not coherent \n\n",bbGetInputlstPointX().size(), bbGetInputlstPointY().size(), bbGetInputlstPointZ().size() );
		}// size X Y Z
	} // if Active
}

void DrawAxisTree3D::bbUserSetDefaultValues()
{
    oldLstSize=-1;
     std::vector<double> colour;
	 // 1- red
     colour.push_back(1.0);
     colour.push_back(0.0);
     colour.push_back(0.0);
	 // 2- blue
     colour.push_back(0.0);
     colour.push_back(0.0);
     colour.push_back(1.0);
	 // 3- yellow
     colour.push_back(1.0);
     colour.push_back(1.0);
     colour.push_back(0.0);
	 // 4- green
     colour.push_back(0.0);
     colour.push_back(1.0);
     colour.push_back(0.0);
	 // 5-
     colour.push_back(0.0);
     colour.push_back(1.0);
     colour.push_back(1.0);

	 // 6-
     colour.push_back(0.5);
     colour.push_back(0.5);
     colour.push_back(0.5);

	 bbSetInputActive(true);
	 bbSetInputiAxis(0);
     bbSetInputColour(colour);
     bbSetInputOpacity(1);
     bbSetInputLineWidth(0.5);
     bbSetInputColourLaw(1);
     bbSetInputTransform(NULL);
     bbSetOutputOutAxis(NULL);

}


	//-----------------------------------------------------------------
	void DrawAxisTree3D::bbUserInitializeProcessing()
	{
	}

	//-----------------------------------------------------------------
	void DrawAxisTree3D::bbUserFinalizeProcessing()
	{
	}

	//-----------------------------------------------------------------

}
// EO namespace bbcreaMaracasVisu


