/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuHistogramView.h"
#include "bbcreaMaracasVisuPackage.h"


namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,HistogramView)
BBTK_BLACK_BOX_IMPLEMENTATION(HistogramView,bbtk::WxBlackBox);

//------------------------------------------------
void HistogramView::Process()
{
	if (firsttime==true)
	{
		firsttime=false;
	//	histogram_wxwidget = new Histogram( wxpanel , -1, wxPoint(0,0), wxSize(400,400),wxNO_BORDER );
		_histogramMinMaxLevel->Configure( bbGetInputIn() );
	}
}

//------------------------------------------------
void HistogramView::CreateWidget(wxWindow* parent)
{
	firsttime=true;
	bbtkDebugMessageInc("Core",9,"HistogramViewWindow::CreateWidget()"<<std::endl);
	
//EED 07Mai2009	
//	histogram_wxwidget = new Histogram( parent , -1, wxPoint(0,0), wxSize(400,400),wxNO_BORDER ,bbGetInputIn());
	wxPanel *wxpanel =new wxPanel(parent);
	wxpanel->SetSize(400,400);

//Borrame
//	histogram_wxwidget = new Histogram( parent , -1, wxPoint(0,0), wxSize(400,400),wxNO_BORDER );
	
	Histogram* histogram		= new Histogram(  parent , -1, wxPoint(0,0), wxSize(400,400), /*wxNO_BORDER*/ wxBORDER_DEFAULT ); 
	_histogramMinMaxLevel 	= new HistogramMinMaxLevel( (HistogramBase*)histogram );

   bbtkDebugDecTab("Core",9);
	bbSetOutputWidget( _histogramMinMaxLevel->GetWindow() );
//  	bbSetOutputWidget( wxpanel );
}

	//-----------------------------------------------------------------	
	void HistogramView::bbUserSetDefaultValues()
	{
	}
	
	//-----------------------------------------------------------------	
	void HistogramView::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void HistogramView::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	

}
// EO namespace bbcreaMaracasVisu

