/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuImageActor.h"
#include "bbcreaMaracasVisuPackage.h"

#include "vtkImageShiftScale.h" 
#include <vtkLookupTable.h>
#include <vtkColorTransferFunction.h>
#include <vtkImageMapToColors.h>
#include <vtkImageMapper3D.h>
#include <vtkImageProperty.h>

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ImageActor)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageActor,bbtk::AtomicBlackBox);
void ImageActor::Process()
{
		//JCP 04/04/09
		vtkImageData *img				= bbGetInputIn();
		vtkLinearTransform* transform	= bbGetInputTransform();
				
	if(img != NULL)
		{
			if (bbGetInputLookupTable()==NULL)
			{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
				imageactor->SetInput( img );	
#else
				imageactor->SetInputData( img );	
#endif
			} else {
				vtkImageMapToColors *color = vtkImageMapToColors::New();
				color->SetLookupTable( bbGetInputLookupTable() );
				color->PassAlphaToOutputOn();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
 				color->SetInput( img );
				color->Update();
				imageactor->GetMapper()->SetInput( color->GetOutput() );
#else
 				color->SetInputData( img );
 				color->Update();
				imageactor->GetMapper()->SetInputData( color->GetOutput() );
#endif

				if ( bbGetInputInterpolationMode()==0) { imageactor->GetProperty()->SetInterpolationTypeToNearest();	}
				if ( bbGetInputInterpolationMode()==1) { imageactor->GetProperty()->SetInterpolationTypeToLinear();		}
				if ( bbGetInputInterpolationMode()==2) { imageactor->GetProperty()->SetInterpolationTypeToCubic();		}
				imageactor->SetForceOpaque(true);
			}

			if (transform!=NULL)
			{
			  imageactor->SetUserTransform( transform );	
			} // transform
			bbSetOutputOut(imageactor);
		} // img
				
		// Interface Update
		if ((firsttime==true) && (bbGetInputRenderer()!=NULL ))
		{
				firsttime=false;
				bbGetInputRenderer()->AddActor( imageactor );
		}
		imageactor->GetProperty()->SetOpacity( bbGetInputOpacity() );
		bbSetOutputOut(imageactor);	
}

void ImageActor::bbUserSetDefaultValues()
{
    firsttime 	= true;
    imageactor 	= NULL;
    bbSetInputIn(NULL);
    bbSetInputOpacity(1);
    bbSetInputTransform(NULL);
    bbSetInputRenderer(NULL);
    bbSetInputLookupTable(NULL);
    bbSetInputInterpolationMode(0);
}

	
	//-----------------------------------------------------------------	
	void ImageActor::bbUserInitializeProcessing()
	{
		imageactor 		= vtkImageActor::New();
		imageshiftscale = vtkImageShiftScale::New();
	}
	
	//-----------------------------------------------------------------	
	void ImageActor::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
}
// EO namespace bbcreaMaracasVisu


