/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuImageActor_h_INCLUDED__
#define __bbcreaMaracasVisuImageActor_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"


#include <vtkVersionMacros.h>
#include <vtkImageData.h>
#include <vtkImageActor.h>
#include <vtkRenderer.h>
#include <vtkTransform.h>
#include <vtkLinearTransform.h>
#include <vtkImageShiftScale.h>
#include <vtkScalarsToColors.h>


namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT ImageActor
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageActor,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Transform,vtkLinearTransform*);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_INPUT(Opacity,double);
  BBTK_DECLARE_INPUT(LookupTable,vtkScalarsToColors*);
  BBTK_DECLARE_INPUT(InterpolationMode,int);

  BBTK_DECLARE_OUTPUT(Out,vtkProp3D*);
  BBTK_PROCESS(Process);
  void Process();
  bool firsttime;
  vtkImageActor *imageactor;
  vtkImageShiftScale *imageshiftscale;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageActor,bbtk::AtomicBlackBox);
	BBTK_NAME("ImageActor");
	BBTK_AUTHOR("InfoDev CREATIS");
	BBTK_DESCRIPTION("put image in a 3D univers");
	BBTK_CATEGORY("");
	BBTK_INPUT(ImageActor,In,"Image input",vtkImageData*,"");
	BBTK_INPUT(ImageActor,Transform,"Transform",vtkLinearTransform*,"");
	BBTK_INPUT(ImageActor,Renderer,"Renderer",vtkRenderer*,"");
	BBTK_INPUT(ImageActor,Opacity,"Opacity [0-1]",double,"");
	BBTK_INPUT(ImageActor,InterpolationMode,"(default 0) 0=NearestNeighbor  1=Linear  2=Cubic",int,"");
	BBTK_INPUT(ImageActor,LookupTable,"LookupTable [vtkScalarsToColors]",vtkScalarsToColors*,"");
	BBTK_OUTPUT(ImageActor,Out,"Output vtk actor",vtkProp3D*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageActor);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuImageActor_h_INCLUDED__

