/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuImageChangeInformation.h"
#include "bbcreaMaracasVisuPackage.h"

namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ImageChangeInformation)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageChangeInformation,bbtk::AtomicBlackBox);
void ImageChangeInformation::Process()
{
	int 			ext[6];
	double 			spc[3];
	double 			origin[3];
	vtkImageData	*img = bbGetInputIn();
	if(img!=NULL)
	{
		if(mchange != NULL)
		{
			mchange->Delete();
		}
		mchange = vtkImageChangeInformation::New();
		img->GetExtent( ext );	

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		mchange->SetInput( img );
#else
		mchange->SetInputData( img );
#endif

		mchange->SetOutputExtentStart(0,0,0);
		if (bbGetInputNewSpacing().size()==3)
		{
			spc[0] = bbGetInputNewSpacing()[0];
			spc[1] = bbGetInputNewSpacing()[1];
			spc[2] = bbGetInputNewSpacing()[2];
			mchange->SetOutputSpacing( spc[0] , spc[1] , spc [2] );    //spacing
		}
		if (bbGetInputNewOrigin().size()==3)
		{
			if ( (bbGetInputNewOrigin()[0]==-1) && (bbGetInputNewOrigin()[1]==-1) && (bbGetInputNewOrigin()[2]==-1) )
			{
				img->GetOrigin( origin );	
			} else {
				origin[0] = bbGetInputNewOrigin()[0];
				origin[1] = bbGetInputNewOrigin()[1];
				origin[2] = bbGetInputNewOrigin()[2];
			}
		} else {
			origin[0] = 0;
			origin[1] = 0;
			origin[2] = 0;
		}
		mchange->SetOutputOrigin( origin );
		mchange->Modified();    //important
		mchange->Update();    //important
		bbSetOutputOut( mchange->GetOutput() );
	}  // if img

}


void ImageChangeInformation::bbUserSetDefaultValues()
{
  	mchange = NULL;
   	bbSetOutputOut( NULL);
   	bbSetInputIn(NULL);
}

void ImageChangeInformation::bbUserInitializeProcessing()
{
	
}
	
void ImageChangeInformation::bbUserFinalizeProcessing()
{
	if (mchange!=NULL)
	{
		mchange->Delete();
	}
}
	

	
	
}
// EO namespace bbcreaMaracasVisu


