/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuImageChangeInformation_h_INCLUDED__
#define __bbcreaMaracasVisuImageChangeInformation_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkVersionMacros.h>
#include "vtkImageData.h"
#include "vtkImageChangeInformation.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ ImageChangeInformation
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageChangeInformation,bbtk::AtomicBlackBox);
	BBTK_DECLARE_INPUT(In,vtkImageData*);
	BBTK_DECLARE_INPUT(NewSpacing,std::vector<double>);
	BBTK_DECLARE_INPUT(NewOrigin,std::vector<double>);
	BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

private:
	vtkImageChangeInformation	*mchange;

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageChangeInformation,bbtk::AtomicBlackBox);
BBTK_NAME("ImageChangeInformation");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("vtkImageData change information. Translate extern to 0,0,0");
	BBTK_CATEGORY("filter");
	BBTK_INPUT(ImageChangeInformation,In,"Input image",vtkImageData*,"");
	BBTK_INPUT(ImageChangeInformation,NewSpacing,"New spacing of the image. 3 elements (default: the same spacing of the original image)", std::vector<double> ,"");
	BBTK_INPUT(ImageChangeInformation,NewOrigin,"New origin of the image. 3 elements (default: 0,0,0). (-1,-1,-1) get the same origin of the original image", std::vector<double> ,"");
	BBTK_OUTPUT(ImageChangeInformation,Out,"Output image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageChangeInformation);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuImageChangeInformation_h_INCLUDED__

