/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuPlotterView.h"
#include "bbcreaMaracasVisuPackage.h"

#include "pPlotterScaleX.h"
#include "pPlotterScaleY.h"


namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,PlotterView)
BBTK_BLACK_BOX_IMPLEMENTATION(PlotterView,bbtk::WxBlackBox);

//---------------------------------------------------
void PlotterView::Process()
{

	double lim=1;

	if (bbGetInputInX().size()==bbGetInputInY().size() ) 
    {
		pGraphicalFunction *pGF  = mwxwidget->getFunction(0);
		pGraphicalFunction *pGF2 = mwxwidget->getFunction(1);
	// EED 2020-01-22
		if (pGF!=NULL)  
		{ 
			// -Erasing  points-
			int i,sizePoints		= pGF->getSizePoints();
			for (i=1; i<sizePoints;i++)
			{
	//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
	#if wxMAJOR_VERSION <= 2
				pGF->deletePointAt(1);   //  EED here NOT 0 is 1
	#else
				pGF->deletePointAt(0);   //  EED here NOT 0 is 1
	#endif
			} // for i
			mwxwidget->deleteFunction(pGF);  
			pGF=NULL;  
		}
	// EED 2020-01-22
		if (pGF2!=NULL) 
		{ 
			// -Erasing  points-
			int i,sizePoints		= pGF2->getSizePoints();
			for (i=0; i<sizePoints;i++)
			{
	//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
	#if wxMAJOR_VERSION <= 2
				pGF2->deletePointAt(1);   //  EED here NOT 0 is 1
	#else
				pGF2->deletePointAt(0);   //  EED here NOT 0 is 1
	#endif
			} // for i
			mwxwidget->deleteFunction(pGF2); 
			pGF2=NULL; 
		}
			if ( (bbGetInputInY().size()!=0) && (pGF==NULL) )		
			{
				// avoid 'taking address of temporary '
				//pGraphicalFunction *pGF = mwxwidget->getFunctionForVectors( &(bbGetInputInX()), &(bbGetInputInY()) ); // taking address of temporary ! JPRx
				std::vector<double> inX;
				if (bbGetInputInX().size()==0)
				{
					int i,size=bbGetInputInY().size();
					for(i=0;i<size;i++)
					{
						inX.push_back((double)i);
					} // for
				} else {
					inX = bbGetInputInX();
				} // if bbGetInputInX
				std::vector<double> inY = bbGetInputInY();

				bool ok=false;
				int i, size = inY.size();
				for ( i=0 ; i<size ; i++ )
				{	
					if ((inY[i]>-lim) && (inY[i]<lim)) { inY[i]=0; } 
					if ((inY[i]<-lim) || (inY[i]>lim)) {ok=true;}
				}// for
				if (ok==true) 
				{
					pGF = mwxwidget->getFunctionForVectors( &inX, &inY ); 
					mwxwidget->addFunction(pGF);		
				} else {
					printf("EED Warnning!!  PlotterView::Process   function y with CEROS  ????..... \n");
				} // if ok

			} // if bbGetInputInY

			if ((bbGetInputInY2().size()!=0)&& (pGF2==NULL)	)
			{
				// avoid 'taking address of temporary '
				//pGraphicalFunction *pGF = mwxwidget->getFunctionForVectors( &(bbGetInputInX()), &(bbGetInputInY()) ); // taking address of temporary ! JPRx
				std::vector<double> inX2;
				if (bbGetInputInX().size()==0)
				{
					int i,size=bbGetInputInY2().size();
					for(i=0;i<size;i++)
					{
						inX2.push_back((double)i);
					} // for
				} else {
					inX2 = bbGetInputInX();
				} // if bbGetInputInX
				std::vector<double> inY2 = bbGetInputInY2();

				bool ok2=false;
				int i, size = inY2.size();
				for ( i=0 ; i<size ; i++ )
				{	
					if ((inY2[i]>-lim) && (inY2[i]<lim)) { inY2[i]=0; } 
					if ((inY2[i]<-lim) || (inY2[i]>lim)) {ok2=true;}
				}// for
				if (ok2==true) 
				{
					pGF2 = mwxwidget->getFunctionForVectors( &inX2, &inY2 ); 
					mwxwidget->addFunction(pGF2);		
				} else {
					printf("EED Warnning!!  PlotterView::Process   function y2 with CEROS  ????..... \n");
				} // if ok2


			} // if bbGetInputInY
		
	/* EED 2020-01-22

		if (pGF!=NULL)	
		{
			// -Erasing  points-
			int i,sizePoints		= pGF->getSizePoints();
			for (i=1; i<sizePoints;i++)
			{
				pGF->deletePointAt(1);  //  EED here NOT 0 is 1
			} // for i
			// -Add Points-
			double px;
			sizePoints=bbGetInputInY().size();
			for (i=0; i<sizePoints;i++)
			{
				if (i<bbGetInputInX().size())
				{
					px = bbGetInputInX()[i]; 
				} else {
					px = i;
				}	
				pGF->AddNewPoint( px, bbGetInputInY()[i] );
			}		
		}// if pGF

		if (pGF2!=NULL)	
		{
			// -Erasing  points-
			int i,sizePoints		= pGF2->getSizePoints();
			for (i=0; i<sizePoints;i++)
			{
	//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
	#if wxMAJOR_VERSION <= 2
				pGF2->deletePointAt(1);   //  EED here NOT 0 is 1
	#else
				pGF2->deletePointAt(0);   //  EED here NOT 0 is 1
	#endif
			} // for i
			// -Add Points-
			double px;
			sizePoints=bbGetInputInY2().size();
			for (i=0; i<sizePoints;i++)
			{
				if (i<bbGetInputInX().size())
				{
					px = bbGetInputInX()[i]; 
				} else {
					px = i;
				}	
				pGF2->AddNewPoint( px, bbGetInputInY2()[i] );
			}  // for	
		}// if pGF
	*/
		mwxwidget->UpdateAll();
	} else {
		printf("EED Warnning... PlotterView::Process()   Size of vecto X and Y is not coherent.\n");
	} // InX.size InY.size
}

	
//---------------------------------------------------
void PlotterView::CreateWidget(wxWindow* parent)
{
   	bbtkDebugMessageInc("Core",9,"PlotterView::CreateWxWindow()"<<std::endl);
   	mwxwidget = new pPlotterWindow( parent , -1,wxDefaultPosition,  wxDefaultSize,  0 );
   	mwxwidget->AddLayer(new pPlotterScaleX());
   	mwxwidget->AddLayer(new pPlotterScaleY());
	mwxwidget->setMinScrY(0);
	mwxwidget->setMaxScrY(5000);
	bbtkDebugDecTab("Core",9);
   	bbSetOutputWidget( mwxwidget );
}

//---------------------------------------------------
void PlotterView::bbUserSetDefaultValues()
{
	mwxwidget = NULL;
}
	
	//-----------------------------------------------------------------	
	void PlotterView::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void PlotterView::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	

}
// EO namespace bbcreaMaracasVisu


