/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuShowNPoints.h"
#include "bbcreaMaracasVisuPackage.h"


namespace bbcreaMaracasVisu
{


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
WidgetShowNPointsBox::WidgetShowNPointsBox(wxWindow *parent,  bbcreaMaracasVisu::ShowNPoints *box, int type)
    : WidgetShowNPoints( parent, type)
{
	mbbShowNPoints=box;
}

//------------------------------------------------------------------------
WidgetShowNPointsBox::~WidgetShowNPointsBox()
{
}


//------------------------------------------------------------------------
void WidgetShowNPointsBox::UpdatePoints(wxCommandEvent &event)
{
	WidgetShowNPoints::UpdatePoints(event);
	//Difference in Radio for text placement
//	double radio=GetModelShowNPoints()->GetRadio();
//	this->mopacity = sdrOpacity->GetValue()/100.0;
//	GetModelShowNPoints()->SetRadio( sdrRadio->GetValue() ) ;
//	radio = sdrRadio->GetValue();
	//NTU refresh the inputs
	mbbShowNPoints->bbSetInputOpacity( GetOpacity() );
	mbbShowNPoints->bbSetInputRadio( GetRadio() );
	// EED 
//	RefreshPoints();
}


//------------------------------------------------------------------------
void WidgetShowNPointsBox::SetOutputBox()
{
	WidgetShowNPoints::SetOutputBox();

//	wxString strTmp;
//	strTmp.Printf(_T("Nbr of points: %d"), GetModelShowNPoints()->GetLstPointsSize() );
//	txtNrPoints->SetLabel(  strTmp );

	//--BBTK
    mbbShowNPoints->bbSetOutputlstPointsX( GetLstPointsX() );
    mbbShowNPoints->bbSetOutputlstPointsY( GetLstPointsY() );
    mbbShowNPoints->bbSetOutputlstPointsZ( GetLstPointsZ() );
    mbbShowNPoints->bbSetOutputlstLabels( GetLstLabels() );
    mbbShowNPoints->bbSetOutputlstIndexs( GetLstIndexs() );
    //    mbbShowNPoints->bbSetOutputlstPointsX( GetModelShowNPoints()->GetLstPointsX() );
    //    mbbShowNPoints->bbSetOutputlstPointsY( GetModelShowNPoints()->GetLstPointsY() );
    //    mbbShowNPoints->bbSetOutputlstPointsZ( GetModelShowNPoints()->GetLstPointsZ() );
    //    mbbShowNPoints->bbSetOutputlstLabels( GetModelShowNPoints()->GetLstLabels() );
	mbbShowNPoints->bbSignalOutputModification();
}



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------




BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ShowNPoints)
BBTK_BLACK_BOX_IMPLEMENTATION(ShowNPoints,bbtk::WxBlackBox);

//-----------------------------------------------------------------
void ShowNPoints::Process()
{
	if (mwxwidget!=NULL)
	{
		mwxwidget->SetRenderer( bbGetInputRenderer() );
		mwxwidget->SetReferencePoint( bbGetInputIn() );
		mwxwidget->SetImage( bbGetInputImage() );
		mwxwidget->SetColour( bbGetInputColour() );
		mwxwidget->SetOpacity( bbGetInputOpacity() );
		mwxwidget->SetRadio( bbGetInputRadio() );
        
        if ( mwxwidget->GetModelShowNPoints()->GetFirstTime()==false )
        {
            mwxwidget->DetectCollectionActive();
        }
        
		if ( mwxwidget->GetModelShowNPoints()->GetFirstTime()==true )
		{
			mwxwidget->GetModelShowNPoints()->SetFirstTime(false);
			mwxwidget->SetInitLstPoints( bbGetInputInitLstPointsX() , bbGetInputInitLstPointsY() , bbGetInputInitLstPointsZ() , bbGetInputInitLstLabels() );
		}
        mwxwidget->TrackingPoint();
        bbSetOutputlstPointsX( mwxwidget->GetLstPointsX() );
        bbSetOutputlstPointsY( mwxwidget->GetLstPointsY() );
        bbSetOutputlstPointsZ( mwxwidget->GetLstPointsZ() );
        bbSetOutputlstLabels( mwxwidget->GetLstLabels() );
        bbSetOutputlstIndexs( mwxwidget->GetLstIndexs() );

//        bbSetOutputlstPointsX( mwxwidget->GetModelShowNPoints()->GetLstPointsX() );
//        bbSetOutputlstPointsY( mwxwidget->GetModelShowNPoints()->GetLstPointsY() );
//        bbSetOutputlstPointsZ( mwxwidget->GetModelShowNPoints()->GetLstPointsZ() );
 //       bbSetOutputlstLabels( mwxwidget->GetModelShowNPoints()->GetLstLabels() );
        bbSetOutputWidgetShowNPoints( (WidgetShowNPoints*)mwxwidget );
	} // mwxwidget
}

//-----------------------------------------------------------------
void ShowNPoints::CreateWidget(wxWindow* parent)
{
	mwxwidget = new WidgetShowNPointsBox( parent, this, bbGetInputType() );
    bbSetOutputWidget( mwxwidget );
}

//-----------------------------------------------------------------
void ShowNPoints::bbUserSetDefaultValues()
{
	mwxwidget = NULL;
	bbSetInputRadio(10);
	bbSetInputOpacity(1);
	std::vector<double> colour;
	colour.push_back(1.0);
	colour.push_back(1.0);
	colour.push_back(0.0);
	bbSetInputColour(colour);
	bbSetInputImage(NULL);
	bbSetInputType(0);
	bbSetInputRenderer(NULL);
	bbSetOutputWidgetShowNPoints(NULL);
}

//------------------  -----------------------------------------------
	void ShowNPoints::bbUserInitializeProcessing()
	{
	}

//-----------------------------------------------------------------
	void ShowNPoints::bbUserFinalizeProcessing()
	{
	}

//-----------------------------------------------------------------

}
// EO namespace bbcreaMaracasVisu
