/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuSliderMinMax.h"
#include "bbcreaMaracasVisuPackage.h"


namespace bbcreaMaracasVisu
{

  //------------------------------------------------------------------------------------------------------------------------------------
  // Event handling auxiliar class
  //------------------------------------------------------------------------------------------------------------------------------------
 
	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Constructors ans destructors
	  //--------------------------------------------------------------------------------------------------------------------------------
		wxWidgetSliderMinMax :: wxWidgetSliderMinMax(SliderMinMax *bbParent,mBarRange * modelBarRange)
		:wxEvtHandler()
		{			
			modBarRange         = modelBarRange;
			mbbtkSliderMinMax   = bbParent;
			Connect(modBarRange->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxWidgetSliderMinMax::onBarrange );
 //			Connect(modBarRange->GetId(),98765,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onActualChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onActualChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onStartChange_Bar );		
			Connect(modBarRange->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onEndChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onSelectionEnd );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onMovedBar );		
		}

		wxWidgetSliderMinMax ::  ~wxWidgetSliderMinMax()
		{
		}
		
		void wxWidgetSliderMinMax::PushEventHandler()
		{
			modBarRange->PushEventHandler(this);
		}

	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Min-Max Barrange received events
	  //--------------------------------------------------------------------------------------------------------------------------------
		void wxWidgetSliderMinMax :: onBarrange(wxCommandEvent& event)
		{
		}

		void wxWidgetSliderMinMax :: onActualChange_Bar(wxCommandEvent& event)
		{
			mbbtkSliderMinMax->bbSetOutputOutActual(modBarRange->GetActual());
			mbbtkSliderMinMax->bbSignalOutputModification(std::string("OutActual"));
		}

		void wxWidgetSliderMinMax :: onStartChange_Bar(wxCommandEvent& event)
		{
			mbbtkSliderMinMax->bbSetOutputOutStart(modBarRange->GetStart());
			mbbtkSliderMinMax->bbSetInputInMinShow(modBarRange->GetStart());
			mbbtkSliderMinMax->bbSignalOutputModification(std::string("OutStart"));
		}
	
		void wxWidgetSliderMinMax :: onEndChange_Bar(wxCommandEvent& event)
		{
			mbbtkSliderMinMax->bbSetOutputOutEnd(modBarRange->GetEnd());
			mbbtkSliderMinMax->bbSignalOutputModification(std::string("OutEnd"));
		}
	
		void wxWidgetSliderMinMax :: onSelectionEnd(wxCommandEvent& event)
		{
		}

		void wxWidgetSliderMinMax :: onMovedBar(wxCommandEvent& event)
		{
		}


  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------


BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,SliderMinMax)
BBTK_BLACK_BOX_IMPLEMENTATION(SliderMinMax,bbtk::WxBlackBox);

//------------------------------------------------------
void SliderMinMax::Process()
{
	if (mwxwidget!=NULL){
		mwxwidget -> setRepresentedValues( bbGetInputInMin(), bbGetInputInMax() );
		if (firsttime==true)
		{
			firsttime=false;
			mwxwidget -> SetStart(bbGetInputInMinShow());
			mwxwidget -> SetEnd(bbGetInputInMaxShow());  
		}
		bbSetOutputOutStart(mwxwidget->GetStart());
		bbSetOutputOutEnd(mwxwidget->GetEnd());
		bbSetOutputOutActual(mwxwidget->GetActual());
	} // mwxwidget
}

//------------------------------------------------------
void SliderMinMax::CreateWidget(wxWindow* parent)
{

    bbtkDebugMessageInc("Core",9,"SliderMinMax::CreateWidget()"<<std::endl);

	mwxwidget = new mBarRange(parent ,bbGetInputInW(), bbGetInputInH()); 
	mwxwidget -> SetOrientation( bbGetInputOrientation()==1 );
	mwxwidget -> setActiveStateTo(true);
	mwxwidget -> setVisibleLabels( bbGetInputShowLabels()==1 );
	mwxwidget -> setDeviceEndMargin(10);
//   	    mwxwidget -> setRepresentedValues(bbGetInputInMin(), bbGetInputInMax());
	mwxwidget -> setDeviceBlitStart(10,10); 
	mwxwidget -> setIfWithActualDrawed(bbGetInputShowActual());
//		mwxwidget -> SetStart(bbGetInputInMinShow());
//		mwxwidget -> SetEnd(bbGetInputInMaxShow());  


	wxWidgetSliderMinMax *eventHandler = new wxWidgetSliderMinMax(this, mwxwidget); 
	eventHandler->PushEventHandler();


	bbtkDebugDecTab("Core",9);

	bbSetOutputWidget( mwxwidget );


}

//------------------------------------------------------
void SliderMinMax::bbUserSetDefaultValues()
{
		firsttime	=	true;
		mwxwidget	=	NULL;
		bbSetInputOrientation(1);
		bbSetInputInW(200);
		bbSetInputInH(65);
		bbSetInputInMax(200);
		bbSetInputInMin(1);
		bbSetInputInMaxShow(200);
		bbSetInputInMinShow(1);
		bbSetInputShowLabels(1);
		bbSetInputShowActual(true);

		bbSetOutputOutStart(0);
		bbSetOutputOutEnd(0);
		bbSetOutputOutActual(0);
}

		
	//-----------------------------------------------------------------	
	void SliderMinMax::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void SliderMinMax::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	

}
// EO namespace bbcreaMaracasVisu


