/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuTransferFunctionView.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,TransferFunctionView)
BBTK_BLACK_BOX_IMPLEMENTATION(TransferFunctionView,bbtk::WxBlackBox);

//-----------------------------------------------------
void TransferFunctionView::Process()
{
	if(bbGetInputIn()!=NULL)
	{

//		if(_currentimg != bbGetInputIn())
//		{
			_currentimg =  bbGetInputIn();
			//mwxwidget->initializeHistogram(_currentimg);			
			mwxwidget->setImageData(_currentimg);	
			//mwxwidget->Refresh();	
//		}		

//		onColorChange();
		/*
		bbSetOutputGreyLevel(greylevel);
		bbSetOutputValue(value);
		bbSetOutputGreyLevelColors(greylevelcolors);
		bbSetOutputRed(red);
		bbSetOutputGreen(green);
		bbSetOutputBlue(blue);
		*/
	} // if In
}

void TransferFunctionView::onColorChange()
{

	std::vector<double> greylevel;
	std::vector<double> value;

	std::vector<double> greylevelcolors;
	std::vector<double> red;
	std::vector<double> green;
	std::vector<double> blue;

	mwxwidget->GetValuesPointsFunction(greylevel, value);
	mwxwidget->GetValuesColorPointsFunction(greylevelcolors,red, green,blue);


	_tfun->RemoveAllPoints();
	unsigned int i;
	for(i = 0; i < greylevel.size();i++){
		_tfun->AddPoint(greylevel[i], value[i]);
//		std::cout<<"TransferFunctionView::Process()transfer function "<<greylevel[i]<<" "<< value[i]<<std::endl;
	}
	_ctfun->RemoveAllPoints();
	_ctfun->SetScaleToLinear ();
	_ctfun->ClampingOff();
	_ctfun->AllowDuplicateScalarsOn();
	double w=mwxwidget->GetWindowLevel();
	double c=mwxwidget->GetColorLevel();

	if (greylevelcolors.size()>1)
	{
	    double min = greylevelcolors[0];
		double max = greylevelcolors[greylevelcolors.size()-1];
		double dif = max-min;
		if (dif==0) dif=0.0001;
		double nc;
		unsigned int i;
		i=0;
		_ctfun->AddRGBPoint(greylevelcolors[i], red[i],green[i], blue[i]);
		for(i = 0; i < greylevelcolors.size();i++)
		{
			nc = ((greylevelcolors[i]-min)/dif)*w + c-w/2;
//			_ctfun->AddRGBPoint(greylevelcolors[i], red[i],green[i], blue[i]);
			_ctfun->AddRGBPoint( nc , red[i],green[i], blue[i]);
//		std::cout<<"EED TransferFunctionView::Process()transfer color function <<"<<nc<<" "<<red[i]<<" "<<green[i]<<" "<<blue[i]<<std::endl;
		}
		i=greylevelcolors.size()-1;
		_ctfun->AddRGBPoint( greylevelcolors[i] , red[i],green[i], blue[i]);
	}		

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_tfun->Update();
#else
  //...
#endif
	bbSetOutputOpacityFunction(_tfun);
	bbSetOutputColorFunction(_ctfun );
	bbSetOutputActive( mwxwidget->GetActive() );

	bbSignalOutputModification();

}

void TransferFunctionView::onSliderChange()
{
		onColorChange();
		bbSignalOutputModification();
//	bbSetOutputWindowLevel(mwxwidget->GetWindowLevel());
//	bbSetOutputColorLevel(mwxwidget->GetColorLevel());
}


//-----------------------------------------------------
void TransferFunctionView::CreateWidget(wxWindow* parent)
{
	bbtkDebugMessageInc("Core",9,"TransferFunctionView::CreateWxWindow()"<<std::endl);	
	mwxwidget = new HistogramDialogComboBox(parent);				
	HandlerTransferFunctionView* handler = new HandlerTransferFunctionView(this);
//	parent->Connect(mwxwidget->GetId(), wxEVT_COMMAND_COMBOBOX_SELECTED, (wxObjectEventFunction) (&HandlerTransferFunctionView::onActive),NULL,handler);
	parent->Connect(mwxwidget->GetId(), wxEVT_COMMAND_COMBOBOX_SELECTED, (wxObjectEventFunction) (&HandlerTransferFunctionView::onColorChange),NULL,handler);
	parent->Connect(mwxwidget->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction) (&HandlerTransferFunctionView::onSliderChange),NULL,handler);
	bbSetOutputWidget( mwxwidget );				
    bbtkDebugDecTab("Core",9);
}

//-----------------------------------------------------

void TransferFunctionView::bbUserSetDefaultValues()
{
	mwxwidget 	= NULL;
	_currentimg = NULL;
	_tfun 		= NULL;
	_ctfun 		= NULL;   
	bbSetOutputOpacityFunction(0);
	bbSetOutputColorFunction(0);
}
	
	//-----------------------------------------------------------------	
	void TransferFunctionView::bbUserInitializeProcessing()
	{
		_tfun = vtkPiecewiseFunction::New();
		_ctfun = vtkColorTransferFunction::New();  
		_ctfun->SetClamping(-1);
		bbSetInputIn(NULL);
	}
	
	//-----------------------------------------------------------------	
	void TransferFunctionView::bbUserFinalizeProcessing()
	{
	}

	//-----------------------------------------------------------------	
	HandlerTransferFunctionView::HandlerTransferFunctionView(TransferFunctionView* box)
	{
		_box = box;		
	}
	
	HandlerTransferFunctionView::~HandlerTransferFunctionView()
	{
	}	
	
	void HandlerTransferFunctionView::onColorChange(wxCommandEvent& event)
	{
		_box->onColorChange();
	}
	
	void HandlerTransferFunctionView::onSliderChange(wxCommandEvent& event)
	{
		_box->onSliderChange();
	}

}

// EO namespace bbcreaMaracasVisu


