/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuViewerMPR.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------


  //--------------------------------------------------------------------------
  // wxWidgetMPR
  //--------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxWidgetMPR, wxPanel )
	EVT_MENU( 12121, wxWidgetMPR::OnRefreshView )
	EVT_MENU( 12122, wxWidgetMPR::OnDClickLeft  )
END_EVENT_TABLE( );

  //-----------
  //Constructor
  //-----------
  wxWidgetMPR::wxWidgetMPR(ViewerMPR* box,wxWindow* parent, marImageData	*marimagedata)
	  : wxPanel( parent, -1 )
  {
		wxPanel	*panel	= this;
		mbbViewerMPR	= box;

		
		wxwidget = new wxMPRWidget2( panel, marimagedata );	

		if(marimagedata != NULL){
			wxwidget->ConfigureVTK();
		}
		wxFlexGridSizer *sizer=new wxFlexGridSizer(1);
		sizer	-> Add( wxwidget,0,wxGROW ); 
		sizer	-> AddGrowableCol(1);
		panel	-> SetSizer(sizer);
		panel	-> SetAutoLayout(true);
		panel	-> Layout();		
  }

  void wxWidgetMPR::setImageData(vtkImageData* img)
  {
	  wxwidget->setImageData(img);
  }

  void wxWidgetMPR::ConfigureVTK()
  {
		wxwidget->ConfigureVTK();
  }

//--------------------------------------------------------------------------
  wxWidgetMPR::~wxWidgetMPR()
  {

  }
//--------------------------------------------------------------------------
  /*
	Getting the point
  */
  std::vector<int> wxWidgetMPR::GetPoint()
  {
	  return point;
  }
  /*
	Getting the render
  */
  vtkRenderer* wxWidgetMPR::GetRenderer()
  {
	if(wxwidget!=NULL)	
	{
		return  wxwidget->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
	}
	else
	{
		return NULL;
	}
}
	
//--------------------------------------------------------------------------
  void wxWidgetMPR::Refresh()
  { 
	  wxwidget->RefreshView();
  }

//--------------------------------------------------------------------------
  //---------------
  //Handling events
  //---------------
  void wxWidgetMPR::OnRefreshView(wxCommandEvent &event)
  {
  printf("EED wxWidgetMPR::OnRefreshView 01\n");
	  if((wxwidget!=NULL) && (mbbViewerMPR!=NULL))
	  {
		  printf("EED wxWidgetMPR::OnRefreshView 02\n");
	    point.clear();
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetX());
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetY());
		point.push_back((int)wxwidget->GetVtkMPRBaseData()->GetZ());
		mbbViewerMPR->bbSetOutputPoint( GetPoint() );
		mbbViewerMPR->bbSignalOutputModification(std::string("Point"));    
		wxwidget->RefreshView();
	  }
  }

//--------------------------------------------------------------------------
  void wxWidgetMPR::OnDClickLeft(wxCommandEvent & event) 
  {
	wxwidget->RefreshView();
  }

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------








BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ViewerMPR)
BBTK_BLACK_BOX_IMPLEMENTATION(ViewerMPR,bbtk::WxBlackBox);
void ViewerMPR::Process()
{
	if (wxwidget!=NULL){
		wxBusyCursor wait;	   
		vtkImageData* img = bbGetInputIn();
		if(img!=NULL && img != _img){
			_img = img;
			wxwidget->setImageData(_img);
			wxwidget->ConfigureVTK();
			
//			wxwidget->wxPanel::Refresh();
			wxwidget->Refresh();
//			wxwidget->Show();

		}	
			
		
		bbSetOutputPoint( wxwidget->GetPoint() );
		bbSetOutputRenderer( wxwidget->GetRenderer() );  
	} // wxwidget
}

void ViewerMPR::CreateWidget(wxWindow* parent)
{
	bbtkDebugMessageInc("Core",9,"ViewerMPR::CreateWidget() " <<std::endl);
	//JCP 10 - 03 - 09 marImageData	*marimagedata = new marImageData(bbGetInputIn() );
	bbtkDebugDecTab("Core",9);
	wxwidget = new wxWidgetMPR(this , parent);//JCP  10 - 03 - 09,marimagedata);
	bbSetOutputWidget( wxwidget );
}

void ViewerMPR::bbUserSetDefaultValues()
{		
		_img = NULL;
		wxwidget = NULL;
		bbSetInputIn(NULL);
}

	
	//-----------------------------------------------------------------	
	void ViewerMPR::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ViewerMPR::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	
}
// EO namespace bbcreaMaracasVisu


