/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbmaracasvisuViewerNV.h"
#include "bbcreaMaracasVisuPackage.h"
namespace bbcreaMaracasVisu
{

BEGIN_EVENT_TABLE( bbwxMaracas_N_ViewersWidget, wxPanel )
	EVT_MENU( 12121, bbwxMaracas_N_ViewersWidget::OnRefreshView )
	EVT_MENU( 12122, bbwxMaracas_N_ViewersWidget::OnDClickLeft  )
END_EVENT_TABLE( );


//-------------------------------------------------------------
//-------------------------------------------------------------
//-------------------------------------------------------------

bbwxMaracas_N_ViewersWidget::bbwxMaracas_N_ViewersWidget(ViewerNV* box,
                                                         wxWindow *parent,
                                                         vtkImageData* imagedata,
                                                         std::vector<int> *nTypeView)
:wxMaracas_N_ViewersWidget(parent,imagedata,nTypeView)
{
	mbbViewerNV	= box;
	backX		= -9999;
	backY		= -9999;
	backZ		= -9999;
}

//-------------------------------------------------------------
bbwxMaracas_N_ViewersWidget::~bbwxMaracas_N_ViewersWidget()
{
}

//-------------------------------------------------------------
void bbwxMaracas_N_ViewersWidget::OnRefreshView(wxCommandEvent & event)
{
	if ( (backX!=(int)GetX()) || (backY!=(int)GetY()) || (backZ!=(int)GetZ()) )
	{
		backX = GetX();
		backY = GetY();
		backZ = GetZ();
		mbbViewerNV->_point.clear();
		mbbViewerNV->_point.push_back( (int)GetX() );
		mbbViewerNV->_point.push_back( (int)GetY() );
		mbbViewerNV->_point.push_back( (int)GetZ() );
		mbbViewerNV->bbSetOutputPoint( mbbViewerNV->_point );
		mbbViewerNV->bbSignalOutputModification(std::string("Point"));
	} // if
	wxMaracas_N_ViewersWidget::OnRefreshView(event);
}

//-------------------------------------------------------------
void bbwxMaracas_N_ViewersWidget::OnDClickLeft(wxCommandEvent & event)
{
	wxMaracas_N_ViewersWidget::OnDClickLeft(event);
	mbbViewerNV->bbSignalOutputModification(std::string("Point"));
}

//-------------------------------------------------------------
//-------------------------------------------------------------
//-------------------------------------------------------------



BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaMaracasVisu,ViewerNV)
BBTK_BLACK_BOX_IMPLEMENTATION(ViewerNV,bbtk::WxBlackBox);
//-------------------------------------------------------------
void ViewerNV::Process()
{
	vtkImageData* img 		= bbGetInputIn();
	std::vector<int> type 	= bbGetInputnTypeView();
	if(img != NULL && _mwxwidget != NULL)
	{
		if(!compareVectors(type, _currenttype))
		{
			_mwxwidget->SetType(&type);
            _mwxwidget->SetTDxWindow( bbGetInputTDxWindow() );
			_mwxwidget->UpdateLayout(img);
		}else if (img != _currentimg){
			_mwxwidget->SetImage(img);
		}
//		_mwxwidget->RefreshView();
		_currenttype 	= type;
		_currentimg 	= img;
		_point.clear();
		_point.push_back( (int)_mwxwidget->GetX() );
		_point.push_back( (int)_mwxwidget->GetY() );
		_point.push_back( (int)_mwxwidget->GetZ() );
		bbSetOutputPoint( _point 				  );

		wxVtkBaseView *wvbv1 = _mwxwidget->GetwxVtkBaseView( 1 );
		wxVtkBaseView *wvbv2 = _mwxwidget->GetwxVtkBaseView( 2 );
		wxVtkBaseView *wvbv3 = _mwxwidget->GetwxVtkBaseView( 3 );
		wxVtkBaseView *wvbv4 = _mwxwidget->GetwxVtkBaseView( 4 );
		//wxwidget->RefreshView();
		bbSetOutputwxVtkBaseView1( wvbv1 );
		bbSetOutputwxVtkBaseView2( wvbv2 );
		bbSetOutputwxVtkBaseView3( wvbv3 );
		bbSetOutputwxVtkBaseView4( wvbv4 );
		if (wvbv1!=NULL) { bbSetOutputRenderer1( wvbv1->GetRenderer() ); }
		if (wvbv2!=NULL) { bbSetOutputRenderer2( wvbv2->GetRenderer() ); }
		if (wvbv3!=NULL) { bbSetOutputRenderer3( wvbv3->GetRenderer() ); }
		if (wvbv4!=NULL) { bbSetOutputRenderer4( wvbv4->GetRenderer() ); }
		if (wvbv1!=NULL)
		{
			bbSetOutputInteractor1( wvbv1->GetWxVTKRenderWindowInteractor() );
			updateObservers();
		}
		if(bbGetInputColorFunction()!=NULL)
		{
			_mwxwidget->setColorTransferFunction(bbGetInputColorFunction());
		}
		if( (bbGetInputColorLevel()!=-1) && (bbGetInputWindowLevel()!=-1))
		{
			if(bbGetInputColorLevel() == 0)
			{
				_mwxwidget->SetColorWindowLevel( bbGetInputWindowLevel() , 0.1 );
			}else{
				_mwxwidget->SetColorWindowLevel( bbGetInputWindowLevel() , bbGetInputColorLevel() );
			}
		}
		_mwxwidget->SetInterpolate( bbGetInputInterpolate() );
/* Borrame
		if (wvbv1!=NULL) 
		{
			wxCommandEvent newevent(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
			//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
			#if wxMAJOR_VERSION <= 2
				wvbv1->GetWxVTKRenderWindowInteractor ()->GetParent()->ProcessEvent( newevent );
			#else
				wvbv1->GetWxVTKRenderWindowInteractor ()->GetParent()->ProcessWindowEvent( newevent );
			#endif				
		}

*/
	}//  mwxwidget != NULL
}

//-------------------------------------------------------------
void ViewerNV::CreateWidget(wxWindow* parent)
{
    bbtkDebugMessageInc("Core",9,"ViewerNV::CreateWidget()"<<std::endl);
	_mwxwidget = new bbwxMaracas_N_ViewersWidget( this, parent );
	bbtkDebugDecTab("Core",9);
    bbSetOutputWidget( _mwxwidget );
	//this->bbSignalOutputModification();
	//Process();
}

//-------------------------------------------------------------
void ViewerNV::bbUserSetDefaultValues()
{
	_currentimg				=	NULL;
	_mwxwidget				=	NULL;
	bbSetInputIn(NULL);

	bbSetInputObs1(NULL);
	bbSetInputObs2(NULL);
	bbSetInputObs3(NULL);
	bbSetInputObs4(NULL);
	bbSetInputObs5(NULL);
	bbSetInputInterpolate(true);

	std::vector<int> vecNTypeViwer;
	vecNTypeViwer.push_back(5);
	vecNTypeViwer.push_back(1);
	vecNTypeViwer.push_back(2);
	vecNTypeViwer.push_back(0);
	bbSetInputnTypeView(vecNTypeViwer);
    bbSetInputTDxWindow( -1 );

	bbSetOutputwxVtkBaseView1( NULL );
	bbSetOutputwxVtkBaseView2( NULL );
	bbSetOutputwxVtkBaseView3( NULL );
	bbSetOutputwxVtkBaseView4( NULL );
	bbSetOutputRenderer1( NULL );
	bbSetOutputRenderer2( NULL );
	bbSetOutputRenderer3( NULL );
	bbSetOutputRenderer4( NULL );
	bbSetInputColorFunction(NULL);
	bbSetInputWindowLevel(-1);
	bbSetInputColorLevel(-1);
}

//-----------------------------------------------------------------
void ViewerNV::bbUserInitializeProcessing()
{
}

//-----------------------------------------------------------------
void ViewerNV::bbUserFinalizeProcessing()
{
}

//-----------------------------------------------------------------

bool ViewerNV::compareVectors(std::vector<int> type,std::vector<int> currenttype)
{
	bool ret = true;
	if(type.size()==currenttype.size())
	{
		for(int i = 0; i < (int)(type.size()) && ret; i++)
		{
			if(type[i]!=currenttype[i])
			{
				ret = false;
			} // if
		} // for
	}else{
		ret=false;
	} // type size
	return ret;
}

void ViewerNV::updateObservers()
{
	vtkRenderWindowInteractor* interactor;
	interactor = bbGetOutputInteractor1();
	if(interactor)
	{
		if (bbGetInputObs1()!=NULL)
		{
		  bbGetInputObs1()->SetInteractor(interactor);
		  bbGetInputObs1()->EnabledOn();
		}
		if (bbGetInputObs2()!=NULL)
		{
		  bbGetInputObs2()->SetInteractor(interactor);
		  bbGetInputObs2()->EnabledOn();
		}
		if (bbGetInputObs3()!=NULL)
		{
		  bbGetInputObs3()->SetInteractor(interactor);
		  bbGetInputObs3()->EnabledOn();
		}
		if (bbGetInputObs4()!=NULL)
		{
		  bbGetInputObs4()->SetInteractor(interactor);
		  bbGetInputObs4()->EnabledOn();
		}
		if (bbGetInputObs5()!=NULL)
		{
		  bbGetInputObs5()->SetInteractor(interactor);
		  bbGetInputObs5()->EnabledOn();
		}
	} // if interactor
}

}
// EO namespace bbcreaMaracasVisu

