/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuViewerNV_h_INCLUDED__
#define __bbcreaMaracasVisuViewerNV_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"
#include "vtkRenderer.h"

#include "wxVtkBaseView.h"

//#include "widgets/wxMPRWidget.h"
//#include "widgets/wxMaracas_ViewerWidget.h"
//#include "widgets/wxMaracas_N_ViewersWidget.h"

#include "wxMPRWidget.h"
#include "wxMaracas_ViewerWidget.h"
#include "wxMaracas_N_ViewersWidget.h"

#include "vtkImagePlaneWidget.h"

namespace bbcreaMaracasVisu
{
  class ViewerNV;
  class bbwxMaracas_N_ViewersWidget : public wxMaracas_N_ViewersWidget
  {
	public:
		bbwxMaracas_N_ViewersWidget(ViewerNV* box,wxWindow *parent, vtkImageData* imagedata=NULL, std::vector<int> *nTypeView=NULL);
		~bbwxMaracas_N_ViewersWidget();
		//if the MPR had generated the refresh event
		void OnRefreshView(wxCommandEvent &event);
		void OnDClickLeft(wxCommandEvent &event);
	private:
		int backX;
		int backY;
		int backZ;
		ViewerNV			*mbbViewerNV;
	DECLARE_EVENT_TABLE( );
  };

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

class /*BBTK_EXPORT*/ ViewerNV
 :
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ViewerNV,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_INPUT(In, vtkImageData *);
  BBTK_DECLARE_INPUT(nTypeView, std::vector<int> );
  BBTK_DECLARE_INPUT(ColorFunction, vtkColorTransferFunction* );
  BBTK_DECLARE_INPUT(WindowLevel, double );
  BBTK_DECLARE_INPUT(ColorLevel, double );
  BBTK_DECLARE_INPUT(Obs1, vtkInteractorObserver *);
  BBTK_DECLARE_INPUT(Obs2, vtkInteractorObserver *);
  BBTK_DECLARE_INPUT(Obs3, vtkInteractorObserver *);
  BBTK_DECLARE_INPUT(Obs4, vtkInteractorObserver *);
  BBTK_DECLARE_INPUT(Obs5, vtkInteractorObserver *);
  BBTK_DECLARE_INPUT(Interpolate, bool);
  BBTK_DECLARE_INPUT(TDxWindow, int);


  BBTK_DECLARE_OUTPUT(wxVtkBaseView1,wxVtkBaseView*);
  BBTK_DECLARE_OUTPUT(wxVtkBaseView2,wxVtkBaseView*);
  BBTK_DECLARE_OUTPUT(wxVtkBaseView3,wxVtkBaseView*);
  BBTK_DECLARE_OUTPUT(wxVtkBaseView4,wxVtkBaseView*);
  BBTK_DECLARE_OUTPUT(Renderer1,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Renderer2,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Renderer3,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Renderer4,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Interactor1,vtkRenderWindowInteractor*);
  BBTK_DECLARE_OUTPUT(Point,std::vector<int>);

  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow* parent);

   std::vector<int>				_point;
private:

	vtkImageData				*_currentimg;
	std::vector<int>			_currenttype;
	wxMaracas_N_ViewersWidget	*_mwxwidget;
	
	bool compareVectors(std::vector<int> type,std::vector<int> currenttype);
	void updateObservers();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ViewerNV,bbtk::WxBlackBox);
BBTK_NAME("ViewerNV");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Viewer : N view configuration 2D and 3D");
  BBTK_CATEGORY("viewer");
  BBTK_INPUT(ViewerNV,Title,"Title prepended to the text",std::string,"");
  BBTK_INPUT(ViewerNV,In,"Input image",vtkImageData*,"");
  BBTK_INPUT(ViewerNV,nTypeView,"vector of viewer types (default 5 1 2 0): -1=Z_2DwithOutAxis 0=Z_2D 1=X_2D 2=Y_2D 3=Plane 4=Sphere 5=3D 6=3Dplane 7=3D_empty",std::vector<int>,"");
  BBTK_INPUT(ViewerNV,ColorFunction,"Optional: set a different color for the viewers 2D",vtkColorTransferFunction*,"");
  BBTK_INPUT(ViewerNV,WindowLevel,"Optional: set a different Window level by using an other widget",double,"");
  BBTK_INPUT(ViewerNV,ColorLevel,"Optional: set a different Color level by using an other widget",double,"");
  BBTK_INPUT(ViewerNV,Obs1,"Optional: set a different Color level by using an other widget",vtkInteractorObserver*,"");
  BBTK_INPUT(ViewerNV,Obs2,"Optional: set a different Color level by using an other widget",vtkInteractorObserver*,"");
  BBTK_INPUT(ViewerNV,Obs3,"Optional: set a different Color level by using an other widget",vtkInteractorObserver*,"");
  BBTK_INPUT(ViewerNV,Obs4,"Optional: set a different Color level by using an other widget",vtkInteractorObserver*,"");
  BBTK_INPUT(ViewerNV,Obs5,"Optional: set a different Color level by using an other widget",vtkInteractorObserver*,"");
  BBTK_INPUT(ViewerNV,Interpolate,"Interpolate true/false (default true)",bool,"");
  BBTK_INPUT(ViewerNV,TDxWindow,"(default -1) -1:No TDx  [0..3]:window",int,"");

  BBTK_OUTPUT(ViewerNV,wxVtkBaseView1,"wxVtkBaseView 1",wxVtkBaseView  *,"");
  BBTK_OUTPUT(ViewerNV,wxVtkBaseView2,"wxVtkBaseView 2",wxVtkBaseView  *,"");
  BBTK_OUTPUT(ViewerNV,wxVtkBaseView3,"wxVtkBaseView 3",wxVtkBaseView  *,"");
  BBTK_OUTPUT(ViewerNV,wxVtkBaseView4,"wxVtkBaseView 4",wxVtkBaseView  *,"");
  BBTK_OUTPUT(ViewerNV,Renderer1,"Renderer 1",vtkRenderer *,"");
  BBTK_OUTPUT(ViewerNV,Renderer2,"Renderer 2",vtkRenderer *,"");
  BBTK_OUTPUT(ViewerNV,Renderer3,"Renderer 3",vtkRenderer *,"");
  BBTK_OUTPUT(ViewerNV,Renderer4,"Renderer 4",vtkRenderer *,"");
  BBTK_OUTPUT(ViewerNV,Interactor1,"Interactor1",vtkRenderWindowInteractor *,"");
  BBTK_OUTPUT(ViewerNV,Point,"Axis point",std::vector<int>,"");

BBTK_END_DESCRIBE_BLACK_BOX(ViewerNV);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuViewerNV_h_INCLUDED__
#endif // _USE_WXWIDGETS_
