/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSurfaceRenderingManager.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:17:03 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasSurfaceRenderingManager.h"
#include "wxMaracasSurfaceRenderingManagerDataMhd.h"

/**
**	Start of the manager class
**/
wxMaracasSurfaceRenderingManager::wxMaracasSurfaceRenderingManager(){
	_renderer = NULL;
	_interactor = NULL;
	_idCount=0;
        image = 0;
}
wxMaracasSurfaceRenderingManager::~wxMaracasSurfaceRenderingManager(){
}

/**
**	Sets the renderer to manage the prop3D from the surface render
**/
void wxMaracasSurfaceRenderingManager::setRenderer(vtkRenderer*  renderer){
	_renderer = renderer;
}

/**
**	Sets the renderer to manage the prop3D from the surface render
**/
void wxMaracasSurfaceRenderingManager::setInteractor(vtkRenderWindowInteractor*  interactor){
	_interactor = interactor;
}


/**
** Gets the renderer to manage the prop3D from the surface render
**/
vtkRenderer* wxMaracasSurfaceRenderingManager::getRenderer(){
	return _renderer;
}

/**
** Updates volume
**/
// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::Update(int pid)throw(char *)
void wxMaracasSurfaceRenderingManager::Update(int pid)
{
	try {
  		wxMaracasSurfaceRenderingManagerData* data = this->getViewData(pid);	
		((wxMaracasSurfaceRenderingManagerDataMhd*)data)->UpdateSurface();
		_renderer->Render(); 
	} catch (...) {
	  throw ;
	}
}

/**
**	Adds a prop3D to the manager and returns the identifier
**/
// EED 2022-08-04	
//int wxMaracasSurfaceRenderingManager::addProp3D(int idTP, vtkProp3D* prop3D, std::string dataname)  throw(char*){
int wxMaracasSurfaceRenderingManager::addProp3D(int idTP, vtkProp3D* prop3D, std::string dataname){
        //checkInvariant();
	try {
		if(prop3D != NULL)
		{
			wxMaracasSurfaceRenderingManagerData* data = new wxMaracasSurfaceRenderingManagerData(prop3D, dataname, _interactor);
			prop3Dvect.push_back(data);
			_renderer->AddActor(data->getProp3D());
			if(idTP == -1)
			{
				data->setId(_idCount);
				_idCount++;
			}
			else
			{
				data->setId(idTP);
			}
			return data->getId();
		}else{
			throw "Check vtkProp3D file or input";
		}
		return -1;
	} catch (...) {
	  throw ;
	}

}

/**
**	Adds a polydata and creates the prop3D (actor) to the manager and returns the identifier
**/
/**
**	Adds a polydata and creates the prop3D (actor) to the manager and returns the identifier
**/
int wxMaracasSurfaceRenderingManager::addProp3D(int idTP, std::string filename, std::string dataname){


    wxMaracasSurfaceRenderingManagerData* data = new wxMaracasSurfaceRenderingManagerData(filename, _interactor);
    if(dataname.compare("") != 0)
        data->setDataname(dataname);

    prop3Dvect.push_back(data);
    _renderer->AddActor(data->getProp3D());
    if(idTP == -1)
    {
            data->setId(_idCount);
            _idCount++;
    }
    else
    {
            data->setId(idTP);
    }
    return data->getId();

}

// EED 2022-08-04	
//int wxMaracasSurfaceRenderingManager::addPropMHD(int idTP, vtkImageData* imagedata, std::string dataname) throw(char*){
int wxMaracasSurfaceRenderingManager::addPropMHD(int idTP, vtkImageData* imagedata, std::string dataname) {
	try{
		checkInvariant();
		if(imagedata != NULL){                
			image = imagedata;
			wxMaracasSurfaceRenderingManagerData* data = new wxMaracasSurfaceRenderingManagerDataMhd(imagedata, dataname, _interactor);
			prop3Dvect.push_back(data);	
			_renderer->AddActor(data->getProp3D());
			if(idTP == -1)
			{
				data->setId(_idCount);
				_idCount++;
			}
			else
			{
				data->setId(idTP);
			}
			printf("wxMaracasSurfaceRenderingManager::addPropMHD->idSurfaceRender: %i\n", data->getId());
			return data->getId();
		}else{
			throw "Check ImageData file or input";
		}
		return -1;
	} catch (...) {
	  throw ;
	}	
}
/**
**	adds or removes an actor depending of the bool value
**/
// EED 2022-08-04	
//bool wxMaracasSurfaceRenderingManager::addRemoveActor(int propid, bool addremove)  throw(char*){
bool wxMaracasSurfaceRenderingManager::addRemoveActor(int propid, bool addremove) {
	try{
		checkInvariant();
		
		    wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);
		    if(data && data->getProp3D()!=NULL){
			if(addremove){
				_renderer->AddViewProp(data->getProp3D());
			}else{
				_renderer->RemoveViewProp(data->getProp3D());
			}
			_renderer->Render();
		            return true;
		    }else {
		        if(addremove && propid == 0 && image){
		            addPropMHD(0, image, "id0");
		            return true;
		        }
		    }
		    return false;
	} catch (...) {
		throw ;
	}
}
/**
**	adds or removes the surface box depending of the bool value
**/
// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::addRemoveSurfaceBox(int propid, bool addremove)  throw(char*){
void wxMaracasSurfaceRenderingManager::addRemoveSurfaceBox(int propid, bool addremove) 
{
	try{
		checkInvariant();	
		wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);		
		if(data->getProp3D()!=NULL){
			data->addRemoveSurfaceBox(addremove);
			/*if(addremove){
				data->
				_renderer->AddViewProp(data->getProp3D());
			}else{
				_renderer->RemoveViewProp(data->getProp3D());
			}
			_renderer->Render();*/
		}
	} catch (...) {
		throw ;
	}	
}

/**
**	Changes the opacity in a prop3D
**/
// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::changeOpacity(int propid, int value)  throw(char*){
void wxMaracasSurfaceRenderingManager::changeOpacity(int propid, int value)  
{
	try{
		checkInvariant();	
		this->getViewData(propid)->changeOpacity(value);
		_renderer->Render();
	} catch (...) {
		throw ;
	}	
}

/**
**	changes the isovalue in a prop3D
**/
void wxMaracasSurfaceRenderingManager::changeIsoValue(int propid, double value ){
	checkInvariant();	
	wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);		
	//_renderer->RemoveActor(data->getProp3D());
	((wxMaracasSurfaceRenderingManagerDataMhd*)data)->changeIsoValue(value);
	//_renderer->AddActor(data->getProp3D());
	_renderer->Render();
}

/**
**	changes the isovalue in a prop3D
**/
void wxMaracasSurfaceRenderingManager::changeIsoValue(int propid, double min, double max ){
        checkInvariant();
        wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);
        //_renderer->RemoveActor(data->getProp3D());
        ((wxMaracasSurfaceRenderingManagerDataMhd*)data)->changeIsoValue(min, max);
        //_renderer->AddActor(data->getProp3D());
        _renderer->Render();
}

/*vtkProp3D* wxMaracasSurfaceRenderingManager:: getProp3D(std::string filename){
	if(filename.compare("")!= 0){

            vtkSmartPointer<vtkPolyData> polydata = vtkSmartPointer<vtkPolyData>::New();
            std::string ext = filename.substr(filename.find_last_of("."), 4);
            if(ext.compare(STL)==0){
                vtkSmartPointer<vtkSTLReader> STLReader=vtkSmartPointer<vtkSTLReader>::New();
		STLReader->SetFileName(filename.c_str());
		STLReader->Update();
                polydata->DeepCopy(STLReader->GetOutput());

            }else if(ext.compare(PLY)==0){
                vtkSmartPointer<vtkPLYReader> plyreader =vtkSmartPointer<vtkPLYReader>::New();
                plyreader->SetFileName(filename.c_str());
                plyreader->Update();
                polydata->DeepCopy(plyreader->GetOutput());
            }else if(ext.compare(VTK)==0){
                vtkSmartPointer<vtkPolyDataReader> polyreader =vtkSmartPointer<vtkPolyDataReader>::New();
                polyreader->SetFileName(filename.c_str());
                polyreader->Update();
                polydata->DeepCopy(polyreader->GetOutput());
            }

            vtkSmartPointer<vtkPolyDataMapper> dataMapper = vtkSmartPointer<vtkPolyDataMapper>::New();
            dataMapper->SetInput(polydata);

            vtkActor* dataActor = vtkActor::New();
            dataActor->SetMapper(dataMapper);
            dataActor->GetProperty()->SetOpacity(1);
            return dataActor;
	}	
	return NULL;
}*/

vtkImageData* wxMaracasSurfaceRenderingManager::getImageData(std::string filename)
{
	if(filename.compare("")!= 0)
	{		
		vtkMetaImageReader* reader =  vtkMetaImageReader::New();	
		reader->SetFileName(filename.c_str());
		reader->Update();
		vtkImageData* img = reader->GetOutput();
		//reader->Delete();
		return img;
	}	
	return NULL;
}

vtkImageData* wxMaracasSurfaceRenderingManager::getImageData()
{
	return image;
}

void wxMaracasSurfaceRenderingManager::setImageData(vtkImageData* img)
{
    image = img;
}

// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::checkInvariant()  throw(char*)
void wxMaracasSurfaceRenderingManager::checkInvariant()  
{
	try{
		if(this->_renderer==NULL)
		{
			throw "Renderer not set";
		}
	} catch (...) {
		throw ;
	}	
}

// EED 2022-08-04	
//wxMaracasSurfaceRenderingManagerData* wxMaracasSurfaceRenderingManager::getViewData(int id) throw(char*)
wxMaracasSurfaceRenderingManagerData* wxMaracasSurfaceRenderingManager::getViewData(int id) 
{
	try{
		int i = 0;
		for(i = 0; i < (int)(prop3Dvect.size());i++){
		        if(prop3Dvect[i]->getId() == id){
		                return prop3Dvect[i];
		        }
		}    
	#ifndef USE_QT
		throw "id not found in the data";
	#else
		return 0;
	#endif
	} catch (...) {
		throw ;
	}	
}

// EED 2022-08-04	
//int wxMaracasSurfaceRenderingManager::getMaxIsoValue(int propid) throw(char*)
int wxMaracasSurfaceRenderingManager::getMaxIsoValue(int propid) 
{	
	try{
		return ((wxMaracasSurfaceRenderingManagerDataMhd*)this->getViewData(propid))->getMaxGreyLevel();
	} catch (...) {
		throw ;
	}	
}

// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::changeColor(int propid, double red, double green, double blue) throw(char*)
void wxMaracasSurfaceRenderingManager::changeColor(int propid, double red, double green, double blue)
{
	try{
		checkInvariant();	
		this->getViewData(propid)->changeColor(red, green, blue);
		_renderer->Render();
	} catch (...) {
		throw ;
	}	
		
}

// EED 2022-08-04	
//void wxMaracasSurfaceRenderingManager::deleteActor(int propid) throw (char *)
void wxMaracasSurfaceRenderingManager::deleteActor(int propid) 
{
	try{
		checkInvariant();	
		this->addRemoveActor(propid, false);
		int i,n;
		bool exit = false;
		for(i = 0; i < (int)(prop3Dvect.size())&&!exit;i++){
			if(prop3Dvect[i]->getId() == propid){			
				n=i;
				exit = true;
			}
		}
		if(exit){
			wxMaracasSurfaceRenderingManagerData* data = prop3Dvect[n];			
			int j;
			for(j = i; j < (int)(prop3Dvect.size())-1;j++){
				prop3Dvect[j] = prop3Dvect[j+1];
			}		
			delete data;
			prop3Dvect.pop_back();
		}else{
	#ifndef USE_QT
		            throw "id not found in the data";
	#endif
		} 
	} catch (...) {
		throw ;
	}	
	  
}

void wxMaracasSurfaceRenderingManager::enableBoundingBox(int propid, bool enable){
    checkInvariant();

    wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);

    if(data)
        data->enableBoxWidget(enable);
}
void wxMaracasSurfaceRenderingManager::Transform(vtkMatrix4x4* tmatrix){
	
}

bool wxMaracasSurfaceRenderingManager::interactorSet(){
	return _interactor? true:false;
}

void wxMaracasSurfaceRenderingManager::saveProp3DSTL(int propid,const char* filename){
    checkInvariant();

    wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);
    if(data->getProp3D()!=NULL){
            data->saveProp3DSTL(filename);
    }
}

void wxMaracasSurfaceRenderingManager::loadProp3DSTL(const char* filename){
    this->addProp3D(-1, filename);
}

void wxMaracasSurfaceRenderingManager::exportImageStencil(int propid,const char* filename){
    checkInvariant();

    wxMaracasSurfaceRenderingManagerData* data = this->getViewData(propid);
    if(data && data->getProp3D()!=NULL){
            data->exportImageStencil(filename);
    }
}
