/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "volumerendererdata.h"
#include "vtkObjectFactory.h"


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
vtkCxxRevisionMacro(VolumeRendererData, "$Revision: 1.11 $");
#else
  //...
#endif

vtkStandardNewMacro(VolumeRendererData);

VolumeRendererData::VolumeRendererData()
{
    VolRendManager	= NULL;
    ImageData		= NULL;
    Renderer		= NULL;
    Interactor		= NULL;
    LookUpTable		= NULL;
    //ImageDataSeparateComponents = false;
}


void VolumeRendererData::ShowVolume(bool checked){
    try{
        if(checked){
                invariant();
                if(!VolRendManager){
                    VolRendManager = new VolumeRendererManager();
                    VolRendManager->addVolume(ImageData, Interactor);
                }
                if(LookUpTable)
				{
                    VolRendManager->SetLookupTable(LookUpTable);
				}
                vector< vtkProp3D* > props = VolRendManager->getProps3D();
                for(unsigned i = 0; i < props.size(); i++){
                    Renderer->AddActor(props[i]);
                }

        }else{
            vector< vtkProp3D* > props = VolRendManager->getProps3D();
            for(unsigned i = 0; i < props.size(); i++){
                Renderer->RemoveActor(props[i]);
            }
            delete VolRendManager;
            VolRendManager = 0;
        }
    }catch(char* e){
        cout<<"Exception in: "<<e<<endl;
    }catch(exception e){
        cout<<"Exception in: "<<e.what()<<endl;
    }

}

void VolumeRendererData::invariant()
{
    if(!ImageData)
	{
        throw "Image data not set";
    }
    if(!Renderer)
	{
        throw "renderer not initialized";
    }
}

void VolumeRendererData::OpacityChanged(vector<double> greyvalues, vector<double> values)
{
    //invariant();
    if(VolRendManager!=NULL)
	{
        ShowVolume(true);
		VolRendManager->setVolumeOpacity(greyvalues,values);
	}	
}


void  VolumeRendererData::BoundingBoxChanged(bool checked){
   // invariant();

    if(VolRendManager==NULL)
    {
         ShowVolume(true);
    }


    if(VolRendManager && Interactor){
        if(checked){
            VolRendManager->EnableBoundingBox(Interactor);
        }else{
            VolRendManager->DisableBoundingBox();
        }
    }
	
}


void VolumeRendererData::changeCompositeMIPFunction(int function){
    invariant();
    if(VolRendManager)
	{
        VolRendManager->changeCompositeMIPFunction(0, function);
	}
}

/**
  changes the interoplation type of the volume
  type = 0 linear
  type = 1 nearest
   */
void VolumeRendererData::changeInterpolationType(int type){
    invariant();
    if(VolRendManager)
	{
        VolRendManager->changeInterpolationType(type);
	}	
}
