/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef VOLUMERENDERERDATA_H
#define VOLUMERENDERERDATA_H


#include "volumerenderermanager.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkObject.h"

using namespace std;

class VolumeRendererData : public vtkObject
{
public:
    static VolumeRendererData *New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
    vtkTypeRevisionMacro(VolumeRendererData,vtkObject);
#else
    vtkTypeMacro(VolumeRendererData,vtkObject);
#endif

    //

    vtkSetObjectMacro(ImageData, vtkImageData);
    //vtkSetMacro(ImageDataSeparateComponents, bool);

    vtkSetObjectMacro(Renderer, vtkRenderer);
    vtkSetObjectMacro(LookUpTable, vtkLookupTable);
    vtkSetObjectMacro(Interactor, vtkRenderWindowInteractor);



    void BoundingBoxChanged(bool checked);
     void ShowVolume(bool enable);
     void OpacityChanged(vector<double> greyvalues, vector<double> values);

     /**
       chages the ray cast function type
       function = 0 composite
       function = 1 MIP (maximum intensity pixel)
       */
    void changeCompositeMIPFunction(int function);

    /**
      changes the interoplation type of the volume
      type = 0 linear
      type = 1 nearest
       */
    void changeInterpolationType(int type);


protected:
    VolumeRendererData();
    VolumeRendererManager		*VolRendManager;
    vtkImageData				*ImageData;
    vtkRenderer					*Renderer;
    vtkLookupTable				*LookUpTable;
    vtkRenderWindowInteractor	*Interactor;

//    bool ImageDataSeparateComponents;


private:

    void invariant();
};

#endif // VOLUMERENDERERDATA_H
