/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "qtsurfacerenderer.h"
#include "ui_qtsurfacerenderer.h"


#include <qtsurfacerendererpanel.h>

QtSurfaceRenderer::QtSurfaceRenderer(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::QtSurfaceRenderer)
{
    ui->setupUi(this);

    this->ui->tabWidgetSurface->removeTab(1);
    this->ui->tabWidgetSurface->removeTab(0);

    QtSurfaceRendererPanel* surfacepanel = new QtSurfaceRendererPanel(this);
    this->ui->tabWidgetSurface->addTab(surfacepanel, QString("Surface Rendering"));

    Renderer = 0;
    Interactor = 0;
}
void QtSurfaceRenderer::SetRenderer(vtkRenderer* render){
    Renderer = render;
    this->ui->tabWidgetSurface->setCurrentIndex(0);
    QtSurfaceRendererPanel* surfacepanel = (QtSurfaceRendererPanel*)this->ui->tabWidgetSurface->currentWidget();
    surfacepanel->setRenderer(Renderer);
}

void QtSurfaceRenderer::SetInteractor(vtkRenderWindowInteractor* interactor){
    Interactor = interactor;
    this->ui->tabWidgetSurface->setCurrentIndex(0);
    QtSurfaceRendererPanel* surfacepanel = (QtSurfaceRendererPanel*)this->ui->tabWidgetSurface->currentWidget();
    surfacepanel->setInteractor(Interactor);
}

QtSurfaceRenderer::~QtSurfaceRenderer()
{
    delete ui;
}

void QtSurfaceRenderer::SetImageData(vtkImageData* img){
    this->ui->tabWidgetSurface->setCurrentIndex(0);
    QtSurfaceRendererPanel* surfacepanel = (QtSurfaceRendererPanel*)this->ui->tabWidgetSurface->currentWidget();
    surfacepanel->setImageData(img);
}

void QtSurfaceRenderer::on_pushbuttonAddTab_clicked()
{

    QtSurfaceRendererPanel* surfacepanel = new QtSurfaceRendererPanel(this);    
    surfacepanel->setRenderer(Renderer);
    surfacepanel->setInteractor(Interactor);

    this->ui->tabWidgetSurface->addTab(surfacepanel, QString("Surface Rendering"));
}

void QtSurfaceRenderer::on_tabWidgetSurface_tabCloseRequested(int index)
{
    if(index != 0){

        QtSurfaceRendererPanel* surfacepanel = (QtSurfaceRendererPanel*)this->ui->tabWidgetSurface->currentWidget();
        surfacepanel->enableBoundingBox(0, false);
        surfacepanel->deleteActor(0);

        this->ui->tabWidgetSurface->removeTab(index);
    }
}

