/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef QTSURFACERENDERER_H
#define QTSURFACERENDERER_H

#include <QWidget>
#include "wxMaracasSurfaceRenderingManager.h"

namespace Ui {
    class QtSurfaceRenderer;
}

class QtSurfaceRenderer : public QWidget,public vtkObject
{
    Q_OBJECT

public:
    explicit QtSurfaceRenderer(QWidget *parent = 0);

    ~QtSurfaceRenderer();

    void SetRenderer(vtkRenderer* render);
    void SetInteractor(vtkRenderWindowInteractor* interactor);

    void SetImageData(vtkImageData* img);
private slots:
    void on_pushbuttonAddTab_clicked();

    void on_tabWidgetSurface_tabCloseRequested(int index);


private:
    Ui::QtSurfaceRenderer *ui;

    vtkRenderer* Renderer;
    vtkRenderWindowInteractor* Interactor;
};

#endif // QTSURFACERENDERER_H
