/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "qtsurfacerendererpanel.h"
#include "ui_qtsurfacerendererpanel.h"

#include "qfiledialog.h"

#include "qcolordialog.h"
#include "qmessagebox.h"

#include "Color.xpm"
#include "Save.xpm"
#include "OpenImage.xpm"

QtSurfaceRendererPanel::QtSurfaceRendererPanel(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::QtSurfaceRendererPanel)
{
    ui->setupUi(this);


    this->ui->pushButtonColorChooser->setIcon(QIcon(Color_xpm));
    //this->ui->pushButtonSave->setIcon(QIcon(Save_xpm));
    this->ui->pushButtonOpen->setIcon(QIcon(OpenImage_xpm));

    this->ui->comboBoxSave->addItem(QIcon(Save_xpm), QString(""));
    this->ui->comboBoxSave->addItem(QString("Save surface"));
    this->ui->comboBoxSave->addItem(QString("Export image stencil"));
    _ImageSet = false;
}

QtSurfaceRendererPanel::~QtSurfaceRendererPanel()
{   
    delete ui;
}
void QtSurfaceRendererPanel::setImageData(vtkImageData* img){
    double *range  =img->GetScalarRange();

    this->ui->horizontalSliderMinIso->setRange(range[0], range[1]);

    this->ui->horizontalSliderMaxIso->setRange(range[0], range[1]);

    wxMaracasSurfaceRenderingManager::setImageData(img);
    _ImageSet = true;
}

void QtSurfaceRendererPanel::on_OpacitySlider_valueChanged(int value)
{
    try{

        this->ui->lineEditOpacity->setText(QString::number(value));


        this->changeOpacity(0, value);
    }catch(char * e){
        cout<<e<<endl;
        QMessageBox::critical(this, tr("Volume Rendering"), tr(e), QMessageBox::Ok);
    }
}

void QtSurfaceRendererPanel::on_pushButtonColorChooser_clicked()
{
    QColorDialog* qcolor = new QColorDialog(this);



    if(qcolor->exec()){

        QColor color = qcolor->selectedColor();

        int r = 0, g = 0, b = 0;
        color.getRgb(&r, &g, &b);

        try{

            this->changeColor(0, r/255.0, g/255.0 ,b/255.0);
        }catch(char * e){
            cout<<e<<endl;
            QMessageBox::critical(this, tr("Surface Rendering"), tr(e), QMessageBox::Ok);
        }
    }


}

void QtSurfaceRendererPanel::on_checkBox_clicked(bool checked)
{
    if(!this->addRemoveActor(0, checked)){
        this->ui->checkBox->setChecked(false);
    }else if(!checked){
        this->ui->checkBoxBoundingBox->setCheckState(Qt::Unchecked);
        this->on_checkBoxBoundingBox_clicked(false);
    }
}

void QtSurfaceRendererPanel::on_horizontalSliderMaxIso_valueChanged(int value)
{

    this->ui->lineEditMaxIso->setText(QString::number(value));
}

void QtSurfaceRendererPanel::on_horizontalSliderMinIso_valueChanged(int value)
{
    this->ui->lineEditMinIso->setText(QString::number(value));
}

void QtSurfaceRendererPanel::on_horizontalSliderMaxIso_sliderReleased()
{
    onIsoValueChanged();
}

void QtSurfaceRendererPanel::on_horizontalSliderMinIso_sliderReleased()
{
    onIsoValueChanged();
}

void QtSurfaceRendererPanel::onIsoValueChanged(){
    if(_ImageSet)
        this->changeIsoValue(0, this->ui->horizontalSliderMinIso->value(), this->ui->horizontalSliderMaxIso->value());
}

/*void QtSurfaceRendererPanel::on_pushButtonSave_clicked()
{
    QString filename = QFileDialog::getSaveFileName(this,
                                                    tr("Save Mesh File"),
                                                    QDir::currentPath(),
                                                    tr("Mesh files (*.stl *.ply *.vtk)") );

    if( !filename.isNull() ){
        //filename.append(".stl");
        this->saveProp3DSTL(0, filename.toStdString().c_str());
    }

}*/

void QtSurfaceRendererPanel::on_checkBoxBoundingBox_clicked(bool checked)
{
    this->enableBoundingBox(0, checked);

}

void QtSurfaceRendererPanel::on_pushButtonOpen_clicked(bool checked)
{

}

void QtSurfaceRendererPanel::on_pushButtonOpen_clicked()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Load Mesh File"), QDir::currentPath(),  tr("Mesh files (*.stl *.ply *.vtk)"));

    if(!filename.isNull()){
        this->loadProp3DSTL(filename.toStdString().c_str());
        this->ui->checkBox->setCheckState(Qt::Checked);
    }
}

void QtSurfaceRendererPanel::on_comboBoxSave_activated(int index)
{
    if(index == 1){
        QString filename = QFileDialog::getSaveFileName(this,
                                                        tr("Save Mesh File"),
                                                        QDir::currentPath(),
                                                        tr("Mesh files (*.stl *.ply *.vtk)") );

        if( !filename.isNull() ){
            //filename.append(".stl");
            this->saveProp3DSTL(0, filename.toStdString().c_str());
        }
    }else if(index == 2){

        QString filename = QFileDialog::getSaveFileName(this,
                                                        tr("Save Image File"),
                                                        QDir::currentPath(),
                                                        tr("Meta Image file (*.mhd)") );

        if( !filename.isNull() ){

            this->exportImageStencil(0, filename.toStdString().c_str());
        }
    }
    this->ui->comboBoxSave->setCurrentIndex(0);
}
