/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef QTSURFACERENDERERPANEL_H
#define QTSURFACERENDERERPANEL_H

#include <QWidget>

#include "wxMaracasSurfaceRenderingManager.h"
#include "vtkImageData.h"

namespace Ui {
    class QtSurfaceRendererPanel;
}

class QtSurfaceRendererPanel : public QWidget, public wxMaracasSurfaceRenderingManager
{
    Q_OBJECT

public:
    explicit QtSurfaceRendererPanel(QWidget *parent = 0);
    ~QtSurfaceRendererPanel();

    virtual void setImageData(vtkImageData* img);
private slots:    

    void on_OpacitySlider_valueChanged(int value);

    void on_pushButtonColorChooser_clicked();

    void on_checkBox_clicked(bool checked);    

    void on_horizontalSliderMaxIso_valueChanged(int value);

    void on_horizontalSliderMinIso_valueChanged(int value);

    void on_horizontalSliderMaxIso_sliderReleased();

    void on_horizontalSliderMinIso_sliderReleased();

    //void on_pushButtonSave_clicked();

    void on_checkBoxBoundingBox_clicked(bool checked);

    void on_pushButtonOpen_clicked(bool checked);

    void on_pushButtonOpen_clicked();


    void on_comboBoxSave_activated(int index);

private:
    Ui::QtSurfaceRendererPanel *ui;


    void onIsoValueChanged();

    bool _ImageSet;
};

#endif // QTSURFACERENDERERPANEL_H
