/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "qtvtkviewer.h"

#include "vtkImageMapToColors.h"

QtVTKViewer::QtVTKViewer(QWidget* parent)
    : QVTKWidget(parent)
{


    vtkRenderer* renderer = vtkRenderer::New();
    this->GetRenderWindow()->AddRenderer(renderer);
    this->GetRenderWindow()->GetRenderers()->GetFirstRenderer()->SetBackground(1,1,1);

    SuperImagePlaneWidget::initialize(this->GetRenderWindow()->GetInteractor());

    this->GetRenderWindow()->GetRenderers()->GetFirstRenderer()->ResetCamera();    


    _rayorigin[0] = 0;
    _rayorigin[1] = 0;
    _rayorigin[2] = 0;
    _rayorigin[3] = 0;

    _imageindex[0] = 0;
    _imageindex[1] = 0;
    _imageindex[2] = 0;

}

void QtVTKViewer::mouseMoveEvent(QMouseEvent* event){
    int x=0, y=0;

    QVTKWidget::mouseMoveEvent(event);

    x = event->pos().x();
    y = this->size().height() - event->pos().y();

#ifdef debug
    std::cout<<"X= "<<x<<" Y= "<<y<<std::endl;
#endif


    this->GetRenderWindow()->GetRenderers()->GetFirstRenderer()->SetDisplayPoint(x, y, 0);
    this->GetRenderWindow()->GetRenderers()->GetFirstRenderer()->DisplayToWorld();
    this->GetRenderWindow()->GetRenderers()->GetFirstRenderer()->GetWorldPoint(_rayorigin);
#ifdef debug
    std::cout<<"X= "<<x<<" Y= "<<y<<std::endl;
    std::cout<<"X= "<<_rayorigin[0]<<" Y= "<<_rayorigin[1]<<" Z= "<<_rayorigin[2]<<" R= "<<_rayorigin[3]<<std::endl;
#endif





}

void QtVTKViewer::mousePressEvent(QMouseEvent* event){
    QVTKWidget::mousePressEvent(event);
    vtkImagePlaneWidget * temp = 0;
    if(_xwidget->GetCursorDataStatus()==1){
        temp = _xwidget;
    }else if(_ywidget->GetCursorDataStatus()==1){
        temp = _ywidget;
    }else if(_zwidget->GetCursorDataStatus()==1){
        temp = _zwidget;
    }

    if(temp){
        _imageindex[0]=temp->GetCurrentCursorPosition()[0];
        _imageindex[1]=temp->GetCurrentCursorPosition()[1];
        _imageindex[2]=temp->GetCurrentCursorPosition()[2];
#ifdef debug
         std::cout<<"X= "<<_imageindex[0]<<" Y= "<<_imageindex[1]<<" Z= "<<_imageindex[2]<<std::endl;
#endif
    }
}

void QtVTKViewer::SetOutputFormatToRGBA(){
    _xwidget->GetColorMap()->SetOutputFormatToRGBA();
    _ywidget->GetColorMap()->SetOutputFormatToRGBA();
    _zwidget->GetColorMap()->SetOutputFormatToRGBA();
}
