/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef QTVTKVIEWER_H
#define QTVTKVIEWER_H


#include <QWidget>
#include <QMouseEvent>

#include "QVTKWidget.h"
#include "imageplanewidget.h"

class QtVTKViewer : public QVTKWidget, public ImagePlaneWidget
{

public:

    QtVTKViewer(QWidget* parent);

    typedef ImagePlaneWidget SuperImagePlaneWidget;

    void SetOutputFormatToRGBA();
private:

    void invariant();

    /**
    *   @brief double  _imageindex contains the current point on the image selected by the user, can be used to perform segmentation algorithms on the image i.e the seed for regiongrowing
    *
    */
    double _imageindex[3];
    /**
    *   @brief double  _rayorigin contains the origin position of the clicked performed by the user, can be used to perform ray intersection algorithms i.e
    *       finding an object in the scene
    *
    */
    double _rayorigin[4];        

protected:
    // overloaded mouse press handler
    virtual void mousePressEvent(QMouseEvent* event);
    // overloaded mouse move handler
    virtual void mouseMoveEvent(QMouseEvent* event);
    // overloaded mouse release handler
    //virtual void mouseReleaseEvent(QMouseEvent* event);

};

#endif // QTVTKVIEWER_H
