/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "qtvtkviewerwidget.h"
#include "ui_qtvtkviewerwidget.h"



QtVTKViewerWidget::QtVTKViewerWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::QtVTKViewerWidget)
{
    ui->setupUi(this);

    ui->m_VolumeRender->SetRenderer(this->getRenderer());
    ui->m_VolumeRender->SetInteractor(ui->_qtvtkviewer->GetRenderWindow()->GetInteractor());

    ui->m_SurfaceRender->SetRenderer(this->getRenderer());
    ui->m_SurfaceRender->SetInteractor(ui->_qtvtkviewer->GetRenderWindow()->GetInteractor());

}

QtVTKViewerWidget::~QtVTKViewerWidget()
{

}

vtkRenderer* QtVTKViewerWidget::getRenderer(){
    return ui->_qtvtkviewer->GetRenderWindow()->GetRenderers()->GetFirstRenderer();
}

void QtVTKViewerWidget::setImage(vtkImageData* img){


    ui->checkBoxShowPlanes->setChecked(true);
    ui->_qtvtkviewer->setImage(img);
    ui->m_VolumeRender->SetImageData(img);
    ui->m_SurfaceRender->SetImageData(img);

    int *extent = img->GetExtent();


    ui->horizontalSliderX->setRange(extent[0], extent[1]);
    ui->horizontalSliderY->setRange(extent[2], extent[3]);
    ui->horizontalSliderZ->setRange(extent[4], extent[5]);

}

void QtVTKViewerWidget::SetLookupTable(vtkLookupTable *lookuptable){

    ui->_qtvtkviewer->SetLookupTable(lookuptable);
    ui->m_VolumeRender->SetLookUpTable(lookuptable);
}

void QtVTKViewerWidget::on_checkBoxShowPlanes_clicked(){

    ui->_qtvtkviewer->showPlanes(ui->checkBoxShowPlanes->isChecked());
}

void QtVTKViewerWidget::SetOutputFormatToRGBA(){
    ui->_qtvtkviewer->SetOutputFormatToRGBA();
}

void QtVTKViewerWidget::on_checkBoxShowImageActor_clicked(bool checked)
{
    if(!(ui->_qtvtkviewer->showImageActors(checked))){
        ui->checkBoxShowImageActor->setCheckState(Qt::Unchecked);
    }
}

void QtVTKViewerWidget::on_horizontalSliderX_valueChanged(int value)
{

    ui->lineEditX->setText(QString::number(value));
    ui->_qtvtkviewer->setSliceXImageActor(value);

}

void QtVTKViewerWidget::on_horizontalSliderY_valueChanged(int value)
{
    ui->lineEditY->setText(QString::number(value));
    ui->_qtvtkviewer->setSliceYImageActor(value);
}

void QtVTKViewerWidget::on_horizontalSliderZ_valueChanged(int value)
{
    ui->lineEditZ->setText(QString::number(value));
    ui->_qtvtkviewer->setSliceZImageActor(value);
}
