/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "qtvolumerendererpanel.h"
#include "ui_qtvolumerendererpanel.h"
#include "qmessagebox.h"

using namespace std;

QtVolumeRendererPanel::QtVolumeRendererPanel(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::QtVolumeRendererPanel)
{
    ui->setupUi(this);    
}

QtVolumeRendererPanel::~QtVolumeRendererPanel()
{
    delete ui;
}

void QtVolumeRendererPanel::on_checkBoxShowVolume_clicked(bool checked)
{
    try{
        ShowVolume(checked);
        //JCP 27/09/12
        //on_opacitySlider_valueChanged(this->ui->opacitySlider->value());
    }catch(char * e){
        cout<<e<<endl;
        QMessageBox::critical(this, tr("Volume Rendering"), tr(e), QMessageBox::Ok);
    }catch(exception e){
        cout<<e.what()<<endl;
        QMessageBox::critical(this, tr("Volume Rendering"), tr(e.what()), QMessageBox::Ok);
    }
}


void QtVolumeRendererPanel::on_opacitySlider_valueChanged(int value)
{
    try{        
        this->ui->lineEditOpacity->setText(QString::number(value));        

        double* range = ImageData->GetScalarRange();
        vector<double> greylevel;
        greylevel.push_back(0);  //first grey level
        //greylevel.push_back(1);
        greylevel.push_back(10);
        greylevel.push_back(20);
        greylevel.push_back(range[1]);

        vector<double> vectvalue;
        vectvalue.push_back(0);  //first opacity value
        //vectvalue.push_back(value/100.0);
        vectvalue.push_back(0);
        vectvalue.push_back(value/100.0);
        vectvalue.push_back(value/100.0);

        OpacityChanged(greylevel, vectvalue);
    }catch(char * e){
        cout<<e<<endl;
        QMessageBox::critical(this, tr("Volume Rendering"), tr(e), QMessageBox::Ok);
    }
}

void QtVolumeRendererPanel::on_checkBoxBoundingBox_clicked(bool checked)
{
    try{
        BoundingBoxChanged(checked);
    }catch(char * e){
        cout<<e<<endl;
        QMessageBox::critical(this, tr("Volume Rendering"), tr(e), QMessageBox::Ok);
    }
}

void QtVolumeRendererPanel::on_radioButtonMIP_clicked(bool checked)
{
    if(checked){
        this->changeCompositeMIPFunction(1);
    }
}

void QtVolumeRendererPanel::on_radioButtonComposite_clicked(bool checked)
{
    if(checked){
        this->changeCompositeMIPFunction(0);
    }
}

void QtVolumeRendererPanel::on_radioButtonLinear_clicked(bool checked)
{
    if(checked){
        this->changeInterpolationType(0);
    }
}

void QtVolumeRendererPanel::on_radioButtonNearest_clicked(bool checked)
{
    if(checked){
        this->changeInterpolationType(1);
    }
}

void QtVolumeRendererPanel::on_radioButtonMinIP_clicked(bool checked)
{
    if(checked){
        this->changeCompositeMIPFunction(2);
    }
}
