/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasSurfaceRendering.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:37 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// EOF - wxMaracasMPR.cxx

#include "wxMaracasSurfaceRendering.h"
#include "wxMaracasSurfaceRenderingProp3DMHD.h"
#include "wxMaracasSurfaceRenderingProp3D.h"

#include <wx/colordlg.h>
#include <wx/bmpbuttn.h>

#include <OpenImage.xpm>
#include <Color.xpm>

wxMaracasSurfaceRendering* wxMaracasSurfaceRendering::instance=NULL;

wxMaracasSurfaceRendering::wxMaracasSurfaceRendering( wxWindow* parent,std::string path)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){

	surrendmanager = new wxMaracasSurfaceRenderingManager();

	wxauimanager = new wxAuiManager(this);

	_path = path;

	std::string iconsdir = path;
	iconsdir+="/data/Icons";
	this->_toolb = new ToolBar(this,iconsdir);
	
	wxStaticText* txt = new wxStaticText(this, -1, wxString(_T("  Surface Rendering  ")));
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(txt,paneinfo.ToolbarPane().Top());
	wxauimanager->AddPane(_toolb,paneinfo.ToolbarPane().Top());

	wxauimanager->Update();
	createFileChooser();
}
wxMaracasSurfaceRendering::~wxMaracasSurfaceRendering( ){
	delete _toolb;
}

std::string wxMaracasSurfaceRendering::getPath(){
	return _path;
}

void wxMaracasSurfaceRendering::createFileChooser(){

}

wxMaracasSurfaceRendering* wxMaracasSurfaceRendering::getInstance(wxWindow* parent,std::string path){
	if(instance==NULL){
		instance = new wxMaracasSurfaceRendering(parent,path);
	}
	return instance;
}

wxMaracasSurfaceRendering* wxMaracasSurfaceRendering::getInstance(){
	return instance;
}

void wxMaracasSurfaceRendering::setRenderer(vtkRenderer*  renderer){
	surrendmanager->setRenderer(renderer);
}

void wxMaracasSurfaceRendering::setInteractor(vtkRenderWindowInteractor*  interactor){
	surrendmanager->setInteractor(interactor);
}

void wxMaracasSurfaceRendering::addRemoveActor(int propid, bool addremove){
	try{
		surrendmanager->addRemoveActor(propid, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}
void wxMaracasSurfaceRendering::addRemoveSurfaceBox(int propid, bool addremove){
	try{
		surrendmanager->addRemoveSurfaceBox(propid, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}


void wxMaracasSurfaceRendering::changeOpacity(int _propid, int value){
	try{
		surrendmanager->changeOpacity(_propid,value);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

void wxMaracasSurfaceRendering::changeIsoValue(int propid, double value){
	try{
		surrendmanager->changeIsoValue(propid, value);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

void wxMaracasSurfaceRendering::changeColor(int propid, double red, double green, double blue){
	try{
		surrendmanager->changeColor(propid, red, green, blue);

	}catch(char* str){

		wxString s( str,wxConvUTF8 );
		wxMessageDialog* diag = new wxMessageDialog(this, s, s, wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

void wxMaracasSurfaceRendering::onLoadImageFile(){

	wxString mhd(_T("mhd"));
	wxString stl(_T("stl"));

	wxFileDialog* fildial = new wxFileDialog(this, wxString(_T("Select a STL file")),wxString(_T("")),
		wxString(_T("")),wxString(_T("STL files (*.stl)|*.stl|MHD files (*.mhd)|*.mhd")) );

	if(fildial->ShowModal()==wxID_OK){
        wxString filename = fildial->GetFilename();
		wxString pathfile(fildial->GetDirectory() + _T("/") + filename);

		if(filename.EndsWith(mhd))
		{
			loadPropMHD(pathfile,filename);
		}
		else if(filename.EndsWith(stl)){
            loadProp3D(pathfile,filename);
		}
	}
	delete fildial;
}

void wxMaracasSurfaceRendering::loadPropMHD(wxString filename, wxString dataname){

	std::string s = std::string(filename.mb_str());
	vtkImageData* img = surrendmanager->getImageData(s);
	if(img!=NULL){
		s = std::string(dataname.mb_str());
		addPropMHD(img, s);
	}
}

void wxMaracasSurfaceRendering::addPropMHD(vtkImageData* imgdata, std::string dataname){
	try{
		int id = surrendmanager->addPropMHD(-1, imgdata,dataname);
		if(id!=-1){

			wxMaracasSurfaceRenderingPanel* controlpan = new wxMaracasSurfaceRenderingProp3DMHD(this, id, false, -1);
			int maxiso = surrendmanager->getMaxIsoValue(id);
			((wxMaracasSurfaceRenderingProp3DMHD*)controlpan)->createControls(maxiso);
			addSurfaceRenderingPanel(controlpan, dataname);
		}

	}catch(char* str){

		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString( str,wxConvUTF8 ), wxString( str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

void wxMaracasSurfaceRendering::loadProp3D(wxString filename, wxString dataname){
        std::string fn = std::string(filename.mb_str());
        std::string dn = std::string(dataname.mb_str());

        int id = surrendmanager->addProp3D(-1, fn, dn);

        if(id!=-1){
                wxMaracasSurfaceRenderingPanel* controlpan = new wxMaracasSurfaceRenderingProp3D(this, id, false, -1);
                addSurfaceRenderingPanel(controlpan, dn);
        }
        /*vtkProp3D* prop3D = surrendmanager->getProp3D(s);
	if(prop3D != NULL){
		s = std::string(dataname.mb_str() );
		this->addProp3D(prop3D,s);
	}else{
		//TODO msj to the user indicating error in file
        }*/
}

void wxMaracasSurfaceRendering::addProp3D(vtkProp3D* prop3D, std::string dataname){
	try{
		int id = surrendmanager->addProp3D(-1, prop3D,dataname);
		if(id!=-1){
			wxMaracasSurfaceRenderingPanel* controlpan = new wxMaracasSurfaceRenderingProp3D(this, id, false, -1);
			addSurfaceRenderingPanel(controlpan, dataname);
		}
	}catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}
void wxMaracasSurfaceRendering::addSurfaceRenderingPanel(wxMaracasSurfaceRenderingPanel* surrend, std::string dataname){

	wxString s(dataname.c_str(),wxConvUTF8 );
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(surrend, paneinfo.DefaultPane().Centre().DestroyOnClose().Caption(s));
	wxauimanager->Update();
}

void wxMaracasSurfaceRendering::deleteActor(int propid){
	try{
		surrendmanager->deleteActor(propid);
	}catch(char* str){
		//CPR
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
		delete diag;
	}
}

bool wxMaracasSurfaceRendering::interactorSet(){
	return surrendmanager->interactorSet();
}

/**
**
**/

ToolBar::ToolBar(wxWindow * parent,std::string iconsdir)
: wxToolBar(parent, -1, wxDefaultPosition, wxDefaultSize)
{
	std::string iconfil = iconsdir;

	//iconfil+= "/OpenImage.png";
	//wxBitmap* bitmap0 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	wxBitmap bitmap0(OpenImage_xpm);

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	this->AddTool(1, wxString(_T("test")),bitmap0, NULL, wxITEM_NORMAL, wxString(_T("Open File")));
#else
	this->AddTool(1, wxString(_T("test")),bitmap0,  wxString(_T("Open File")),  wxITEM_NORMAL );
#endif

	
	/*iconfil+= "/Open.png";
	wxBitmap* bitmap2 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	this->AddTool(2, wxString(_T("test")),*bitmap2);	*/

	/*iconfil = iconsdir;
	iconfil+= "/Open.png";
	wxBitmap* bitmap30 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	this->AddTool(30, wxString(_T("test")),*bitmap30);*/

	this->Realize();

	_evthand = new ToolBarEventHandler();
	this->SetEventHandler(_evthand);
}

ToolBar::~ToolBar(void){
}

ToolBarEventHandler::ToolBarEventHandler()
: wxEvtHandler(){
}

ToolBarEventHandler::~ToolBarEventHandler(){
}

void ToolBarEventHandler::onLoadImageFile(wxCommandEvent& event){
	wxMaracasSurfaceRendering::getInstance()->onLoadImageFile();
}


BEGIN_EVENT_TABLE(ToolBarEventHandler, wxEvtHandler)
	EVT_MENU(1, ToolBarEventHandler::onLoadImageFile)
END_EVENT_TABLE()


